/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.smallghost;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SmallGhostTakeSaplingBlockGoal
extends Goal {
    private final SmallGhostEntity ghost;
    private final int scanRadius;
    private final double speed;
    private final float lerp;
    private int nextScanTick;
    @Nullable
    private BlockPos targetPos;

    public SmallGhostTakeSaplingBlockGoal(SmallGhostEntity ghost, int scanRadius, double speed, float lerp) {
        this.ghost = ghost;
        this.scanRadius = Math.max(2, scanRadius);
        this.speed = speed;
        this.lerp = lerp;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (!this.ghost.getHoldItem().m_41619_()) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.ghost.f_19797_ < this.nextScanTick) {
            return false;
        }
        this.nextScanTick = this.ghost.f_19797_ + 20;
        this.targetPos = this.findSaplingBlock();
        return this.targetPos != null;
    }

    public boolean m_8045_() {
        if (this.ghost.m_9236_().f_46443_) {
            return false;
        }
        if (!this.ghost.getHoldItem().m_41619_()) {
            return false;
        }
        if (this.ghost.getIsSleeping()) {
            return false;
        }
        if (this.targetPos == null) {
            return false;
        }
        BlockState st = this.ghost.m_9236_().m_8055_(this.targetPos);
        if (!st.m_204336_(BlockTags.f_13104_)) {
            return false;
        }
        double max = (double)this.scanRadius + 2.0;
        return this.ghost.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.targetPos)) <= max * max;
    }

    public void m_8056_() {
        this.ghost.f_19794_ = false;
        if (this.ghost.getIsSleeping()) {
            this.ghost.setIsSleeping(false);
        }
        if (this.ghost.getCdFullHide() > 0) {
            this.ghost.setCdFullHide(0);
        }
    }

    public void m_8041_() {
        this.targetPos = null;
        this.ghost.m_20256_(this.ghost.m_20184_().m_82490_(0.6));
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            this.m_8041_();
            return;
        }
        BlockState blockState = this.ghost.m_9236_().m_8055_(this.targetPos);
        if (!blockState.m_204336_(BlockTags.f_13104_)) {
            this.m_8041_();
            return;
        }
        Vec3 center = Vec3.m_82512_((Vec3i)this.targetPos).m_82520_(0.0, 0.15, 0.0);
        this.ghost.m_21563_().m_24946_(center.f_82479_, center.f_82480_, center.f_82481_);
        double takeDistSqr = 1.8225000000000002;
        if (this.ghost.m_20182_().m_82557_(center) <= takeDistSqr) {
            this.ghost.setHoldItem(new ItemStack((ItemLike)blockState.m_60734_().m_5456_()));
            this.ghost.m_9236_().m_7731_(this.targetPos, Blocks.f_50016_.m_49966_(), 3);
            this.m_8041_();
            return;
        }
        this.steerSmooth(center);
    }

    private void steerSmooth(Vec3 target) {
        Vec3 delta = target.m_82546_(this.ghost.m_20182_());
        double distance = delta.m_82553_();
        if (distance < 0.001) {
            return;
        }
        double slowRadius = 2.2;
        double speed = this.speed * Mth.m_14008_((double)(distance / slowRadius), (double)0.15, (double)1.0);
        Vec3 velocity = delta.m_82490_(speed / distance);
        Vec3 currentVelocity = this.ghost.m_20184_();
        this.ghost.m_20334_(Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82479_, (double)velocity.f_82479_), Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82480_, (double)velocity.f_82480_), Mth.m_14139_((double)this.lerp, (double)currentVelocity.f_82481_, (double)velocity.f_82481_));
    }

    @Nullable
    private BlockPos findSaplingBlock() {
        BlockPos origin = this.ghost.m_20183_();
        BlockPos best = null;
        double bestDist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 48; ++i) {
            double distance;
            int dx = this.ghost.m_217043_().m_216339_(-this.scanRadius, this.scanRadius + 1);
            int dz = this.ghost.m_217043_().m_216339_(-this.scanRadius, this.scanRadius + 1);
            int dy = this.ghost.m_217043_().m_216339_(-3, 4);
            BlockPos blockPos = origin.m_7918_(dx, dy, dz);
            BlockState blockState = this.ghost.m_9236_().m_8055_(blockPos);
            if (!blockState.m_204336_(BlockTags.f_13104_) || !((distance = this.ghost.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)blockPos))) < bestDist)) continue;
            bestDist = distance;
            best = blockPos.m_7949_();
        }
        return best;
    }
}

