/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.kodama;

import dev.xylonity.bonsai.ghosts.common.entity.PassiveEntity;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsSounds;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KodamaEntity
extends PassiveEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation RATTLE = RawAnimation.begin().thenPlay("rattle");
    private final RawAnimation RATTLE_2 = RawAnimation.begin().thenPlay("rattle_2");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation BARTER = RawAnimation.begin().thenPlay("barter");
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> RATTLING_TICKS = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BARTER_TICKS = SynchedEntityData.m_135353_(KodamaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int ANIMATION_RATTLING_TICKS = 38;
    private static final int ANIMATION_BARTER_TICKS = 50;
    private float flashAlpha;
    private int rattleAnimationType;

    public KodamaEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.flashAlpha = 0.0f;
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return AbstractGolem.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22279_, (double)0.24f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            public void m_8056_() {
                super.m_8056_();
                if (KodamaEntity.this.isBartering()) {
                    KodamaEntity.this.setBarterTicks(0);
                    KodamaEntity.this.m_19983_(new ItemStack((ItemLike)Items.f_151049_));
                    KodamaEntity.this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                if (KodamaEntity.this.isBartering() || KodamaEntity.this.getRattlingTicks() > 0) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (KodamaEntity.this.isBartering() || KodamaEntity.this.getRattlingTicks() > 0) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(RATTLING_TICKS, (Object)0);
        this.f_19804_.m_135372_(BARTER_TICKS, (Object)0);
    }

    public void setFlashAlpha(float flashAlpha) {
        this.flashAlpha = flashAlpha;
    }

    public float getFlashAlpha() {
        return this.flashAlpha;
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setRattlingTicks(int variant) {
        this.f_19804_.m_135381_(RATTLING_TICKS, (Object)variant);
    }

    public int getRattlingTicks() {
        return (Integer)this.f_19804_.m_135370_(RATTLING_TICKS);
    }

    public void setBarterTicks(int ticks) {
        this.f_19804_.m_135381_(BARTER_TICKS, (Object)ticks);
    }

    public int getBarterTicks() {
        return (Integer)this.f_19804_.m_135370_(BARTER_TICKS);
    }

    public boolean isBartering() {
        return this.getBarterTicks() > 0;
    }

    protected boolean shouldPanic() {
        return this.m_21188_() != null || this.m_203117_() || this.m_6060_();
    }

    public boolean m_7243_(ItemStack stack) {
        if (this.isBartering() || this.getRattlingTicks() > 0 || this.shouldPanic() || !this.m_20096_()) {
            return false;
        }
        if (!this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            return false;
        }
        return stack.m_150930_(Items.f_151049_);
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        boolean isAmethyst = stack.m_150930_(Items.f_151049_);
        if (!this.m_9236_().f_46443_ && isAmethyst && stack.m_41613_() > 1) {
            ItemStack one = stack.m_41620_(1);
            itemEntity.m_32045_(stack);
            this.m_8061_(EquipmentSlot.MAINHAND, one);
            if (!this.isBartering()) {
                this.setBarterTicks(1);
                this.m_9236_().m_5594_(null, this.m_20183_(), GhostsSounds.KODAMA_IDLE.get(), SoundSource.NEUTRAL, 0.7f, 1.2f);
            }
            return;
        }
        boolean wasAmethyst = stack.m_150930_(Items.f_151049_);
        super.m_7581_(itemEntity);
        if (!this.m_9236_().f_46443_ && wasAmethyst) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_151049_));
            if (!this.isBartering()) {
                this.setBarterTicks(1);
                this.m_9236_().m_5594_(null, this.m_20183_(), GhostsSounds.KODAMA_IDLE.get(), SoundSource.NEUTRAL, 0.7f, 1.2f);
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack inHand = player.m_21120_(hand);
        if (inHand.m_150930_(Items.f_151049_)) {
            if (this.isBartering()) {
                return InteractionResult.SUCCESS;
            }
            if (!this.m_9236_().f_46443_) {
                if (!player.m_150110_().f_35937_) {
                    inHand.m_41774_(1);
                }
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_151049_));
                this.setBarterTicks(1);
                this.m_9236_().m_5594_(null, this.m_20183_(), GhostsSounds.KODAMA_IDLE.get(), SoundSource.NEUTRAL, 0.7f, 1.2f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean ok;
            long dayTime = this.m_9236_().m_46468_() % 24000L;
            if (!this.shouldPanic() && this.getRattlingTicks() <= 0) {
                if (dayTime >= 13000L && dayTime <= 13200L) {
                    this.startRattling(0.1f);
                } else {
                    this.startRattling(0.001f);
                }
            }
            boolean bl = ok = !this.shouldPanic() && this.getRattlingTicks() > 0 && this.m_20096_();
            if (!ok) {
                this.setRattlingTicks(0);
            }
            if (this.getRattlingTicks() > 0) {
                this.setRattlingTicks(this.getRattlingTicks() - 1);
            }
            if (this.getBarterTicks() > 0) {
                this.setBarterTicks(this.getBarterTicks() + 1);
            }
            if (this.getBarterTicks() == 50) {
                this.doBarter();
                this.setBarterTicks(0);
            }
        }
    }

    private void doBarter() {
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        ItemStack sapling = this.getRandomSaplingStack();
        if (!sapling.m_41619_()) {
            this.m_5552_(sapling, 0.35f);
            this.m_9236_().m_5594_(null, this.m_20183_(), GhostsSounds.KODAMA_RATTLE.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
        } else {
            this.m_5552_(new ItemStack((ItemLike)GhostsBlocks.HAUNTED_SAPLING.get()), 0.35f);
        }
    }

    private ItemStack getRandomSaplingStack() {
        ArrayList items = new ArrayList();
        BuiltInRegistries.f_257033_.m_203431_(ItemTags.f_13180_).ifPresent(named -> named.forEach(holder -> {
            Item item = (Item)holder.m_203334_();
            if (item == Items.f_151012_ || item == Items.f_151013_) {
                return;
            }
            items.add(item);
        }));
        if (items.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Item picked = (Item)items.get(this.m_9236_().f_46441_.m_188503_(items.size()));
        return new ItemStack((ItemLike)picked);
    }

    private void startRattling(float chance) {
        if (this.m_9236_().f_46441_.m_188501_() > chance) {
            return;
        }
        this.setRattlingTicks(38);
        this.m_9236_().m_5594_(null, this.m_20183_(), GhostsSounds.KODAMA_RATTLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Variant")) {
            this.setVariant(compound.m_128451_("Variant"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
    }

    public static boolean checkKodamaSpawnRules(EntityType<? extends Animal> kodama, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return KodamaEntity.isDarkEnoughToSpawn(level, pos, random) && KodamaEntity.m_217057_(kodama, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = level.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && level.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.m_6018_().m_46470_() ? level.m_46849_(pos, 10) : level.m_46803_(pos);
        return j <= dimensiontype.m_223569_().m_214085_(random);
    }

    public int m_213860_() {
        return this.m_9236_().f_46441_.m_188503_(4) + 2;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag dataTag) {
        if (this.getVariant() == 0) {
            this.setVariant(level.m_6018_().f_46441_.m_188503_(4) + 1);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected SoundEvent m_7515_() {
        return GhostsSounds.KODAMA_IDLE.get();
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getRattlingTicks() == 37) {
            this.rattleAnimationType = this.m_9236_().f_46441_.m_188503_(2);
        }
        if (this.getBarterTicks() > 0) {
            event.setAnimation(this.BARTER);
        } else if (this.getRattlingTicks() > 0) {
            event.setAnimation(this.rattleAnimationType == 0 ? this.RATTLE : this.RATTLE_2);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

