/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.event;

import dev.xylonity.bonsai.ghosts.common.datagen.GhostsWorldgenProvider;
import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.ghost.SmallGhostEntity;
import dev.xylonity.bonsai.ghosts.common.entity.kodama.KodamaEntity;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsEntities;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class GhostsServerEvents {

    @Mod.EventBusSubscriber(modid="ghosts", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class GhostsServerForgeEvents {
        @SubscribeEvent
        public static void onBlockToolModification(BlockEvent.BlockToolModificationEvent event) {
            if (event.getToolAction() == ToolActions.AXE_STRIP) {
                if (event.getState().m_60713_(GhostsBlocks.HAUNTED_LOG.get())) {
                    event.setFinalState(GhostsBlocks.STRIPPED_HAUNTED_LOG.get().m_49966_());
                }
                if (event.getState().m_60713_(GhostsBlocks.HAUNTED_EYE_LOG.get())) {
                    event.setFinalState(GhostsBlocks.STRIPPED_HAUNTED_LOG.get().m_49966_());
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="ghosts", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class GhostsServerModEvents {
        @SubscribeEvent
        public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
            event.put(GhostsEntities.GHOST.get(), GhostEntity.setAttributes().m_22265_());
            event.put(GhostsEntities.SMALL_GHOST.get(), SmallGhostEntity.setAttributes().m_22265_());
            event.put(GhostsEntities.KODAMA.get(), KodamaEntity.setAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
            event.register(GhostsEntities.GHOST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register(GhostsEntities.SMALL_GHOST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
            event.register(GhostsEntities.KODAMA.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, KodamaEntity::checkKodamaSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        }

        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            generator.addProvider(event.includeServer(), (DataProvider)new GhostsWorldgenProvider(packOutput, lookupProvider));
        }
    }
}

