/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.configurations.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class HauntedFoliagePlacer
extends BlobFoliagePlacer {
    public static final Codec<HauntedFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> HauntedFoliagePlacer.m_68413_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, HauntedFoliagePlacer::new));

    public HauntedFoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset, height);
    }

    protected FoliagePlacerType<?> m_5897_() {
        return GhostsFoliagePlacers.HAUNTED_FOLIAGE.get();
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        int baseRadius = foliageRadius + attachment.m_68589_();
        this.m_225628_(level, blockSetter, random, config, attachment.m_161451_(), baseRadius, -1, attachment.m_68590_());
        this.m_225628_(level, blockSetter, random, config, attachment.m_161451_(), baseRadius, 0, attachment.m_68590_());
        int topRadius = Math.max(baseRadius - 1, 0);
        this.m_225628_(level, blockSetter, random, config, attachment.m_161451_(), topRadius, 1, attachment.m_68590_());
        BlockPos centerPos = attachment.m_161451_();
        for (int i = -1; i <= 0; ++i) {
            BlockPos layerPos = centerPos.m_6630_(i);
            for (int x = -baseRadius; x <= baseRadius; ++x) {
                for (int z = -baseRadius; z <= baseRadius; ++z) {
                    BlockPos hangingPos;
                    int distance = Math.max(Math.abs(x), Math.abs(z));
                    if (distance != baseRadius) continue;
                    BlockPos leafPos = layerPos.m_7918_(x, 0, z);
                    if (!(random.m_188501_() < 0.25f) || !level.m_7433_(leafPos, state -> state.m_60713_(config.f_161213_.m_213972_(random, leafPos).m_60734_()))) continue;
                    int hangingLength = 1 + random.m_188503_(2);
                    for (int h = 1; h <= hangingLength && level.m_7433_(hangingPos = leafPos.m_6625_(h), BlockBehaviour.BlockStateBase::m_60795_); ++h) {
                        blockSetter.m_271838_(hangingPos, GhostsBlocks.HAUNTED_LEAVES.get().m_49966_());
                    }
                }
            }
        }
    }
}

