/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.configurations.tree;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xylonity.bonsai.ghosts.registry.GhostsBlocks;
import dev.xylonity.bonsai.ghosts.registry.GhostsTrunkPlacerTypes;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class HauntedTrunkPlacer
extends StraightTrunkPlacer {
    public static final Codec<HauntedTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> HauntedTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, HauntedTrunkPlacer::new));
    private boolean hasSpawnedEye = false;

    public HauntedTrunkPlacer(int i, int j, int k) {
        super(i, j, k);
    }

    @Nonnull
    protected TrunkPlacerType<?> m_7362_() {
        return GhostsTrunkPlacerTypes.HAUNTED_TRUNK_PLACER.get();
    }

    @Nonnull
    public List<FoliagePlacer.FoliageAttachment> m_213934_(@Nonnull LevelSimulatedReader level, @Nonnull BiConsumer<BlockPos, BlockState> blockSetter, @Nonnull RandomSource random, int freeTreeHeight, BlockPos pos, @Nonnull TreeConfiguration config) {
        HauntedTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        for (int i = 0; i < freeTreeHeight; ++i) {
            BlockPos currentPosition = pos.m_6630_(i);
            if (random.m_188501_() < 0.2f && !this.hasSpawnedEye) {
                blockSetter.accept(currentPosition, GhostsBlocks.HAUNTED_EYE_LOG.get().m_49966_());
                this.hasSpawnedEye = true;
                continue;
            }
            this.m_226187_(level, blockSetter, random, currentPosition, config);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.m_6630_(freeTreeHeight), 0, false));
    }
}

