/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.util;

import dev.xylonity.bonsai.ghosts.common.entity.AbstractGhostEntity;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Items;

public final class GhostOwnerTracker {
    private static final Map<UUID, Set<UUID>> owner_to_ghost = new ConcurrentHashMap<UUID, Set<UUID>>();
    private static final GhostOwnerTracker instance = new GhostOwnerTracker();

    private GhostOwnerTracker() {
    }

    public static GhostOwnerTracker getInstance() {
        return instance;
    }

    public void addGhost(AbstractGhostEntity ghost) {
        UUID ownerUUID = ghost.m_21805_();
        if (ownerUUID != null) {
            owner_to_ghost.computeIfAbsent(ownerUUID, uuid -> ConcurrentHashMap.newKeySet()).add(ghost.m_20148_());
        }
    }

    public void removeGhost(AbstractGhostEntity ghost) {
        UUID ownerUUID = ghost.m_21805_();
        if (ownerUUID != null) {
            owner_to_ghost.remove(ownerUUID);
        }
    }

    @Nullable
    public AbstractGhostEntity findGhostWithTotem(ServerLevel level, UUID playerUUID) {
        Set<UUID> ghostUUIDs = owner_to_ghost.get(playerUUID);
        if (ghostUUIDs == null || ghostUUIDs.isEmpty()) {
            return null;
        }
        for (ServerLevel serverLevel : level.m_7654_().m_129785_()) {
            for (UUID uuid : ghostUUIDs) {
                AbstractGhostEntity ghost;
                Entity entity = serverLevel.m_8791_(uuid);
                if (!(entity instanceof AbstractGhostEntity) || !(ghost = (AbstractGhostEntity)entity).m_21205_().m_150930_(Items.f_42747_)) continue;
                return ghost;
            }
        }
        return null;
    }
}

