/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class GhostPlaceGoal
extends class_1352 {
    private final GhostEntity ghost;
    private final class_1856 placeables;
    private final Predicate<class_2680> preference;
    private final int minLight;
    private final int retryCooldown;
    private final double approachSpeed;
    private int nextTryTick;
    private int lastRepathTick;
    private final double maxOwnerDrift = 36.0;
    @Nullable
    private class_2338 targetPlacePos;
    @Nullable
    private class_2338 lastPlacedPos;

    public GhostPlaceGoal(GhostEntity ghost, class_1856 placeables, Predicate<class_2680> pref, int lightThreshold, int retry, double speed) {
        this.ghost = ghost;
        this.placeables = placeables;
        this.preference = pref;
        this.minLight = lightThreshold;
        this.retryCooldown = Math.max(5, retry);
        this.approachSpeed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        int minOwnerDistFromLast;
        int manhattanDistance;
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.ghost.method_6172() || this.ghost.method_5765()) {
            return false;
        }
        if (this.ghost.field_6012 < this.nextTryTick) {
            return false;
        }
        class_1309 owner = this.ghost.method_35057();
        if (owner == null) {
            return false;
        }
        class_1799 heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        if (this.lastPlacedPos != null && (manhattanDistance = owner.method_24515().method_19455((class_2382)this.lastPlacedPos)) < (minOwnerDistFromLast = 4)) {
            return false;
        }
        class_1747 blockItem = (class_1747)heldStack.method_7909();
        class_2338 found = this.findDarkPlacePosNearOwner(this.ghost.method_37908(), owner, blockItem);
        if (found == null) {
            return false;
        }
        this.targetPlacePos = found.method_10062();
        return true;
    }

    public boolean method_6266() {
        if (this.ghost.method_37908().field_9236) {
            return false;
        }
        if (this.ghost.getMainInteraction() != 1) {
            return false;
        }
        if (this.targetPlacePos == null) {
            return false;
        }
        class_1309 owner = this.ghost.method_35057();
        if (owner == null) {
            return false;
        }
        if (owner.method_19538().method_1025(class_243.method_24953((class_2382)this.targetPlacePos)) > 36.0) {
            return false;
        }
        class_1799 heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        class_1747 blockItem = (class_1747)heldStack.method_7909();
        return this.isValidPlacement(this.ghost.method_37908(), this.targetPlacePos, blockItem);
    }

    public void method_6269() {
        this.lastRepathTick = this.ghost.field_6012;
        if (this.targetPlacePos == null) {
            return;
        }
        this.moveToTarget();
    }

    public void method_6270() {
        this.ghost.method_5942().method_6340();
        this.targetPlacePos = null;
        int desired = this.ghost.field_6012 + this.retryCooldown;
        if (this.nextTryTick < desired) {
            this.nextTryTick = desired;
        }
    }

    public void method_6268() {
        double placeDistanceSquare;
        if (this.targetPlacePos == null) {
            return;
        }
        class_1309 owner = this.ghost.method_35057();
        if (owner == null) {
            this.method_6270();
            return;
        }
        if (!this.ghost.method_37908().method_8320(this.targetPlacePos).method_26215()) {
            this.method_6270();
            return;
        }
        class_243 center = class_243.method_24953((class_2382)this.targetPlacePos);
        if (owner.method_19538().method_1025(center) > 36.0) {
            this.method_6270();
            return;
        }
        double distSquare = this.ghost.method_19538().method_1025(center);
        if (distSquare <= 9.0) {
            this.ghost.method_5988().method_20248(center.field_1352, center.field_1351, center.field_1350);
        }
        if (distSquare <= (placeDistanceSquare = 1.9599999999999997)) {
            this.ghost.method_5942().method_6340();
            if (this.canSee(this.targetPlacePos) && this.placeNow(this.targetPlacePos)) {
                this.method_6270();
            }
            return;
        }
        int ticksPerRepath = 12;
        if (this.ghost.field_6012 - this.lastRepathTick >= ticksPerRepath) {
            this.lastRepathTick = this.ghost.field_6012;
            this.moveToTarget();
        }
    }

    public boolean method_38846() {
        return true;
    }

    private void moveToTarget() {
        if (this.targetPlacePos == null) {
            return;
        }
        class_243 movePos = class_243.method_24953((class_2382)this.targetPlacePos).method_1031(0.0, 0.1, 0.0);
        this.ghost.method_5942().method_6337(movePos.field_1352, movePos.field_1351, movePos.field_1350, this.approachSpeed);
    }

    private boolean isPlaceableBlockItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (!this.placeables.method_8093(stack)) {
            return false;
        }
        return stack.method_7909() instanceof class_1747;
    }

    private boolean isValidPlacement(class_1937 level, class_2338 placePos, class_1747 blockItem) {
        if (!level.method_8320(placePos).method_26215()) {
            return false;
        }
        if (this.lastPlacedPos != null) {
            int dx = Math.abs(placePos.method_10263() - this.lastPlacedPos.method_10263());
            int dy = Math.abs(placePos.method_10264() - this.lastPlacedPos.method_10264());
            int dz = Math.abs(placePos.method_10260() - this.lastPlacedPos.method_10260());
            if (dx <= 1 && dy <= 1 && dz <= 1) {
                return false;
            }
        }
        if (level.method_22339(placePos) > this.minLight) {
            return false;
        }
        class_2338 basePos = placePos.method_10074();
        class_2680 baseState = level.method_8320(basePos);
        if (baseState.method_26215()) {
            return false;
        }
        if (!this.preference.test(baseState)) {
            return false;
        }
        return blockItem.method_7711().method_9564().method_26184((class_4538)level, placePos);
    }

    private boolean placeNow(class_2338 placePos) {
        class_1799 heldStack = this.ghost.getHoldItem();
        if (!this.isPlaceableBlockItem(heldStack)) {
            return false;
        }
        class_1747 blockItem = (class_1747)heldStack.method_7909();
        if (!this.isValidPlacement(this.ghost.method_37908(), placePos, blockItem)) {
            return false;
        }
        this.ghost.triggerAnim("torch_place_controller", "torch_place");
        this.ghost.method_37908().method_8652(placePos, blockItem.method_7711().method_9564(), 3);
        heldStack.method_7934(1);
        if (heldStack.method_7960()) {
            this.ghost.setHoldItem(class_1799.field_8037);
        }
        this.lastPlacedPos = placePos.method_10062();
        this.nextTryTick = this.ghost.field_6012 + this.retryCooldown;
        return true;
    }

    private boolean canSee(class_2338 placePos) {
        class_243 targetPosition = class_243.method_24953((class_2382)placePos);
        class_3965 hitResult = this.ghost.method_37908().method_17742(new class_3959(this.ghost.method_33571(), targetPosition, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.ghost));
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = hitResult;
            return blockHitResult.method_17777().equals((Object)placePos);
        }
        return false;
    }

    @Nullable
    private class_2338 findDarkPlacePosNearOwner(class_1937 level, class_1309 owner, class_1747 blockItem) {
        class_243 forward = owner.method_18798();
        forward = new class_243(forward.field_1352, 0.0, forward.field_1350);
        if (forward.method_1027() < 5.0E-4) {
            class_243 look = owner.method_5720();
            forward = new class_243(look.field_1352, 0.0, look.field_1350);
        }
        if (forward.method_1027() > 1.0E-4) {
            forward = forward.method_1029();
        }
        class_2338 bestPosition = null;
        double bestScore = Double.POSITIVE_INFINITY;
        class_2338 centerPosition = owner.method_24515();
        int searchRadius = 4;
        for (int dx = -searchRadius; dx <= searchRadius; ++dx) {
            for (int dz = -searchRadius; dz <= searchRadius; ++dz) {
                int searchRadiusDown = 4;
                for (int down = 1; down <= searchRadiusDown; ++down) {
                    double score;
                    int light;
                    class_2338 placePosition;
                    class_2338 basePos = centerPosition.method_10069(dx, -down, dz);
                    class_2680 baseState = level.method_8320(basePos);
                    if (baseState.method_26215() || !this.preference.test(baseState) || !level.method_8320(placePosition = basePos.method_10084()).method_26215() || (light = level.method_22339(placePosition)) > this.minLight || !blockItem.method_7711().method_9564().method_26184((class_4538)level, placePosition)) continue;
                    class_243 toPosition = class_243.method_24953((class_2382)placePosition).method_1020(owner.method_19538());
                    class_243 toPositionFlat = new class_243(toPosition.field_1352, 0.0, toPosition.field_1350);
                    double distanceToPosition = toPositionFlat.method_1033();
                    double behindPenalty = 0.0;
                    if (forward.method_1027() > 1.0E-4 && toPositionFlat.method_1027() > 1.0E-4) {
                        double normalized = forward.method_1026(toPositionFlat.method_1029());
                        behindPenalty = (1.0 - normalized) * 2.0;
                    }
                    if (!((score = (double)light * 1000.0 + distanceToPosition * 25.0 + behindPenalty * 200.0) < bestScore)) continue;
                    bestScore = score;
                    bestPosition = placePosition;
                }
            }
        }
        return bestPosition;
    }
}

