/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.arcaniumnew.init;

import java.util.Map;
import net.mcreator.arcaniumnew.ArcaniumnewMod;
import net.mcreator.arcaniumnew.init.ArcaniumnewModScreens;
import net.mcreator.arcaniumnew.network.MenuStateUpdateMessage;
import net.mcreator.arcaniumnew.world.inventory.ClassSetMenu;
import net.mcreator.arcaniumnew.world.inventory.ProfileMenu;
import net.mcreator.arcaniumnew.world.inventory.UpgraderGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ArcaniumnewModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"arcaniumnew");
    public static final RegistryObject<MenuType<ClassSetMenu>> CLASS_SET = REGISTRY.register("class_set", () -> IForgeMenuType.create(ClassSetMenu::new));
    public static final RegistryObject<MenuType<ProfileMenu>> PROFILE = REGISTRY.register("profile", () -> IForgeMenuType.create(ProfileMenu::new));
    public static final RegistryObject<MenuType<UpgraderGUIMenu>> UPGRADER_GUI = REGISTRY.register("upgrader_gui", () -> IForgeMenuType.create(UpgraderGUIMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ArcaniumnewMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof ArcaniumnewModScreens.ScreenAccessor) {
                    ArcaniumnewModScreens.ScreenAccessor accessor = (ArcaniumnewModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                ArcaniumnewMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

