/*
 * Decompiled with CFR 0.152.
 */
package dev.firstdark.rpc.connection;

import dev.firstdark.rpc.DiscordRpc;
import dev.firstdark.rpc.connection.BaseConnection;
import dev.firstdark.rpc.connection.unix.IUnixBackend;
import dev.firstdark.rpc.connection.unix.NIOUnixBackend;
import dev.firstdark.rpc.exceptions.NoDiscordClientException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;

class UnixConnection
extends BaseConnection {
    private IUnixBackend unixBackend = new NIOUnixBackend();

    UnixConnection(DiscordRpc rpc) {
        super(rpc);
    }

    @Override
    boolean isOpen() {
        return this.unixBackend != null && this.unixBackend.isConnected();
    }

    @Override
    boolean open() throws NoDiscordClientException {
        String pipeName = this.getTempPath() + "/discord-ipc-%s";
        if (this.isOpen()) {
            throw new IllegalStateException("Connection is already opened");
        }
        if (this.tryOpenConnection(pipeName)) {
            return true;
        }
        String nextPath = this.getAdditionalPaths();
        if (nextPath != null && !nextPath.isEmpty() && this.tryOpenConnection(nextPath + "/discord-ipc-%s")) {
            return true;
        }
        throw new NoDiscordClientException();
    }

    private boolean tryOpenConnection(String pipeName) {
        for (int i = 0; i < 10; ++i) {
            try {
                File test = new File(String.format(pipeName, i));
                if (!test.exists()) continue;
                this.unixBackend.openPipe(String.format(pipeName, i));
                this.getRpc().printDebug("Connected to IPC pipe %s", String.format(pipeName, i));
                return true;
            }
            catch (Exception e) {
                this.getRpc().printDebug("Failed to connect to pipe %s", String.format(pipeName, i), e);
            }
        }
        return false;
    }

    @Override
    void close() {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.unixBackend.closePipe();
        }
        catch (IOException e) {
            this.getRpc().printDebug("Failed to close connection", e);
        }
    }

    @Override
    boolean write(byte[] bytes) {
        if (!this.isOpen()) {
            return false;
        }
        try {
            this.unixBackend.write(bytes);
            return true;
        }
        catch (Exception e) {
            this.getRpc().printDebug("Failed to write packet %s", e);
            return false;
        }
    }

    @Override
    boolean read(byte[] bytes, int length) {
        if (bytes == null || bytes.length == 0) {
            return bytes != null;
        }
        if (!this.isOpen()) {
            return false;
        }
        try {
            long available = this.unixBackend.getAvailable();
            if (available == 0L) {
                return false;
            }
            byte[] buf = new byte[length];
            int read = this.unixBackend.read(buf);
            if (read != length) {
                throw new IOException("Read less data than supplied. Expected: " + length + ". Got: " + read);
            }
            ByteBuffer buffer = ByteBuffer.wrap(buf);
            buffer.rewind();
            buffer.get(bytes, 0, length);
            return true;
        }
        catch (Exception e) {
            this.getRpc().getLogger().error("Failed to read packet %s", e);
            this.close();
            return false;
        }
    }

    @Override
    public void register(String applicationId, String command) {
        String home = System.getenv("HOME");
        if (home == null) {
            throw new RuntimeException("Unable to find user HOME directory");
        }
        if (command == null) {
            try {
                command = Files.readSymbolicLink(Paths.get("/proc/self/exe", new String[0])).toString();
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to get current exe path from /proc/self/exe", ex);
            }
        }
        String desktopFile = "[Desktop Entry]\nName=Game " + applicationId + "\nExec=" + command + " %%u\nType=Application\nNoDisplay=true\nCategories=Discord;Games;\nMimeType=x-scheme-handler/discord-" + applicationId + ";\n";
        String desktopFileName = "/discord-" + applicationId + ".desktop";
        String desktopFilePath = home + "/.local";
        if (!this.mkdir(desktopFilePath)) {
            throw new RuntimeException("Failed to create directory '" + desktopFilePath + "'");
        }
        if (!this.mkdir(desktopFilePath = desktopFilePath + "/share")) {
            throw new RuntimeException("Failed to create directory '" + desktopFilePath + "'");
        }
        if (!this.mkdir(desktopFilePath = desktopFilePath + "/applications")) {
            throw new RuntimeException("Failed to create directory '" + desktopFilePath + "'");
        }
        desktopFilePath = desktopFilePath + desktopFileName;
        try (FileWriter fileWriter = new FileWriter(desktopFilePath);){
            fileWriter.write(desktopFile);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to write desktop info into '" + desktopFilePath + "'");
        }
        String xdgMimeCommand = "xdg-mime default discord-" + applicationId + ".desktop x-scheme-handler/discord-" + applicationId;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(xdgMimeCommand.split(" "));
            processBuilder.environment();
            int result = processBuilder.start().waitFor();
            if (result < 0) {
                throw new Exception("xdg-mime returned " + result);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to register mime handler", ex);
        }
    }

    @Override
    public void registerSteamGame(String applicationId, String steamId) {
        this.register(applicationId, "xdg-open steam://rungameid/" + steamId);
    }

    private String getTempPath() {
        String temp = System.getenv("XDG_RUNTIME_DIR");
        temp = temp != null ? temp : System.getenv("TMPDIR");
        temp = temp != null ? temp : System.getenv("TMP");
        temp = temp != null ? temp : System.getenv("TEMP");
        temp = temp != null ? temp : "/tmp";
        return temp;
    }

    private String getAdditionalPaths() {
        String[] unixFolderPaths = new String[]{"/snap.discord", "/app/com.discordapp.Discord"};
        String path = this.getTempPath();
        for (String s : unixFolderPaths) {
            File f = new File(path, s);
            if (!f.exists() || !f.isDirectory() || f.list() == null || f.list().length <= 0) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    boolean mkdir(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory() || file.mkdir();
    }
}

