/*
 * Decompiled with CFR 0.152.
 */
package dev.firstdark.rpc.models;

import dev.firstdark.rpc.enums.OpCode;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class MessageFrame {
    byte[] headerBuffer;
    byte[] messageBuffer;
    private OpCode opCode;
    private int length;
    private String message;

    public MessageFrame() {
        this.headerBuffer = new byte[8];
        this.messageBuffer = new byte[65535 - this.headerBuffer.length];
    }

    public MessageFrame(OpCode code, String message) {
        this.opCode = code;
        this.message = message;
    }

    public boolean parseHeader() {
        boolean bl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.headerBuffer);
        try {
            this.opCode = OpCode.values()[this.readInt(inputStream)];
            this.length = this.readInt(inputStream);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                System.out.println("Failed to parse header: " + ex.getMessage());
                return false;
            }
        }
        inputStream.close();
        return bl;
    }

    private int readInt(InputStream stream) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = stream.read();
        if ((ch1 | (ch2 = stream.read()) | (ch3 = stream.read()) | (ch4 = stream.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
    }

    public boolean parseMessage() {
        this.message = new String(Arrays.copyOfRange(this.messageBuffer, 0, this.length), StandardCharsets.UTF_8);
        return true;
    }

    public ByteBuffer write() {
        byte[] d = this.message.getBytes(StandardCharsets.UTF_8);
        ByteBuffer writeStream = ByteBuffer.allocate(d.length + 8);
        writeStream.putInt(Integer.reverseBytes(this.opCode.ordinal()));
        writeStream.putInt(Integer.reverseBytes(d.length));
        writeStream.put(d);
        writeStream.rewind();
        return writeStream;
    }

    public byte[] getHeaderBuffer() {
        return this.headerBuffer;
    }

    public byte[] getMessageBuffer() {
        return this.messageBuffer;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public int getLength() {
        return this.length;
    }

    public String getMessage() {
        return this.message;
    }

    public void setOpCode(OpCode opCode) {
        this.opCode = opCode;
    }
}

