/*
 * Decompiled with CFR 0.152.
 */
package dev.firstdark.rpc.utils;

public class Backoff {
    private final long minAmount;
    private final long maxAmount;

    public Backoff(long min, long max) {
        this.minAmount = min;
        this.maxAmount = max;
    }

    public long getDelay(int attempt, int maxAttempts) {
        double progress = Math.min(1.0, (double)attempt / (double)maxAttempts);
        return this.minAmount + (long)((double)(this.maxAmount - this.minAmount) * progress);
    }

    public static String formatDuration(long millis) {
        if (millis < 1000L) {
            return millis + " ms";
        }
        if (millis < 60000L) {
            long seconds = millis / 1000L;
            long remainderMs = millis % 1000L;
            if (remainderMs == 0L) {
                return seconds + " s";
            }
            return seconds + "." + remainderMs / 100L + " s";
        }
        long minutes = millis / 60000L;
        long seconds = millis % 60000L / 1000L;
        if (seconds == 0L) {
            return minutes + " m";
        }
        return String.format("%d m %d s", minutes, seconds);
    }
}

