/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.commands.impl;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.phantomvisuals.client.ChatUtils;
import dev.phantomvisuals.client.commands.Command;
import dev.phantomvisuals.client.managers.ModuleManager;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.api.Bind;
import dev.phantomvisuals.phantomvisuals;
import java.lang.reflect.Field;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_2172;
import org.lwjgl.glfw.GLFW;

public class BindCommand
extends Command {
    public BindCommand() {
        super("bind");
    }

    @Override
    public void execute(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(ctx -> {
            ChatUtils.sendMessage(class_1074.method_4662((String)"bind.help", (Object[])new Object[0]));
            return 1;
        });
        builder.then(this.literal("list").executes(this::list));
        builder.then(this.literal("reset").executes(ctx -> {
            phantomvisuals.getInstance().getModuleManager().resetBindsToDefaults();
            ChatUtils.sendMessage(class_1074.method_4662((String)"bind.reset", (Object[])new Object[0]));
            return 1;
        }));
        builder.then(this.literal("clear").then(this.arg("module", StringArgumentType.greedyString()).executes(this::clear)));
        builder.then(this.literal("set").then(this.arg("module", StringArgumentType.greedyString()).then(this.arg("key", StringArgumentType.word()).executes(this::set))));
    }

    private int list(CommandContext<class_2172> ctx) {
        ModuleManager mm = phantomvisuals.getInstance().getModuleManager();
        ChatUtils.sendMessage(class_1074.method_4662((String)"bind.list.header", (Object[])new Object[0]));
        for (Module m : mm.getModules()) {
            Bind b = m.getBind();
            if (b == null || b.getKey() < 0) continue;
            String keyName = this.bindToString(b);
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"bind.list.item", (Object[])new Object[0]), m.getName(), keyName));
        }
        return 1;
    }

    private int clear(CommandContext<class_2172> ctx) {
        String moduleName = StringArgumentType.getString(ctx, (String)"module");
        Module m = this.resolveModule(moduleName);
        if (m == null) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"bind.invalidModule", (Object[])new Object[0]), moduleName));
            return 0;
        }
        m.setBind(new Bind(-1, false));
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"bind.cleared", (Object[])new Object[0]), m.getName()));
        this.scheduleSave();
        return 1;
    }

    private int set(CommandContext<class_2172> ctx) {
        String moduleName = StringArgumentType.getString(ctx, (String)"module");
        String keyToken = StringArgumentType.getString(ctx, (String)"key");
        Module m = this.resolveModule(moduleName);
        if (m == null) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"bind.invalidModule", (Object[])new Object[0]), moduleName));
            return 0;
        }
        Bind newBind = this.parseBindToken(keyToken);
        if (newBind == null) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"bind.invalidKey", (Object[])new Object[0]), keyToken));
            return 0;
        }
        m.setBind(newBind);
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"bind.set", (Object[])new Object[0]), m.getName(), this.bindToString(newBind)));
        this.scheduleSave();
        return 1;
    }

    private Module resolveModule(String name) {
        ModuleManager mm = phantomvisuals.getInstance().getModuleManager();
        Module m = mm.getModuleByName(name);
        if (m != null) {
            return m;
        }
        for (Module mod : mm.getModules()) {
            if (!mod.getName().equalsIgnoreCase(name)) continue;
            return mod;
        }
        return null;
    }

    private Bind parseBindToken(String token) {
        String t = token.toLowerCase(Locale.ROOT);
        if (t.startsWith("mouse") || t.startsWith("mb")) {
            int idx = -1;
            try {
                idx = Integer.parseInt(t.replaceAll("[^0-9]", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (idx >= 0 && idx <= 7) {
                return new Bind(idx, true);
            }
            return null;
        }
        if (t.equals("none") || t.equals("clear")) {
            return new Bind(-1, false);
        }
        int key = this.keyNameToGlfw(token);
        if (key >= 0) {
            return new Bind(key, false);
        }
        return null;
    }

    private int keyNameToGlfw(String name) {
        String n = name.toUpperCase(Locale.ROOT);
        if (n.equals("RSHIFT")) {
            n = "RIGHT_SHIFT";
        }
        if (n.equals("LSHIFT")) {
            n = "LEFT_SHIFT";
        }
        if (n.equals("RCTRL")) {
            n = "RIGHT_CONTROL";
        }
        if (n.equals("LCTRL")) {
            n = "LEFT_CONTROL";
        }
        if (n.equals("RALT")) {
            n = "RIGHT_ALT";
        }
        if (n.equals("LALT")) {
            n = "LEFT_ALT";
        }
        if (n.length() == 1) {
            char c = n.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return 65 + (c - 65);
            }
            if (c >= '0' && c <= '9') {
                return 48 + (c - 48);
            }
        }
        try {
            Field f = GLFW.class.getField("GLFW_KEY_" + n);
            return f.getInt(null);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private String bindToString(Bind b) {
        if (b == null || b.getKey() < 0) {
            return class_1074.method_4662((String)"bind.none", (Object[])new Object[0]);
        }
        if (b.isMouse()) {
            return "MOUSE" + b.getKey();
        }
        return this.keyToName(b.getKey());
    }

    private String keyToName(int key) {
        if (key >= 65 && key <= 90) {
            return String.valueOf((char)(65 + (key - 65)));
        }
        if (key >= 48 && key <= 57) {
            return String.valueOf((char)(48 + (key - 48)));
        }
        if (key >= 290 && key <= 314) {
            return "F" + (key - 290 + 1);
        }
        try {
            for (Field f : GLFW.class.getFields()) {
                if (!f.getName().startsWith("GLFW_KEY_") || f.getInt(null) != key) continue;
                return f.getName().substring("GLFW_KEY_".length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(key);
    }

    private void scheduleSave() {
        try {
            phantomvisuals.getInstance().getAutoSaveManager().scheduleAutoSave();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

