/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.commands.impl;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.phantomvisuals.client.ChatUtils;
import dev.phantomvisuals.client.commands.Command;
import dev.phantomvisuals.client.managers.ConfigManager;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Desktop;
import java.io.File;
import net.minecraft.class_2172;

public class ConfigAliasCommand
extends Command {
    public ConfigAliasCommand() {
        super("config");
    }

    @Override
    public void execute(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(context -> {
            this.showHelp();
            return 1;
        });
        builder.then(this.literal("save").then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.saveConfig(configName);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)this.literal("load").executes(context -> {
            ChatUtils.sendMessage("\u00a7c\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            return 1;
        })).then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).suggests((ctx, suggestionsBuilder) -> {
            this.suggestConfigs(suggestionsBuilder);
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.loadConfig(configName);
            return 1;
        })));
        builder.then(this.literal("list").executes(context -> {
            this.listConfigs();
            return 1;
        }));
        builder.then(this.literal("dir").executes(context -> {
            this.showConfigDirectory();
            return 1;
        }));
        builder.then(this.literal("delete").then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.deleteConfig(configName);
            return 1;
        })));
        builder.then(this.literal("info").then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.showConfigInfo(configName);
            return 1;
        })));
    }

    private void showHelp() {
        ChatUtils.sendMessage("\u00a76=== Config Manager Help ===");
        ChatUtils.sendMessage("\u00a7e.config save <\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435> \u00a77- \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
        ChatUtils.sendMessage("\u00a7e.config load <\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435> \u00a77- \u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
        ChatUtils.sendMessage("\u00a7e.config list \u00a77- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439");
        ChatUtils.sendMessage("\u00a7e.config dir \u00a77- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439");
        ChatUtils.sendMessage("\u00a7e.config delete <\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435> \u00a77- \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
        ChatUtils.sendMessage("\u00a7e.config info <\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435> \u00a77- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
        ChatUtils.sendMessage("\u00a77\u0410\u043b\u0438\u0430\u0441\u044b: \u00a7e.cfg \u00a77(\u0432\u043c\u0435\u0441\u0442\u043e .config)");
    }

    private void saveConfig(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            return;
        }
        ChatUtils.sendMessage("\u00a7a\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '" + configName + "'...");
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        configManager.saveConfig(configName).thenAccept(success -> {
            if (success.booleanValue()) {
                ChatUtils.sendMessage("\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '" + configName + "' \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430!");
            } else {
                ChatUtils.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '" + configName + "'");
            }
        });
    }

    private void loadConfig(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage("\u00a7c\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            return;
        }
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        if (!configManager.configExists(configName)) {
            ChatUtils.sendMessage("\u00a7c\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '" + configName + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            return;
        }
        ChatUtils.sendMessage("\u00a7a\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '" + configName + "'...");
        configManager.loadConfig(configName).thenAccept(success -> {
            if (success.booleanValue()) {
                ChatUtils.sendMessage("\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '" + configName + "' \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
            } else {
                ChatUtils.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '" + configName + "'");
            }
        });
    }

    private void listConfigs() {
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        String[] configs = configManager.getConfigList();
        if (configs.length == 0) {
            ChatUtils.sendMessage("\u00a7e\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439 \u043f\u0443\u0441\u0442");
            return;
        }
        ChatUtils.sendMessage("\u00a76=== \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 ===");
        for (String config : configs) {
            ChatUtils.sendMessage("\u00a77- \u00a7e" + config);
        }
        ChatUtils.sendMessage("\u00a77\u0412\u0441\u0435\u0433\u043e: \u00a7e" + configs.length + " \u00a77\u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439");
    }

    private void showConfigDirectory() {
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        String directory = configManager.getConfigsDirectory();
        ChatUtils.sendMessage("\u00a76\u041f\u0430\u043f\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439: \u00a7e" + directory);
        try {
            String os;
            Process proc;
            Desktop desktop;
            File dirFile = new File(directory);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            boolean opened = false;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                desktop.open(dirFile);
                opened = true;
            }
            if (!opened && ((proc = (os = System.getProperty("os.name", "").toLowerCase()).contains("win") ? new ProcessBuilder("explorer.exe", dirFile.getAbsolutePath()).start() : (os.contains("mac") ? new ProcessBuilder("open", dirFile.getAbsolutePath()).start() : new ProcessBuilder("xdg-open", dirFile.getAbsolutePath()).start())).isAlive() || proc.exitValue() == 0)) {
                opened = true;
            }
            if (opened) {
                ChatUtils.sendMessage("\u00a7a\u041f\u0430\u043f\u043a\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430 \u0432 \u043f\u0440\u043e\u0432\u043e\u0434\u043d\u0438\u043a\u0435!");
            } else {
                ChatUtils.sendMessage("\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043f\u043a\u0443: Unknown error");
            }
        }
        catch (Exception e) {
            ChatUtils.sendMessage("\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u043f\u0430\u043f\u043a\u0443: " + e.getMessage());
        }
    }

    private void deleteConfig(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            return;
        }
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        if (!configManager.configExists(configName)) {
            ChatUtils.sendMessage("\u00a7c\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '" + configName + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            return;
        }
        boolean deleted = configManager.deleteConfig(configName);
        if (deleted) {
            ChatUtils.sendMessage("\u00a7a\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '" + configName + "' \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0430!");
        } else {
            ChatUtils.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '" + configName + "'");
        }
    }

    private void showConfigInfo(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage("\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430: \u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            return;
        }
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        if (!configManager.configExists(configName)) {
            ChatUtils.sendMessage("\u00a7c\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '" + configName + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
            return;
        }
        ChatUtils.sendMessage("\u00a76=== \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '" + configName + "' ===");
        ChatUtils.sendMessage("\u00a77\u0424\u0430\u0439\u043b: \u00a7e" + configName + ".phantom");
        ChatUtils.sendMessage("\u00a77\u041f\u0443\u0442\u044c: \u00a7e" + configManager.getConfigsDirectory() + "/" + configName + ".phantom");
        ChatUtils.sendMessage("\u00a77\u0421\u0442\u0430\u0442\u0443\u0441: \u00a7a\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
    }

    private void suggestConfigs(SuggestionsBuilder suggestionsBuilder) {
        String[] configs;
        for (String cfg : configs = phantomvisuals.getInstance().getConfigManager().getConfigList()) {
            suggestionsBuilder.suggest(cfg);
        }
    }
}

