/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.commands.impl;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.phantomvisuals.client.ChatUtils;
import dev.phantomvisuals.client.commands.Command;
import dev.phantomvisuals.client.managers.ConfigManager;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Desktop;
import java.io.File;
import net.minecraft.class_1074;
import net.minecraft.class_2172;

public class ConfigCommand
extends Command {
    public ConfigCommand() {
        super("cfg");
    }

    @Override
    public void execute(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(context -> {
            this.showHelp();
            return 1;
        });
        builder.then(this.literal("save").then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.saveConfig(configName);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)this.literal("load").executes(context -> {
            ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.error.provideName", (Object[])new Object[0]));
            return 1;
        })).then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).suggests((ctx, suggestionsBuilder) -> {
            this.suggestConfigs(suggestionsBuilder);
            return suggestionsBuilder.buildFuture();
        }).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.loadConfig(configName);
            return 1;
        })));
        builder.then(this.literal("list").executes(context -> {
            this.listConfigs();
            return 1;
        }));
        builder.then(this.literal("dir").executes(context -> {
            this.showConfigDirectory();
            return 1;
        }));
        builder.then(this.literal("delete").then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.deleteConfig(configName);
            return 1;
        })));
        builder.then(this.literal("info").then(this.arg("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StringArgumentType.string()).executes(context -> {
            String configName = StringArgumentType.getString((CommandContext)context, (String)"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
            this.showConfigInfo(configName);
            return 1;
        })));
    }

    private void showHelp() {
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.header", (Object[])new Object[0]));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.save", (Object[])new Object[0]));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.load", (Object[])new Object[0]));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.list", (Object[])new Object[0]));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.dir", (Object[])new Object[0]));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.delete", (Object[])new Object[0]));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.info", (Object[])new Object[0]));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.help.aliases", (Object[])new Object[0]));
    }

    private void saveConfig(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.error.provideConfigName", (Object[])new Object[0]));
            return;
        }
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.saving", (Object[])new Object[0]), configName));
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        configManager.saveConfig(configName).thenAccept(success -> {
            if (success.booleanValue()) {
                ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.saved", (Object[])new Object[0]), configName));
            } else {
                ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.saveError", (Object[])new Object[0]), configName));
            }
        });
    }

    private void loadConfig(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.error.provideName", (Object[])new Object[0]));
            return;
        }
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        if (!configManager.configExists(configName)) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.notFound", (Object[])new Object[0]), configName));
            return;
        }
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.loading", (Object[])new Object[0]), configName));
        configManager.loadConfig(configName).thenAccept(success -> {
            if (success.booleanValue()) {
                ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.loaded", (Object[])new Object[0]), configName));
            } else {
                ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.loadError", (Object[])new Object[0]), configName));
            }
        });
    }

    private void listConfigs() {
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        String[] configs = configManager.getConfigList();
        if (configs.length == 0) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.list.empty", (Object[])new Object[0]));
            return;
        }
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.list.header", (Object[])new Object[0]));
        for (String config : configs) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.list.item", (Object[])new Object[0]), config));
        }
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.list.total", (Object[])new Object[0]), configs.length));
    }

    private void showConfigDirectory() {
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        String directory = configManager.getConfigsDirectory();
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.dir.path", (Object[])new Object[0]), directory));
        try {
            String os;
            Process proc;
            Desktop desktop;
            File dirFile = new File(directory);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            boolean opened = false;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                desktop.open(dirFile);
                opened = true;
            }
            if (!opened && ((proc = (os = System.getProperty("os.name", "").toLowerCase()).contains("win") ? new ProcessBuilder("explorer.exe", dirFile.getAbsolutePath()).start() : (os.contains("mac") ? new ProcessBuilder("open", dirFile.getAbsolutePath()).start() : new ProcessBuilder("xdg-open", dirFile.getAbsolutePath()).start())).isAlive() || proc.exitValue() == 0)) {
                opened = true;
            }
            if (opened) {
                ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.dir.opened", (Object[])new Object[0]));
            } else {
                ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.dir.openError", (Object[])new Object[0]), "Unknown error"));
            }
        }
        catch (Exception e) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.dir.openError", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void deleteConfig(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.error.provideConfigName", (Object[])new Object[0]));
            return;
        }
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        if (!configManager.configExists(configName)) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.notFound", (Object[])new Object[0]), configName));
            return;
        }
        boolean deleted = configManager.deleteConfig(configName);
        if (deleted) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.deleted", (Object[])new Object[0]), configName));
        } else {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.deleteError", (Object[])new Object[0]), configName));
        }
    }

    private void showConfigInfo(String configName) {
        if (configName == null || configName.trim().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.error.provideConfigName", (Object[])new Object[0]));
            return;
        }
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        if (!configManager.configExists(configName)) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.notFound", (Object[])new Object[0]), configName));
            return;
        }
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.info.header", (Object[])new Object[0]), configName));
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.info.file", (Object[])new Object[0]), configName));
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"cfg.info.path", (Object[])new Object[0]), configManager.getConfigsDirectory(), configName));
        ChatUtils.sendMessage(class_1074.method_4662((String)"cfg.info.exists", (Object[])new Object[0]));
    }

    private void suggestConfigs(SuggestionsBuilder suggestionsBuilder) {
        String[] configs;
        for (String cfg : configs = phantomvisuals.getInstance().getConfigManager().getConfigList()) {
            suggestionsBuilder.suggest(cfg);
        }
    }
}

