/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.commands.impl;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.phantomvisuals.client.ChatUtils;
import dev.phantomvisuals.client.commands.Command;
import dev.phantomvisuals.client.managers.FriendsManager;
import java.awt.Desktop;
import java.io.File;
import net.minecraft.class_1074;
import net.minecraft.class_2172;

public class FriendsCommand
extends Command {
    public FriendsCommand() {
        super("friends");
    }

    @Override
    public void execute(LiteralArgumentBuilder<class_2172> builder) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(ctx -> {
            ChatUtils.sendMessage(class_1074.method_4662((String)"friends.help", (Object[])new Object[0]));
            return 1;
        })).then(this.literal("add").then(this.arg("nickname", StringArgumentType.string()).executes(this::add)))).then(this.literal("remove").then(this.arg("nickname", StringArgumentType.string()).executes(this::remove)))).then(this.literal("clear").executes(this::clear))).then(this.literal("list").executes(this::list))).then(this.literal("dir").executes(this::dir));
    }

    private int add(CommandContext<class_2172> ctx) {
        String nickname = StringArgumentType.getString(ctx, (String)"nickname");
        if (FriendsManager.checkFriend(nickname)) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"friends.alreadyFriend", (Object[])new Object[0]));
            return 0;
        }
        FriendsManager.addFriend(nickname);
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"friends.added", (Object[])new Object[0]), nickname));
        return 1;
    }

    private int remove(CommandContext<class_2172> ctx) {
        String nickname = StringArgumentType.getString(ctx, (String)"nickname");
        if (!FriendsManager.checkFriend(nickname)) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"friends.notFound", (Object[])new Object[0]));
            return 0;
        }
        FriendsManager.removeFriend(nickname);
        ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"friends.removed", (Object[])new Object[0]), nickname));
        return 1;
    }

    private int clear(CommandContext<class_2172> ctx) {
        FriendsManager.clear();
        ChatUtils.sendMessage(class_1074.method_4662((String)"friends.cleared", (Object[])new Object[0]));
        return 1;
    }

    private int list(CommandContext<class_2172> ctx) {
        if (FriendsManager.getFriends().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"friends.empty", (Object[])new Object[0]));
            return 1;
        }
        ChatUtils.sendMessage(class_1074.method_4662((String)"friends.header", (Object[])new Object[0]));
        for (String f : FriendsManager.getFriends()) {
            ChatUtils.sendMessage(String.format(class_1074.method_4662((String)"friends.item", (Object[])new Object[0]), f));
        }
        return 1;
    }

    private int dir(CommandContext<class_2172> ctx) {
        File f = FriendsManager.getFriendsFile();
        if (f != null) {
            try {
                Desktop.getDesktop().open(f.getParentFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }
}

