/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.commands.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.phantomvisuals.client.ChatUtils;
import dev.phantomvisuals.client.commands.Command;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.Setting;
import dev.phantomvisuals.phantomvisuals;
import net.minecraft.class_1074;
import net.minecraft.class_2172;

public class ResetCommand
extends Command {
    private static long lastRequestMs = 0L;
    private static final long CONFIRM_WINDOW_MS = 10000L;

    public ResetCommand() {
        super("reset");
    }

    @Override
    public void execute(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(ctx -> {
            long now = System.currentTimeMillis();
            if (now - lastRequestMs > 10000L) {
                lastRequestMs = now;
                ChatUtils.sendMessage(class_1074.method_4662((String)"cmd.reset.confirm", (Object[])new Object[0]));
                return 1;
            }
            phantomvisuals.getInstance().getCommandManager().setPrefix(".");
            for (Module module : phantomvisuals.getInstance().getModuleManager().getModules()) {
                if (module.isToggled()) {
                    module.setToggled(false);
                }
                for (Setting<?> setting : module.getSettings()) {
                    setting.reset();
                }
            }
            phantomvisuals.getInstance().getModuleManager().resetBindsToDefaults();
            for (HudElement hud : phantomvisuals.getInstance().getHudManager().getHudElements()) {
                for (Setting<?> setting : hud.getSettings()) {
                    setting.reset();
                }
                if (hud.isToggled()) continue;
                hud.setToggled(true);
            }
            try {
                ThemeManager.getInstance().setTheme(new ThemeManager.LightTheme());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ChatUtils.sendMessage(class_1074.method_4662((String)"cmd.reset.done", (Object[])new Object[0]));
            try {
                phantomvisuals.getInstance().getAutoSaveManager().forceSave();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            lastRequestMs = 0L;
            return 1;
        });
    }
}

