/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.phantomvisuals.client.ChatUtils;
import dev.phantomvisuals.mixin.accessors.IMinecraftClientSessionAccessor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class AltManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File altsFile;
    private static final List<String> nicknames;
    private static String lastUsed;
    private static final int MAX_ALTS = 100;
    private static final int MAX_NICKNAME_LENGTH = 16;
    private static final int MIN_NICKNAME_LENGTH = 3;

    public static void init(File globalsDir) {
        altsFile = new File(globalsDir, "alts.json");
        AltManager.load();
    }

    public static List<String> getNicknames() {
        return new ArrayList<String>(nicknames);
    }

    public static boolean addNickname(String nickname) {
        if (nickname == null || nickname.trim().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.emptyNickname", (Object[])new Object[0]));
            return false;
        }
        if (!AltManager.isValidNickname(nickname = nickname.trim())) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.invalidNickname", (Object[])new Object[0]));
            return false;
        }
        if (nicknames.size() >= 100) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.tooManyAlts", (Object[])new Object[]{100}));
            return false;
        }
        if (nicknames.contains(nickname)) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.alreadyExists", (Object[])new Object[0]));
            return false;
        }
        try {
            nicknames.add(nickname);
            AltManager.save();
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.added", (Object[])new Object[]{nickname}));
            return true;
        }
        catch (Exception e) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.addError", (Object[])new Object[0]));
            return false;
        }
    }

    public static boolean removeNickname(String nickname) {
        if (nickname == null || nickname.trim().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.emptyNickname", (Object[])new Object[0]));
            return false;
        }
        String trimmedNickname = nickname.trim();
        boolean removed = nicknames.removeIf(n -> n.equalsIgnoreCase(trimmedNickname));
        if (!removed) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.notFound", (Object[])new Object[0]));
            return false;
        }
        if (lastUsed != null && lastUsed.equalsIgnoreCase(trimmedNickname)) {
            lastUsed = null;
        }
        try {
            AltManager.save();
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.removed", (Object[])new Object[]{trimmedNickname}));
            return true;
        }
        catch (Exception e) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.removeError", (Object[])new Object[0]));
            return false;
        }
    }

    public static boolean applyNickname(String nickname) {
        if (nickname == null || nickname.trim().isEmpty()) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.emptyNickname", (Object[])new Object[0]));
            return false;
        }
        if (!AltManager.isValidNickname(nickname = nickname.trim())) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.invalidNickname", (Object[])new Object[0]));
            return false;
        }
        try {
            lastUsed = nickname;
            AltManager.save();
            UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + nickname).getBytes());
            class_320 session = new class_320(nickname, uuid, "0", Optional.empty(), Optional.empty(), class_320.class_321.field_34962);
            IMinecraftClientSessionAccessor accessor = (IMinecraftClientSessionAccessor)class_310.method_1551();
            accessor.phantomvisuals$setSession(session);
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.applied", (Object[])new Object[]{nickname}));
            return true;
        }
        catch (Exception e) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.applyError", (Object[])new Object[0]));
            return false;
        }
    }

    public static String getLastUsedNickname() {
        return lastUsed;
    }

    private static boolean isValidNickname(String nickname) {
        if (nickname == null || nickname.isEmpty()) {
            return false;
        }
        if (nickname.length() < 3 || nickname.length() > 16) {
            return false;
        }
        return nickname.matches("[A-Za-z0-9_]+");
    }

    public static int getAltCount() {
        return nicknames.size();
    }

    public static int getMaxAlts() {
        return 100;
    }

    public static boolean hasNickname(String nickname) {
        return nicknames.contains(nickname);
    }

    public static void clearAllAlts() {
        nicknames.clear();
        lastUsed = null;
        AltManager.save();
        ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.cleared", (Object[])new Object[0]));
    }

    private static void save() {
        if (altsFile == null) {
            return;
        }
        try {
            JsonObject root = new JsonObject();
            JsonArray arr = new JsonArray();
            for (String n : nicknames) {
                if (n == null || n.trim().isEmpty()) continue;
                arr.add(n);
            }
            root.add("alts", (JsonElement)arr);
            if (lastUsed != null) {
                root.addProperty("lastUsed", lastUsed);
            }
            root.addProperty("version", "1.0");
            root.addProperty("maxAlts", (Number)100);
            try (FileWriter writer = new FileWriter(altsFile);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
        }
        catch (IOException e) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.saveError", (Object[])new Object[0]));
        }
    }

    private static void load() {
        if (altsFile == null) {
            return;
        }
        if (!altsFile.exists()) {
            AltManager.save();
            return;
        }
        try (FileReader reader = new FileReader(altsFile);){
            String lastUsedNick;
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            nicknames.clear();
            if (root.has("alts")) {
                JsonArray arr = root.getAsJsonArray("alts");
                for (JsonElement e : arr) {
                    String nickname = e.getAsString();
                    if (nickname == null || nickname.trim().isEmpty() || !AltManager.isValidNickname(nickname.trim())) continue;
                    nicknames.add(nickname.trim());
                }
            }
            if (root.has("lastUsed") && (lastUsedNick = root.get("lastUsed").getAsString()) != null && !lastUsedNick.trim().isEmpty() && AltManager.isValidNickname(lastUsedNick.trim())) {
                lastUsed = lastUsedNick.trim();
            }
            if (lastUsed != null && !nicknames.contains(lastUsed)) {
                lastUsed = null;
            }
        }
        catch (Exception e) {
            ChatUtils.sendMessage(class_1074.method_4662((String)"phantomvisuals.alt.loadError", (Object[])new Object[0]));
            if (altsFile.exists()) {
                File backup = new File(altsFile.getParent(), "alts_backup_" + System.currentTimeMillis() + ".json");
                altsFile.renameTo(backup);
            }
            AltManager.save();
        }
    }

    static {
        nicknames = new CopyOnWriteArrayList<String>();
        lastUsed = null;
    }
}

