/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.managers;

import dev.phantomvisuals.client.events.impl.EventGameShutdown;
import dev.phantomvisuals.client.events.impl.EventSettingChange;
import dev.phantomvisuals.client.managers.ConfigManager;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.phantomvisuals;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import meteordevelopment.orbit.EventHandler;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoSaveManager
implements Wrapper {
    private static final Logger LOGGER = LogManager.getLogger(AutoSaveManager.class);
    private static final String AUTO_SAVE_CONFIG_NAME = "autocfg";
    private final AtomicBoolean emergencySaving = new AtomicBoolean(false);
    private Thread shutdownHook;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "SV-AutoSaveScheduler"));
    private ScheduledFuture<?> pendingSave;
    private final Object saveLock = new Object();
    private volatile boolean allowAutoSave = false;

    public AutoSaveManager() {
        phantomvisuals.getInstance().getEventHandler().subscribe(this);
        this.registerShutdownHook();
        this.registerUncaughtExceptionHandler();
    }

    @EventHandler
    public void onGameShutdown(EventGameShutdown event) {
        LOGGER.info("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438...");
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        configManager.saveConfig(AUTO_SAVE_CONFIG_NAME).thenAccept(success -> {
            if (success.booleanValue()) {
                LOGGER.info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430 \u043a\u0430\u043a '{}'", (Object)AUTO_SAVE_CONFIG_NAME);
            } else {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u043c \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            }
        });
    }

    @EventHandler
    public void onSettingChanged(EventSettingChange event) {
        this.scheduleAutoSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAutoSave() {
        if (!this.allowAutoSave) {
            return;
        }
        Object object = this.saveLock;
        synchronized (object) {
            if (this.pendingSave != null && !this.pendingSave.isDone()) {
                this.pendingSave.cancel(false);
            }
            this.pendingSave = this.scheduler.schedule(this::doAutoSave, 500L, TimeUnit.MILLISECONDS);
        }
    }

    private void doAutoSave() {
        try {
            ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
            configManager.saveConfig(AUTO_SAVE_CONFIG_NAME).thenAccept(success -> {
                if (!success.booleanValue()) {
                    LOGGER.warn("\u0410\u0432\u0442\u043e\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c");
                }
            });
        }
        catch (Throwable t) {
            LOGGER.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0430\u0432\u0442\u043e\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f", t);
        }
    }

    public void loadAutoSave() {
        ClientTickEvents.END_CLIENT_TICK.register((Object)new ClientTickEvents.EndTick(){
            private boolean attempted = false;

            public void onEndTick(class_310 client) {
                if (this.attempted) {
                    return;
                }
                this.attempted = true;
                ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
                if (configManager.configExists(AutoSaveManager.AUTO_SAVE_CONFIG_NAME)) {
                    LOGGER.info("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '{}'...", (Object)AutoSaveManager.AUTO_SAVE_CONFIG_NAME);
                    configManager.loadConfig(AutoSaveManager.AUTO_SAVE_CONFIG_NAME).thenAccept(success -> {
                        if (success.booleanValue()) {
                            LOGGER.info("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430");
                        } else {
                            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
                        }
                        AutoSaveManager.this.allowAutoSave = true;
                    });
                } else {
                    AutoSaveManager.this.allowAutoSave = true;
                }
            }
        });
    }

    public void clearAutoSave() {
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        if (configManager.configExists(AUTO_SAVE_CONFIG_NAME)) {
            configManager.deleteConfig(AUTO_SAVE_CONFIG_NAME);
            LOGGER.info("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0430");
        }
    }

    public void forceSave() {
        LOGGER.info("\u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438...");
        ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
        try {
            boolean success = configManager.saveConfig(AUTO_SAVE_CONFIG_NAME).join();
            if (success) {
                LOGGER.info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430");
            } else {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            }
        }
        catch (Throwable t) {
            LOGGER.error("\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", t);
        }
    }

    private void registerShutdownHook() {
        if (this.shutdownHook != null) {
            return;
        }
        this.shutdownHook = new Thread(() -> this.emergencySave("JVM shutdown hook"), "SV-AutoCfg-ShutdownHook");
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Throwable t) {
            LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c shutdown hook \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f", t);
        }
    }

    private void registerUncaughtExceptionHandler() {
        try {
            Thread.setDefaultUncaughtExceptionHandler((thread2, throwable) -> {
                LOGGER.error("\u041d\u0435\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0432 \u043f\u043e\u0442\u043e\u043a\u0435 {}: {}", (Object)thread2.getName(), (Object)throwable.toString());
                this.emergencySave("Uncaught exception");
            });
        }
        catch (Throwable t) {
            LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u043d\u0435\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u044b\u0445 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u0434\u043b\u044f \u0430\u0432\u0442\u043e\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f", t);
        }
    }

    private void emergencySave(String reason) {
        if (!this.emergencySaving.compareAndSet(false, true)) {
            return;
        }
        try {
            LOGGER.info("\u042d\u043a\u0441\u0442\u0440\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 ({}).", (Object)reason);
            ConfigManager configManager = phantomvisuals.getInstance().getConfigManager();
            configManager.saveConfig(AUTO_SAVE_CONFIG_NAME).join();
            LOGGER.info("\u042d\u043a\u0441\u0442\u0440\u0435\u043d\u043d\u043e\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e");
        }
        catch (Throwable t) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u044d\u043a\u0441\u0442\u0440\u0435\u043d\u043d\u043e\u043c \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", t);
        }
    }
}

