/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.phantomvisuals.client.events.impl.EventThemeChanged;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.Setting;
import dev.phantomvisuals.modules.settings.api.Bind;
import dev.phantomvisuals.modules.settings.api.Position;
import dev.phantomvisuals.modules.settings.impl.BindSetting;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.ColorSetting;
import dev.phantomvisuals.modules.settings.impl.EnumSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import dev.phantomvisuals.modules.settings.impl.StringSetting;
import dev.phantomvisuals.phantomvisuals;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigManager
implements Wrapper {
    private static final Logger LOGGER = LogManager.getLogger(ConfigManager.class);
    private final Gson gson;
    private final File configsDir;
    private final Map<String, ConfigData> configCache = new HashMap<String, ConfigData>();

    public ConfigManager() {
        this.configsDir = new File(phantomvisuals.getInstance().getGlobalsDir(), "configs");
        if (!this.configsDir.exists()) {
            this.configsDir.mkdirs();
        }
        LOGGER.info("\u041f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439: {}", (Object)this.configsDir.getAbsolutePath());
        this.gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
    }

    public CompletableFuture<Boolean> saveConfig(String configName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ConfigData configData = new ConfigData();
                try {
                    String pref = phantomvisuals.getInstance().getCommandManager().getPrefix();
                    configData.setCommandPrefix(pref);
                }
                catch (Exception pref) {
                    // empty catch block
                }
                for (Module module : phantomvisuals.getInstance().getModuleManager().getModules()) {
                    ModuleData moduleData = new ModuleData();
                    moduleData.setToggled(module.isToggled());
                    moduleData.setBind(module.getBind());
                    HashMap<String, Object> settings = new HashMap<String, Object>();
                    for (Setting<?> setting : module.getSettings()) {
                        Object value = setting.getValue();
                        if (setting instanceof ColorSetting) {
                            value = String.format("%06X", (Integer)value);
                        } else if (setting instanceof BindSetting) {
                            Bind bind = (Bind)value;
                            String modeName = bind.getMode() != null ? bind.getMode().name() : Bind.Mode.TOGGLE.name();
                            value = bind.getKey() + ":" + bind.isMouse() + ":" + modeName;
                        } else if (setting instanceof ListSetting) {
                            ListSetting listSetting = (ListSetting)setting;
                            HashMap<String, Boolean> listValues = new HashMap<String, Boolean>();
                            for (BooleanSetting boolSetting : (List)listSetting.getValue()) {
                                listValues.put(boolSetting.getName(), (Boolean)boolSetting.getValue());
                            }
                            value = listValues;
                        }
                        settings.put(setting.getName(), value);
                    }
                    moduleData.setSettings(settings);
                    configData.getModules().put(module.getName(), moduleData);
                }
                configData.setCurrentTheme(ThemeManager.getInstance().getCurrentTheme().getName());
                HashMap<String, HudPositionData> hudPositions = new HashMap<String, HudPositionData>();
                for (HudElement hudElement : phantomvisuals.getInstance().getHudManager().getHudElements()) {
                    HudPositionData hudData = new HudPositionData();
                    hudData.setX(((Position)hudElement.getPosition().getValue()).getX());
                    hudData.setY(((Position)hudElement.getPosition().getValue()).getY());
                    try {
                        ListSetting elementsList = phantomvisuals.getInstance().getHudManager().getElements();
                        BooleanSetting bs = elementsList.getName(hudElement.getName());
                        boolean enabled = bs != null ? ((Boolean)bs.getValue()).booleanValue() : hudElement.isToggled();
                        hudData.setEnabled(enabled);
                    }
                    catch (Exception ignored) {
                        hudData.setEnabled(hudElement.isToggled());
                    }
                    hudPositions.put(hudElement.getName(), hudData);
                }
                configData.setHudPositions(hudPositions);
                HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
                for (HudElement hudElement : phantomvisuals.getInstance().getHudManager().getHudElements()) {
                    HashMap settings = new HashMap();
                    for (Setting<?> setting : hudElement.getSettings()) {
                        Object value = setting.getValue();
                        if (setting instanceof ColorSetting) {
                            value = String.format("%06X", (Integer)value);
                        } else if (setting instanceof ListSetting) {
                            ListSetting listSetting = (ListSetting)setting;
                            HashMap<String, Boolean> listValues = new HashMap<String, Boolean>();
                            for (BooleanSetting boolSetting : (List)listSetting.getValue()) {
                                listValues.put(boolSetting.getName(), (Boolean)boolSetting.getValue());
                            }
                            value = listValues;
                        } else if (setting instanceof BindSetting) {
                            Bind bind = (Bind)value;
                            String modeName = bind.getMode() != null ? bind.getMode().name() : Bind.Mode.TOGGLE.name();
                            value = bind.getKey() + ":" + bind.isMouse() + ":" + modeName;
                        }
                        settings.put(setting.getName(), value);
                    }
                    hashMap.put(hudElement.getName(), settings);
                }
                configData.setHudSettings(hashMap);
                File file = new File(this.configsDir, configName + ".phantom");
                String json = this.gson.toJson((Object)configData);
                Files.write(file.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                this.configCache.put(configName, configData);
                LOGGER.info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '{}' \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430", (Object)configName);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '{}': {}", (Object)configName, (Object)e.getMessage());
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> loadConfig(String configName) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                File configFile = new File(this.configsDir, configName + ".phantom");
                if (!configFile.exists()) {
                    LOGGER.error("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '{}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", (Object)configName);
                    return null;
                }
                String json = Files.readString(configFile.toPath());
                return (ConfigData)this.gson.fromJson(json, ConfigData.class);
            }
            catch (Exception e) {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '{}': {}", (Object)configName, (Object)e.getMessage());
                return null;
            }
        }).thenCompose(configData -> {
            CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
            if (configData == null) {
                result.complete(false);
                return result;
            }
            class_310.method_1551().execute(() -> {
                try {
                    String hudName;
                    Setting setting;
                    Object value;
                    String settingName;
                    try {
                        String pref = configData.getCommandPrefix();
                        if (pref != null && !pref.isEmpty()) {
                            phantomvisuals.getInstance().getCommandManager().setPrefix(pref);
                        }
                    }
                    catch (Exception pref) {
                        // empty catch block
                    }
                    for (Map.Entry entry : configData.getModules().entrySet()) {
                        ThemeManager.Theme[] moduleName = (ThemeManager.Theme[])entry.getKey();
                        ModuleData moduleData = (ModuleData)entry.getValue();
                        Module module = phantomvisuals.getInstance().getModuleManager().getModuleByName((String)moduleName);
                        if (module == null) continue;
                        if (moduleData.isToggled() != module.isToggled()) {
                            module.setToggled(moduleData.isToggled());
                        }
                        if (moduleData.getBind() != null) {
                            module.setBind(moduleData.getBind());
                        }
                        for (Map.Entry<String, Object> entry2 : moduleData.getSettings().entrySet()) {
                            settingName = entry2.getKey();
                            value = entry2.getValue();
                            setting = module.getSettings().stream().filter(s -> s.getName().equals(settingName)).findFirst().orElse(null);
                            if (setting == null) continue;
                            try {
                                this.setSettingValue(setting, value);
                            }
                            catch (Exception e) {
                                LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 {} \u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f {}: {}", (Object)settingName, (Object)moduleName, (Object)e.getMessage());
                            }
                        }
                    }
                    try {
                        ThemeManager.Theme[] themeArray;
                        ThemeManager themeManager = ThemeManager.getInstance();
                        for (ThemeManager.Theme theme : themeArray = themeManager.getAvailableThemes()) {
                            if (!theme.getName().equals(configData.getCurrentTheme())) continue;
                            themeManager.setTheme(theme);
                            phantomvisuals.getInstance().getEventHandler().post(new EventThemeChanged(theme));
                            break;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0435\u043c\u0443 {}: {}", (Object)configData.getCurrentTheme(), (Object)e.getMessage());
                    }
                    if (configData.getHudPositions() != null) {
                        try {
                            for (Map.Entry<String, Object> entry : configData.getHudPositions().entrySet()) {
                                hudName = entry.getKey();
                                HudPositionData hudData = (HudPositionData)entry.getValue();
                                HudElement hudElement = phantomvisuals.getInstance().getHudManager().getHudElements().stream().filter(element -> element.getName().equals(hudName)).findFirst().orElse(null);
                                if (hudElement == null) continue;
                                ((Position)hudElement.getPosition().getValue()).setX(hudData.getX());
                                ((Position)hudElement.getPosition().getValue()).setY(hudData.getY());
                                if (hudData.isEnabled() != hudElement.isToggled()) {
                                    hudElement.setToggled(hudData.isEnabled());
                                }
                                try {
                                    ListSetting elementsList = phantomvisuals.getInstance().getHudManager().getElements();
                                    BooleanSetting booleanSetting = elementsList.getName(hudName);
                                    if (booleanSetting == null || ((Boolean)booleanSetting.getValue()).booleanValue() == hudData.isEnabled()) continue;
                                    booleanSetting.setValue(hudData.isEnabled());
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u043e\u0437\u0438\u0446\u0438\u0438 HUD: {}", (Object)e.getMessage());
                        }
                    }
                    if (configData.getHudSettings() != null) {
                        for (Map.Entry<String, Object> entry : configData.getHudSettings().entrySet()) {
                            hudName = entry.getKey();
                            Map settings = (Map)entry.getValue();
                            HudElement hudElement = phantomvisuals.getInstance().getHudManager().getHudElements().stream().filter(element -> element.getName().equals(hudName)).findFirst().orElse(null);
                            if (hudElement == null) continue;
                            for (Map.Entry<String, Object> entry3 : settings.entrySet()) {
                                settingName = entry3.getKey();
                                value = entry3.getValue();
                                setting = hudElement.getSettings().stream().filter(s -> s.getName().equals(settingName)).findFirst().orElse(null);
                                if (setting == null) continue;
                                try {
                                    this.setSettingValue(setting, value);
                                }
                                catch (Exception e) {
                                    LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 {} \u0434\u043b\u044f HUD {}: {}", (Object)settingName, (Object)hudName, (Object)e.getMessage());
                                }
                            }
                        }
                    }
                    this.configCache.put(configName, (ConfigData)configData);
                    LOGGER.info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '{}' \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430", (Object)configName);
                    result.complete(true);
                }
                catch (Exception e) {
                    LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 '{}': {}", (Object)configName, (Object)e.getMessage());
                    result.complete(false);
                }
            });
            return result;
        });
    }

    public String[] getConfigList() {
        File[] files = this.configsDir.listFiles((dir, name) -> name.endsWith(".phantom"));
        if (files == null) {
            return new String[0];
        }
        String[] configs = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            configs[i] = files[i].getName().replace(".phantom", "");
        }
        return configs;
    }

    public String getConfigsDirectory() {
        return this.configsDir.getAbsolutePath();
    }

    public boolean deleteConfig(String configName) {
        File configFile = new File(this.configsDir, configName + ".phantom");
        if (configFile.exists()) {
            boolean deleted = configFile.delete();
            if (deleted) {
                this.configCache.remove(configName);
                LOGGER.info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f '{}' \u0443\u0434\u0430\u043b\u0435\u043d\u0430", (Object)configName);
            }
            return deleted;
        }
        return false;
    }

    public boolean configExists(String configName) {
        return new File(this.configsDir, configName + ".phantom").exists();
    }

    private void setSettingValue(Setting<?> setting, Object value) {
        block12: {
            block18: {
                block16: {
                    block17: {
                        block15: {
                            block14: {
                                block13: {
                                    block11: {
                                        if (!(setting instanceof BooleanSetting)) break block11;
                                        if (!(value instanceof Boolean)) break block12;
                                        ((BooleanSetting)setting).setValue((Boolean)value);
                                        break block12;
                                    }
                                    if (!(setting instanceof NumberSetting)) break block13;
                                    if (!(value instanceof Number)) break block12;
                                    NumberSetting numberSetting = (NumberSetting)setting;
                                    float floatValue = ((Number)value).floatValue();
                                    if (floatValue >= numberSetting.getMin() && floatValue <= numberSetting.getMax()) {
                                        numberSetting.setValue(Float.valueOf(floatValue));
                                    }
                                    break block12;
                                }
                                if (!(setting instanceof StringSetting)) break block14;
                                if (!(value instanceof String)) break block12;
                                ((StringSetting)setting).setValue((String)value);
                                break block12;
                            }
                            if (!(setting instanceof EnumSetting)) break block15;
                            if (!(value instanceof String)) break block12;
                            EnumSetting enumSetting = (EnumSetting)setting;
                            try {
                                enumSetting.setEnumValue((String)value);
                            }
                            catch (Exception e) {
                                LOGGER.warn("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 enum: {}", value);
                            }
                            break block12;
                        }
                        if (!(setting instanceof ColorSetting)) break block16;
                        if (!(value instanceof String)) break block17;
                        try {
                            int color = Integer.parseInt((String)value, 16);
                            ((ColorSetting)setting).setValue(color);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0446\u0432\u0435\u0442\u0430: {}", value);
                        }
                        break block12;
                    }
                    if (!(value instanceof Number)) break block12;
                    ((ColorSetting)setting).setValue(((Number)value).intValue());
                    break block12;
                }
                if (!(setting instanceof ListSetting)) break block18;
                if (!(value instanceof Map)) break block12;
                ListSetting listSetting = (ListSetting)setting;
                Map listValues = (Map)value;
                for (BooleanSetting boolSetting : (List)listSetting.getValue()) {
                    Object savedValue = listValues.get(boolSetting.getName());
                    if (!(savedValue instanceof Boolean)) continue;
                    boolSetting.setValue((Boolean)savedValue);
                }
                break block12;
            }
            if (!(setting instanceof BindSetting) || !(value instanceof String)) break block12;
            try {
                String[] parts = ((String)value).split(":");
                int key = Integer.parseInt(parts[0]);
                boolean isMouse = parts.length > 1 && Boolean.parseBoolean(parts[1]);
                Bind.Mode mode = Bind.Mode.TOGGLE;
                if (parts.length > 2) {
                    try {
                        mode = Bind.Mode.valueOf(parts[2]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                ((BindSetting)setting).setValue(new Bind(key, isMouse, mode));
            }
            catch (Exception e) {
                LOGGER.warn("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0431\u0438\u043d\u0434\u0430: {}", value);
            }
        }
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public File getConfigsDir() {
        return this.configsDir;
    }

    @Generated
    public Map<String, ConfigData> getConfigCache() {
        return this.configCache;
    }

    public static class ConfigData {
        private Map<String, ModuleData> modules = new HashMap<String, ModuleData>();
        private String currentTheme;
        private Map<String, HudPositionData> hudPositions = new HashMap<String, HudPositionData>();
        private Map<String, Map<String, Object>> hudSettings = new HashMap<String, Map<String, Object>>();
        private String commandPrefix;

        public Map<String, ModuleData> getModules() {
            return this.modules;
        }

        public void setModules(Map<String, ModuleData> modules) {
            this.modules = modules;
        }

        public String getCurrentTheme() {
            return this.currentTheme;
        }

        public void setCurrentTheme(String currentTheme) {
            this.currentTheme = currentTheme;
        }

        public Map<String, HudPositionData> getHudPositions() {
            return this.hudPositions;
        }

        public void setHudPositions(Map<String, HudPositionData> hudPositions) {
            this.hudPositions = hudPositions;
        }

        public Map<String, Map<String, Object>> getHudSettings() {
            return this.hudSettings;
        }

        public void setHudSettings(Map<String, Map<String, Object>> hudSettings) {
            this.hudSettings = hudSettings;
        }

        public String getCommandPrefix() {
            return this.commandPrefix;
        }

        public void setCommandPrefix(String commandPrefix) {
            this.commandPrefix = commandPrefix;
        }
    }

    public static class ModuleData {
        private boolean toggled;
        private Bind bind;
        private Map<String, Object> settings = new HashMap<String, Object>();

        public boolean isToggled() {
            return this.toggled;
        }

        public void setToggled(boolean toggled) {
            this.toggled = toggled;
        }

        public Bind getBind() {
            return this.bind;
        }

        public void setBind(Bind bind) {
            this.bind = bind;
        }

        public Map<String, Object> getSettings() {
            return this.settings;
        }

        public void setSettings(Map<String, Object> settings) {
            this.settings = settings;
        }
    }

    public static class HudPositionData {
        private float x;
        private float y;
        private boolean enabled;

        public float getX() {
            return this.x;
        }

        public void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        public void setY(float y) {
            this.y = y;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

