/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class FriendsManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<String> friends = new ArrayList<String>();
    private static File friendsFile;

    public static void init(File globalsDir) {
        friendsFile = new File(globalsDir, "friends.json");
        FriendsManager.load();
    }

    public static synchronized void addFriend(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (!FriendsManager.checkFriend(name)) {
            friends.add(name);
            FriendsManager.save();
        }
    }

    public static synchronized void removeFriend(String name) {
        if (name == null) {
            return;
        }
        friends.removeIf(n -> n.equalsIgnoreCase(name));
        FriendsManager.save();
    }

    public static synchronized boolean checkFriend(String name) {
        if (name == null) {
            return false;
        }
        for (String n : friends) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void clear() {
        friends.clear();
        FriendsManager.save();
    }

    public static synchronized List<String> getFriends() {
        return Collections.unmodifiableList(friends);
    }

    public static synchronized void save() {
        if (friendsFile == null) {
            return;
        }
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        for (String n : friends) {
            arr.add(n);
        }
        root.add("friends", (JsonElement)arr);
        try (FileWriter writer = new FileWriter(friendsFile);){
            GSON.toJson((JsonElement)root, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void load() {
        if (friendsFile == null) {
            return;
        }
        if (!friendsFile.exists()) {
            FriendsManager.save();
            return;
        }
        try (FileReader reader = new FileReader(friendsFile);){
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            friends.clear();
            if (root.has("friends")) {
                JsonArray arr = root.getAsJsonArray("friends");
                for (JsonElement e : arr) {
                    friends.add(e.getAsString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Generated
    public static File getFriendsFile() {
        return friendsFile;
    }
}

