/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.managers;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;

public class HitDetectionManager {
    private static HitDetectionManager instance;
    private static final long HIT_TOLERANCE_NANOS = 5000000L;
    private final Map<String, Long> lastHitTimes = new ConcurrentHashMap<String, Long>();

    private HitDetectionManager() {
    }

    public static HitDetectionManager getInstance() {
        if (instance == null) {
            instance = new HitDetectionManager();
        }
        return instance;
    }

    public boolean canProcessHit(class_1657 attacker, class_1297 target) {
        if (attacker == null || target == null) {
            return true;
        }
        String hitKey = this.generateHitKey(attacker, target);
        long currentTime = System.nanoTime();
        Long lastHitTime = this.lastHitTimes.get(hitKey);
        if (lastHitTime == null) {
            return true;
        }
        long timeDifference = currentTime - lastHitTime;
        return timeDifference >= 5000000L;
    }

    public void registerHit(class_1657 attacker, class_1297 target) {
        if (attacker == null || target == null) {
            return;
        }
        String hitKey = this.generateHitKey(attacker, target);
        this.lastHitTimes.put(hitKey, System.nanoTime());
    }

    public void cleanup() {
        long currentTime = System.nanoTime();
        long maxAge = 1000000000L;
        this.lastHitTimes.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > maxAge);
    }

    private String generateHitKey(class_1657 attacker, class_1297 target) {
        return attacker.method_5667().toString() + "->" + target.method_5667().toString();
    }

    public long getLastHitTime(class_1657 attacker, class_1297 target) {
        String hitKey = this.generateHitKey(attacker, target);
        Long lastHitTime = this.lastHitTimes.get(hitKey);
        return lastHitTime != null ? lastHitTime : 0L;
    }

    public double getTimeSinceLastHit(class_1657 attacker, class_1297 target) {
        String hitKey = this.generateHitKey(attacker, target);
        Long lastHitTime = this.lastHitTimes.get(hitKey);
        if (lastHitTime == null) {
            return Double.MAX_VALUE;
        }
        return (double)(System.nanoTime() - lastHitTime) / 1000000.0;
    }

    public int getActiveHitRecords() {
        return this.lastHitTimes.size();
    }
}

