/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.managers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ThemeManager {
    private static ThemeManager instance;
    private Theme currentTheme;
    private final List<ThemeChangeListener> listeners = new ArrayList<ThemeChangeListener>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    private ThemeManager() {
        this.currentTheme = new DarkTheme();
        this.startGradientUpdateTask();
    }

    public static ThemeManager getInstance() {
        if (instance == null) {
            instance = new ThemeManager();
        }
        return instance;
    }

    public void setCurrentTheme(String themeName) {
        for (Theme theme : this.getAvailableThemes()) {
            if (!theme.getName().equalsIgnoreCase(themeName)) continue;
            this.setTheme(theme);
            break;
        }
    }

    public void setTheme(Theme theme) {
        this.currentTheme = theme;
        this.notifyListeners();
    }

    public void addThemeChangeListener(ThemeChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeThemeChangeListener(ThemeChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (ThemeChangeListener listener : this.listeners) {
            listener.onThemeChanged(this.currentTheme);
        }
    }

    public Theme getCurrentTheme() {
        return this.currentTheme;
    }

    public Color getThemeColor() {
        return this.currentTheme.getBackgroundColor();
    }

    public Theme[] getAvailableThemes() {
        return new Theme[]{new VioletTheme(), new OrangeTheme(), new PureRedTheme(), new DarkGrayTheme(), new MidnightBlueTheme(), new HappyNewYearTheme(), new PhantomTheme(), new WinogradTheme(), new TwilightGradientTheme(), new EmeraldGlowTheme(), new AmethystFadeTheme(), new SunsetBlazeTheme(), new OceanBreezeTheme(), new AuroraBorealisTheme(), new CyberNeonTheme(), new LavaCoreTheme(), new RGBTheme(), new BlueTheme(), new GreenTheme(), new LightTheme(), new DarkTheme()};
    }

    private void startGradientUpdateTask() {
        this.scheduler.scheduleAtFixedRate(() -> {
            if (this.currentTheme instanceof GradientTheme) {
                this.notifyListeners();
            }
        }, 0L, 25L, TimeUnit.MILLISECONDS);
    }

    private static Color interpolateColor(Color start, Color end, float t) {
        int r = (int)((float)start.getRed() + (float)(end.getRed() - start.getRed()) * t);
        int g = (int)((float)start.getGreen() + (float)(end.getGreen() - start.getGreen()) * t);
        int b = (int)((float)start.getBlue() + (float)(end.getBlue() - start.getBlue()) * t);
        int a = (int)((float)start.getAlpha() + (float)(end.getAlpha() - start.getAlpha()) * t);
        return new Color(Math.max(0, Math.min(255, r)), Math.max(0, Math.min(255, g)), Math.max(0, Math.min(255, b)), Math.max(0, Math.min(255, a)));
    }

    public static class DarkTheme
    implements Theme {
        @Override
        public Color getBackgroundColor() {
            return new Color(30, 30, 30, 175);
        }

        @Override
        public Color getBorderColor() {
            return new Color(200, 200, 200, 100);
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public Color getAccentColor() {
            return new Color(100, 100, 100);
        }

        @Override
        public Color getSecondaryBackgroundColor() {
            return new Color(20, 20, 20, 200);
        }

        @Override
        public String getName() {
            return "Black";
        }
    }

    public static interface Theme {
        public Color getBackgroundColor();

        public Color getBorderColor();

        public Color getTextColor();

        public Color getAccentColor();

        public Color getSecondaryBackgroundColor();

        public String getName();
    }

    public static interface ThemeChangeListener {
        public void onThemeChanged(Theme var1);
    }

    public static class VioletTheme
    extends GradientTheme {
        public VioletTheme() {
            super(new Color[]{new Color(138, 43, 226, 160), new Color(75, 0, 130, 160)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Violet";
        }
    }

    public static class OrangeTheme
    extends GradientTheme {
        public OrangeTheme() {
            super(new Color[]{new Color(255, 120, 0, 160), new Color(255, 60, 0, 160)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Orange";
        }
    }

    public static class PureRedTheme
    extends GradientTheme {
        public PureRedTheme() {
            super(new Color[]{new Color(255, 0, 0, 160), new Color(150, 0, 0, 160)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Red";
        }
    }

    public static class DarkGrayTheme
    implements Theme {
        @Override
        public Color getBackgroundColor() {
            return new Color(40, 40, 40, 220);
        }

        @Override
        public Color getBorderColor() {
            return new Color(70, 70, 70);
        }

        @Override
        public Color getTextColor() {
            return Color.LIGHT_GRAY;
        }

        @Override
        public Color getAccentColor() {
            return Color.GRAY;
        }

        @Override
        public Color getSecondaryBackgroundColor() {
            return new Color(30, 30, 30);
        }

        @Override
        public String getName() {
            return "Dark Gray";
        }
    }

    public static class MidnightBlueTheme
    extends GradientTheme {
        public MidnightBlueTheme() {
            super(new Color[]{new Color(10, 10, 40, 180), new Color(20, 50, 100, 180)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Midnight";
        }
    }

    public static class HappyNewYearTheme
    extends GradientTheme {
        public HappyNewYearTheme() {
            super(new Color[]{new Color(255, 0, 0, 150), new Color(255, 255, 255, 200)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "HappyNewYear";
        }
    }

    public static class PhantomTheme
    extends GradientTheme {
        public PhantomTheme() {
            super(new Color[]{new Color(102, 45, 145, 150), new Color(0, 255, 255, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Phantom";
        }
    }

    public static class WinogradTheme
    extends GradientTheme {
        public WinogradTheme() {
            super(new Color[]{new Color(159, 172, 255, 150), new Color(86, 96, 163, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Winograd";
        }
    }

    public static class TwilightGradientTheme
    extends GradientTheme {
        public TwilightGradientTheme() {
            super(new Color[]{new Color(80, 42, 195, 150), new Color(156, 69, 211, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Twilight";
        }
    }

    public static class EmeraldGlowTheme
    extends GradientTheme {
        public EmeraldGlowTheme() {
            super(new Color[]{new Color(0, 204, 160, 150), new Color(15, 227, 0, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Emerald";
        }
    }

    public static class AmethystFadeTheme
    extends GradientTheme {
        public AmethystFadeTheme() {
            super(new Color[]{new Color(100, 50, 150, 150), new Color(180, 120, 220, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Amethyst";
        }
    }

    public static class SunsetBlazeTheme
    extends GradientTheme {
        public SunsetBlazeTheme() {
            super(new Color[]{new Color(200, 60, 20, 150), new Color(240, 140, 60, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Sunset";
        }
    }

    public static class OceanBreezeTheme
    extends GradientTheme {
        public OceanBreezeTheme() {
            super(new Color[]{new Color(20, 80, 120, 150), new Color(60, 160, 200, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Ocean";
        }
    }

    public static class AuroraBorealisTheme
    extends GradientTheme {
        public AuroraBorealisTheme() {
            super(new Color[]{new Color(10, 80, 60, 150), new Color(120, 100, 220, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Aurora";
        }
    }

    public static class CyberNeonTheme
    extends GradientTheme {
        public CyberNeonTheme() {
            super(new Color[]{new Color(0, 255, 200, 150), new Color(255, 0, 180, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Neon";
        }
    }

    public static class LavaCoreTheme
    extends GradientTheme {
        public LavaCoreTheme() {
            super(new Color[]{new Color(120, 0, 0, 150), new Color(255, 180, 0, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Lava";
        }
    }

    public static class RGBTheme
    extends GradientTheme {
        public RGBTheme() {
            super(new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.MAGENTA});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "RGB";
        }
    }

    public static class BlueTheme
    extends GradientTheme {
        public BlueTheme() {
            super(new Color[]{new Color(0, 0, 255, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Blue Static";
        }
    }

    public static class GreenTheme
    extends GradientTheme {
        public GreenTheme() {
            super(new Color[]{new Color(0, 255, 0, 150)});
        }

        @Override
        public Color getTextColor() {
            return Color.WHITE;
        }

        @Override
        public String getName() {
            return "Green Static";
        }
    }

    public static class LightTheme
    implements Theme {
        @Override
        public Color getBackgroundColor() {
            return new Color(255, 255, 255, 100);
        }

        @Override
        public Color getBorderColor() {
            return Color.WHITE;
        }

        @Override
        public Color getTextColor() {
            return Color.DARK_GRAY;
        }

        @Override
        public Color getAccentColor() {
            return Color.LIGHT_GRAY;
        }

        @Override
        public Color getSecondaryBackgroundColor() {
            return new Color(240, 240, 240, 100);
        }

        @Override
        public String getName() {
            return "White";
        }
    }

    private static abstract class GradientTheme
    implements Theme {
        protected final Color[] colors;
        protected static final long TRANSITION_DURATION = 1500L;

        protected GradientTheme(Color[] colors) {
            this.colors = colors;
        }

        protected float getInterpolationFactor() {
            long currentTime = System.currentTimeMillis();
            float phase = (float)(currentTime % (1500L * (long)this.colors.length)) / 1500.0f;
            float t = phase - (float)((int)phase);
            return (float)(Math.sin((double)t * Math.PI - 1.5707963267948966) * 0.5 + 0.5);
        }

        protected int getCurrentIndex() {
            return (int)(System.currentTimeMillis() % (1500L * (long)this.colors.length) / 1500L);
        }

        @Override
        public Color getBackgroundColor() {
            int idx = this.getCurrentIndex();
            return ThemeManager.interpolateColor(this.colors[idx], this.colors[(idx + 1) % this.colors.length], this.getInterpolationFactor());
        }

        @Override
        public Color getBorderColor() {
            return this.getBackgroundColor();
        }

        @Override
        public Color getAccentColor() {
            return this.getBackgroundColor();
        }

        @Override
        public Color getSecondaryBackgroundColor() {
            return this.getBackgroundColor();
        }
    }
}

