/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.render.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.Wrapper;
import java.awt.Color;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class JelloRenderer {
    private final ThemeManager themeManager;

    public JelloRenderer(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public void render(EventRender3D.Game e, class_1309 target, class_243 fadeOrigin, float lastKnownWidth, float lastKnownHeight, double jelloHeight, double jelloAnimationSpeed, boolean jelloGlow, double jelloGlowIntensity, float animationValue, Color overrideColor) {
        if (target == null && fadeOrigin == null) {
            return;
        }
        if (animationValue <= 0.0f) {
            return;
        }
        class_243 centerWorld = target != null ? target.method_30950(e.getTickDelta()).method_1031(0.0, (double)target.method_17682() * 0.5, 0.0) : fadeOrigin;
        class_4184 camera = Wrapper.mc.field_1773.method_19418();
        double tPosX = centerWorld.field_1352 - camera.method_19326().field_1352;
        double tPosY = centerWorld.field_1351 - camera.method_19326().field_1351 - (double)(target != null ? target.method_17682() : lastKnownHeight) * 0.5;
        double tPosZ = centerWorld.field_1350 - camera.method_19326().field_1350;
        float height = (float)jelloHeight * animationValue;
        double duration = jelloAnimationSpeed;
        double elapsed = (double)System.currentTimeMillis() % duration;
        boolean side = elapsed > duration / 2.0;
        double progress = elapsed / (duration / 2.0);
        progress = side ? (progress -= 1.0) : 1.0 - progress;
        progress = progress < 0.5 ? 2.0 * progress * progress : 1.0 - Math.pow(-2.0 * progress + 2.0, 2.0) / 2.0;
        double eased = (double)(height / 1.5f) * (progress > 0.5 ? 1.0 - progress : progress) * (double)(side ? -1 : 1) * (double)animationValue;
        class_4587 matrices = e.getMatrices();
        matrices.method_22903();
        matrices.method_22904(tPosX, tPosY, tPosZ);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.disableCull();
        if (Wrapper.mc.field_1724 != null && target != null && Wrapper.mc.field_1724.method_6057((class_1297)target)) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
        } else {
            RenderSystem.disableDepthTest();
        }
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        Color themeColor = overrideColor != null ? overrideColor : this.themeManager.getThemeColor();
        int baseBloomColor = new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), JelloRenderer.clamp255(255.0 * (jelloGlow ? jelloGlowIntensity : 1.0))).getRGB();
        int baseCoreColor = new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), JelloRenderer.clamp255(1.0)).getRGB();
        Matrix4f matrix = matrices.method_23760().method_23761();
        int segments = 360;
        float radius = lastKnownWidth * animationValue;
        int trailLayers = 6;
        for (int layer = 0; layer < trailLayers; ++layer) {
            float layerAlpha = Math.max(0.0f, 1.0f - (float)layer * 0.2f);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            for (int i = 0; i <= segments; ++i) {
                double angle = Math.toRadians(i);
                float x = (float)(Math.cos(angle) * (double)radius);
                float z = (float)(Math.sin(angle) * (double)radius);
                int finalCoreColor = JelloRenderer.applyAlphaToColor(baseCoreColor, layerAlpha);
                int finalBloomColor = JelloRenderer.applyAlphaToColor(baseBloomColor, layerAlpha);
                buffer.method_22918(matrix, x, (float)((double)height * progress + eased), z).method_39415(finalCoreColor);
                buffer.method_22918(matrix, x, (float)((double)height * progress), z).method_39415(finalBloomColor);
            }
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        GL11.glDisable((int)2848);
        RenderSystem.enableCull();
        if (Wrapper.mc.field_1724 != null && target != null && Wrapper.mc.field_1724.method_6057((class_1297)target)) {
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22909();
    }

    private static int clamp255(double v) {
        if (v < 0.0) {
            return 0;
        }
        if (v > 255.0) {
            return 255;
        }
        return (int)Math.round(v);
    }

    private static int applyAlphaToColor(int color, float alpha) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int existingAlpha = color >> 24 & 0xFF;
        int newAlpha = JelloRenderer.clamp255((float)existingAlpha * alpha);
        return newAlpha << 24 | r << 16 | g << 8 | b;
    }
}

