/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.render.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.events.impl.EventRender3D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class SoulRenderer {
    private final ThemeManager themeManager;

    public SoulRenderer(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public void render(EventRender3D.Game e, class_1309 target, int particleDensity, float ghostsScale, boolean ghostsGlow, double ghostsGlowIntensity, float animationValue, class_243 fadeOrigin, float lastKnownHeight, float lastKnownWidth, float alphaMultiplier, Color overrideColor) {
        class_287 buffer;
        Matrix4f matrix;
        double offsetZ;
        double offsetY;
        double offsetX;
        double sinQuad;
        double radians;
        float fadeMultiplier;
        float particleProgress;
        float iFloat;
        int i;
        float radius;
        float height;
        float iAge;
        double entZ;
        double entY;
        double entX;
        if (target == null && animationValue <= 0.0f) {
            return;
        }
        class_4184 camera = Wrapper.mc.field_1773.method_19418();
        if (target != null) {
            entX = target.field_6014 + (target.method_23317() - target.field_6014) * (double)e.getTickDelta();
            entY = target.field_6036 + (target.method_23318() - target.field_6036) * (double)e.getTickDelta();
            entZ = target.field_5969 + (target.method_23321() - target.field_5969) * (double)e.getTickDelta();
            iAge = (float)(target.field_6012 - 1) + (float)(target.field_6012 - (target.field_6012 - 1)) * e.getTickDelta();
            height = target.method_17682();
            radius = target.method_17681();
        } else if (fadeOrigin != null) {
            entX = fadeOrigin.field_1352;
            entY = fadeOrigin.field_1351;
            entZ = fadeOrigin.field_1350;
            iAge = 0.0f;
            height = lastKnownHeight;
            radius = lastKnownWidth;
        } else {
            return;
        }
        double tPosX = entX - camera.method_19326().field_1352;
        double tPosY = entY - camera.method_19326().field_1351;
        double tPosZ = entZ - camera.method_19326().field_1350;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.disableCull();
        RenderSystem.setShaderTexture((int)0, (class_2960)phantomvisuals.id("hud/bloom.png"));
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        if (Wrapper.mc.field_1724 != null && target != null && Wrapper.mc.field_1724.method_6057((class_1297)target)) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
        } else {
            RenderSystem.disableDepthTest();
        }
        float ageMultiplier = iAge * 2.5f;
        Color themeColor = overrideColor != null ? overrideColor : this.themeManager.getThemeColor();
        float scale = ghostsScale;
        class_4587 base = e.getMatrices();
        base.method_22903();
        if (target != null) {
            base.method_22904(tPosX, tPosY + (double)height * 0.5, tPosZ);
        } else {
            base.method_22904(tPosX, tPosY, tPosZ);
        }
        if (ghostsGlow) {
            float glowScale = scale * (1.0f + (float)ghostsGlowIntensity);
            for (int j = 0; j < 3; ++j) {
                float jOffset = j * 120;
                for (i = 0; i <= particleDensity; ++i) {
                    iFloat = i;
                    particleProgress = iFloat / (float)particleDensity;
                    fadeMultiplier = Math.min(1.0f, Math.max(0.0f, animationValue - particleProgress));
                    if (fadeMultiplier <= 0.0f) continue;
                    radians = Math.toRadians(((iFloat / 1.5f + iAge) * 8.0f + jOffset) % 2880.0f);
                    sinQuad = Math.sin(Math.toRadians(ageMultiplier + (float)(i * (j + 1))) * 3.0) / (double)1.8f;
                    int glowAlpha = SoulRenderer.clamp255(180.0 * ghostsGlowIntensity * (double)fadeMultiplier * (double)alphaMultiplier);
                    Color glowColor = new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), glowAlpha);
                    offsetX = Math.cos(radians) * (double)radius;
                    offsetY = sinQuad;
                    offsetZ = Math.sin(radians) * (double)radius;
                    base.method_22903();
                    base.method_22904(offsetX, offsetY, offsetZ);
                    base.method_22907(camera.method_23767());
                    matrix = base.method_23760().method_23761();
                    buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                    buffer.method_22918(matrix, -glowScale, glowScale, 0.0f).method_22913(0.0f, 1.0f).method_39415(glowColor.getRGB());
                    buffer.method_22918(matrix, glowScale, glowScale, 0.0f).method_22913(1.0f, 1.0f).method_39415(glowColor.getRGB());
                    buffer.method_22918(matrix, glowScale, -glowScale, 0.0f).method_22913(1.0f, 0.0f).method_39415(glowColor.getRGB());
                    buffer.method_22918(matrix, -glowScale, -glowScale, 0.0f).method_22913(0.0f, 0.0f).method_39415(glowColor.getRGB());
                    class_286.method_43433((class_9801)buffer.method_60800());
                    base.method_22909();
                }
            }
        }
        for (int j = 0; j < 3; ++j) {
            float jOffset = j * 120;
            float jMultiplier = j + 1;
            for (i = 0; i <= particleDensity; ++i) {
                iFloat = i;
                particleProgress = iFloat / (float)particleDensity;
                fadeMultiplier = Math.min(1.0f, Math.max(0.0f, animationValue - particleProgress));
                if (fadeMultiplier <= 0.0f) continue;
                radians = Math.toRadians(((iFloat / 1.5f + iAge) * 8.0f + jOffset) % 2880.0f);
                sinQuad = Math.sin(Math.toRadians(ageMultiplier + (float)i * jMultiplier) * 3.0) / (double)1.8f;
                float baseAlpha = Math.min(1.0f, Math.max(0.3f, iFloat / (float)particleDensity));
                int color = new Color(themeColor.getRed(), themeColor.getGreen(), themeColor.getBlue(), SoulRenderer.clamp255(200.0f * baseAlpha * fadeMultiplier * alphaMultiplier)).getRGB();
                offsetX = Math.cos(radians) * (double)radius;
                offsetY = sinQuad;
                offsetZ = Math.sin(radians) * (double)radius;
                base.method_22903();
                base.method_22904(offsetX, offsetY, offsetZ);
                base.method_22907(camera.method_23767());
                matrix = base.method_23760().method_23761();
                buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22918(matrix, -scale, scale, 0.0f).method_22913(0.0f, 1.0f).method_39415(color);
                buffer.method_22918(matrix, scale, scale, 0.0f).method_22913(1.0f, 1.0f).method_39415(color);
                buffer.method_22918(matrix, scale, -scale, 0.0f).method_22913(1.0f, 0.0f).method_39415(color);
                buffer.method_22918(matrix, -scale, -scale, 0.0f).method_22913(0.0f, 0.0f).method_39415(color);
                class_286.method_43433((class_9801)buffer.method_60800());
                base.method_22909();
            }
        }
        base.method_22909();
        if (Wrapper.mc.field_1724 != null && target != null && Wrapper.mc.field_1724.method_6057((class_1297)target)) {
            RenderSystem.depthMask((boolean)true);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public void renderOrbit(EventRender3D.Game e, class_1309 target, int soulsCount, float scale, float anim, class_243 fade, float height, float width, float alpha, Color color, float tilt, float distance) {
        class_243 pos;
        class_4587 matrices = e.getMatrices();
        class_243 class_2432 = pos = target != null ? target.method_30950(e.getTickDelta()) : fade;
        if (pos == null) {
            return;
        }
        double centerY = pos.field_1351 + (double)height * 0.5;
        double radius = width + distance;
        float time = (float)(System.currentTimeMillis() % 3000L) / 3000.0f * (float)Math.PI * 2.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        RenderSystem.setShaderTexture((int)0, (class_2960)phantomvisuals.id("hud/glow.png"));
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        for (int i = 0; i < soulsCount; ++i) {
            float angle = time + (float)i * ((float)Math.PI * 2 / (float)soulsCount);
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            double yOffset = Math.sin(angle) * (double)tilt;
            matrices.method_22903();
            class_243 cam = Wrapper.mc.field_1773.method_19418().method_19326();
            matrices.method_22904(pos.field_1352 + x - cam.field_1352, centerY + yOffset - cam.field_1351, pos.field_1350 + z - cam.field_1350);
            matrices.method_22907(Wrapper.mc.field_1773.method_19418().method_23767());
            float size = scale * anim;
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            int a = (int)(255.0f * alpha * anim);
            Matrix4f matrix = matrices.method_23760().method_23761();
            class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            buffer.method_22918(matrix, -size, size, 0.0f).method_22913(0.0f, 1.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, size, size, 0.0f).method_22913(1.0f, 1.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, size, -size, 0.0f).method_22913(1.0f, 0.0f).method_1336(r, g, b, a);
            buffer.method_22918(matrix, -size, -size, 0.0f).method_22913(0.0f, 0.0f).method_1336(r, g, b, a);
            class_286.method_43433((class_9801)buffer.method_60800());
            matrices.method_22909();
        }
        RenderSystem.depthMask((boolean)true);
    }

    private static int clamp255(double v) {
        if (v < 0.0) {
            return 0;
        }
        if (v > 255.0) {
            return 255;
        }
        return (int)Math.round(v);
    }
}

