/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.clickgui;

import dev.phantomvisuals.client.managers.OnlineCounter;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.clickgui.components.impl.ModuleComponent;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.impl.render.UI;
import dev.phantomvisuals.modules.impl.utility.ClientSound;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;

public class ClickGui
extends class_437
implements Wrapper {
    private final Animation yAnimation = new Animation(360L, 1.0, true, Easing.OUT_QUART);
    private final ThemeManager themeManager;
    private String description = "";
    private boolean closing = false;
    private float uiAlpha = 0.0f;
    private float contentOffsetY = 0.0f;
    private static final Category[] TABS = new Category[]{Category.Render, Category.Hud, Category.Utility, Category.Theme};
    private Category selectedCategory = Category.Render;
    private float x;
    private float y;
    private float width;
    private float height;
    private final Map<Category, List<ModuleComponent>> componentsByCategory = new EnumMap<Category, List<ModuleComponent>>(Category.class);
    private float scrollY = 0.0f;
    private float maxScroll = 0.0f;
    private float tabScrollY = 0.0f;
    private float maxTabScroll = 0.0f;
    private float scrollYTarget = 0.0f;
    private static final int COLS = 2;
    private static final float GAP = 8.0f;
    private ModuleComponent activeSettings = null;
    private float settingsScrollY = 0.0f;
    private float settingsMaxScroll = 0.0f;
    private float settingsScrollYTarget = 0.0f;
    private final Animation settingsAnimation = new Animation(280L, 1.0, true, Easing.OUT_QUART);

    public ClickGui() {
        super(class_2561.method_30163((String)"phantomvisuals-clickgui"));
        this.themeManager = ThemeManager.getInstance();
    }

    public void method_25426() {
        super.method_25426();
        this.width = 350.0f;
        this.height = 200.0f;
        this.x = ((float)mc.method_22683().method_4486() - this.width) / 2.0f;
        this.y = ((float)mc.method_22683().method_4502() - this.height) / 2.0f;
        this.buildComponentsCache();
        this.scrollY = 0.0f;
        this.scrollYTarget = 0.0f;
        this.tabScrollY = 0.0f;
        this.closing = false;
        this.yAnimation.update(true);
    }

    private void buildComponentsCache() {
        this.componentsByCategory.clear();
        for (Category cat : TABS) {
            if (cat == Category.Theme) continue;
            List<Module> mods = phantomvisuals.getInstance().getModuleManager().getModules(cat);
            ArrayList<ModuleComponent> comps = new ArrayList<ModuleComponent>(mods.size());
            for (Module m : mods) {
                comps.add(new ModuleComponent(m));
            }
            this.componentsByCategory.put(cat, comps);
        }
    }

    private void playToggleSound(boolean wasToggled) {
        ClientSound clientSound = phantomvisuals.getInstance().getModuleManager().getModule(ClientSound.class);
        if (clientSound != null && clientSound.isToggled()) {
            String soundId = wasToggled ? clientSound.getDisableSoundId() : clientSound.getEnableSoundId();
            float volume = ((Float)clientSound.getVolume().getValue()).floatValue();
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3414.method_47908((class_2960)class_2960.method_60654((String)soundId)), (float)1.0f, (float)volume));
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        float targetY = ((float)mc.method_22683().method_4502() - this.height) / 2.0f;
        float targetX = ((float)mc.method_22683().method_4486() - this.width) / 2.0f;
        if (this.closing) {
            this.yAnimation.update(false);
            if (this.yAnimation.getValue() <= 0.01f) {
                phantomvisuals.getInstance().getModuleManager().getModule(UI.class).setToggled(false);
                super.method_25419();
                return;
            }
        } else {
            this.yAnimation.update(true);
        }
        this.uiAlpha = Math.max(0.0f, Math.min(1.0f, this.yAnimation.getValue()));
        this.y = targetY + (1.0f - this.uiAlpha) * 12.0f;
        this.x = targetX;
        this.contentOffsetY = (1.0f - this.uiAlpha) * 8.0f;
        Render2D.drawRect(context.method_51448(), 0.0f, 0.0f, mc.method_22683().method_4486(), mc.method_22683().method_4502(), new Color(5, 5, 10, (int)(160.0f * this.uiAlpha)));
        this.renderPanelGlow(context);
        Color colorTop = new Color(35, 20, 60, 255);
        Color colorBottom = new Color(8, 8, 10, 255);
        try {
            Render2D.drawRoundedGradientRect(context.method_51448(), this.x, this.y, this.width, this.height, 12.0f, colorTop, colorTop, colorBottom, colorBottom);
        }
        catch (Error | Exception e) {
            Render2D.drawRoundedRect(context.method_51448(), this.x, this.y, this.width, this.height, 12.0f, colorBottom);
        }
        this.renderCategories(context);
        this.renderTopDescription(context);
        this.renderModulesArea(context, mouseX, mouseY, delta);
        this.renderBottomHints(context);
        this.renderOnlineRadar(context);
    }

    private void renderOnlineRadar(class_332 ctx) {
        if (this.uiAlpha <= 0.0f) {
            return;
        }
        float radarWidth = 110.0f;
        float radarX = (float)mc.method_22683().method_4486() - radarWidth - 10.0f;
        float radarY = 10.0f + (1.0f - this.uiAlpha) * -20.0f;
        int serverCount = OnlineCounter.playersOnMyServer.size();
        float dynamicHeight = 22.0f + (serverCount == 0 ? 10.0f : (float)serverCount * 10.0f);
        Render2D.drawRoundedRect(ctx.method_51448(), radarX, radarY, radarWidth, dynamicHeight, 6.0f, new Color(25, 25, 25, (int)(220.0f * this.uiAlpha)));
        String header = "\u0412\u0435\u0441\u044c: " + OnlineCounter.totalOnline + " | \u041d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435: " + serverCount;
        Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(7.0f), header, radarX + 5.0f, radarY + 5.0f, Color.WHITE);
        Render2D.drawRect(ctx.method_51448(), radarX + 5.0f, radarY + 16.0f, radarWidth - 10.0f, 0.5f, this.themeManager.getCurrentTheme().getAccentColor());
        float currentY = radarY + 19.0f;
        if (serverCount == 0) {
            Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(6.0f), "\u041d\u0438\u043a\u043e\u0433\u043e \u0440\u044f\u0434\u043e\u043c", radarX + 5.0f, currentY, new Color(150, 150, 150, (int)(255.0f * this.uiAlpha)));
        } else {
            for (String name : OnlineCounter.playersOnMyServer) {
                Render2D.drawRect(ctx.method_51448(), radarX + 5.0f, currentY + 2.5f, 2.0f, 2.0f, new Color(0, 255, 120, (int)(255.0f * this.uiAlpha)));
                Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(7.0f), name, radarX + 10.0f, currentY, Color.WHITE);
                currentY += 10.0f;
            }
        }
    }

    private void renderBottomHints(class_332 ctx) {
        if (this.uiAlpha <= 0.0f) {
            return;
        }
        String hint1 = class_1074.method_4662((String)"phantomvisuals.clickgui.hint.bind", (Object[])new Object[0]);
        String hint2 = class_1074.method_4662((String)"phantomvisuals.clickgui.hint.settings", (Object[])new Object[0]);
        float fontSize = 7.0f;
        float screenCenterX = (float)mc.method_22683().method_4486() / 2.0f;
        Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(fontSize), hint1, screenCenterX - Fonts.MEDIUM.getWidth(hint1, fontSize) / 2.0f, this.y + this.height + 6.0f, new Color(255, 255, 255, (int)(200.0f * this.uiAlpha)));
        Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(fontSize), hint2, screenCenterX - Fonts.MEDIUM.getWidth(hint2, fontSize) / 2.0f, this.y + this.height + 16.0f, new Color(255, 255, 255, (int)(200.0f * this.uiAlpha)));
    }

    private void renderPanelGlow(class_332 ctx) {
        if (this.uiAlpha <= 0.0f) {
            return;
        }
        Render2D.drawShaderBlurRect(ctx.method_51448(), this.x - 4.0f, this.y - 4.0f, this.width + 8.0f, this.height + 8.0f, 15.0f, 12.0f, new Color(80, 60, 255, (int)(40.0f * this.uiAlpha)));
    }

    private void renderCategories(class_332 ctx) {
        float startY = this.y + 8.0f + this.contentOffsetY;
        float tabW = 40.0f;
        float tabH = 17.0f;
        float gap = 5.0f;
        float startX = this.x + (this.width - ((float)TABS.length * tabW + (float)(TABS.length - 1) * gap)) / 2.0f;
        for (int i = 0; i < TABS.length; ++i) {
            Category cat = TABS[i];
            boolean active = cat == this.selectedCategory;
            float drawX = startX + (float)i * (tabW + gap);
            if (active) {
                Color acc = this.themeManager.getCurrentTheme().getAccentColor();
                Render2D.drawRoundedRect(ctx.method_51448(), drawX, startY, tabW, tabH, 4.0f, new Color(acc.getRed(), acc.getGreen(), acc.getBlue(), (int)(255.0f * this.uiAlpha)));
            } else {
                Render2D.drawRoundedRect(ctx.method_51448(), drawX, startY, tabW, tabH, 4.0f, new Color(20, 20, 20, (int)(170.0f * this.uiAlpha)));
            }
            Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(8.0f), cat.name(), drawX + (tabW - Fonts.MEDIUM.getWidth(cat.name(), 8.0f)) / 2.0f, startY + 3.0f, Color.WHITE);
        }
    }

    private void renderTopDescription(class_332 ctx) {
        if (this.description == null || this.description.isEmpty()) {
            return;
        }
        String descText = class_1074.method_4662((String)this.description, (Object[])new Object[0]);
        Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(8.0f), descText, this.x + (this.width - Fonts.MEDIUM.getWidth(descText, 8.0f)) / 2.0f, this.y - 12.0f, new Color(255, 255, 255, (int)(255.0f * this.uiAlpha)));
        this.description = "";
    }

    private void renderModulesArea(class_332 ctx, int mouseX, int mouseY, float delta) {
        float leftX = this.x + 6.0f;
        float leftY = this.y + 25.0f + this.contentOffsetY;
        float leftW = this.width - 12.0f;
        float leftH = this.height - 40.0f;
        this.scrollY += (this.scrollYTarget - this.scrollY) * 0.18f;
        this.scrollY = ClickGui.clamp(this.scrollY, 0.0f, this.maxScroll);
        Render2D.startScissor(ctx, leftX, leftY, leftW, leftH);
        if (this.selectedCategory == Category.Theme) {
            float themeY = leftY + 2.0f - this.scrollY;
            float totalHeight = 0.0f;
            for (ThemeManager.Theme theme : this.themeManager.getAvailableThemes()) {
                Render2D.drawFont(ctx.method_51448(), Fonts.MEDIUM.getFont(8.0f), theme.getName(), leftX + 6.0f, themeY + 4.0f, this.themeManager.getCurrentTheme().getTextColor());
                Render2D.drawRect(ctx.method_51448(), leftX + leftW - 18.0f, themeY + 4.0f, 8.0f, 8.0f, theme.getBackgroundColor());
                themeY += 18.0f;
                totalHeight += 18.0f;
            }
            this.maxScroll = Math.max(0.0f, totalHeight - leftH);
        } else {
            List comps = this.componentsByCategory.getOrDefault((Object)this.selectedCategory, Collections.emptyList());
            float colW = (leftW - 8.0f) / 2.0f;
            float[] baseY = new float[2];
            Arrays.fill(baseY, leftY + 2.0f);
            float maxBottom = leftY;
            for (int i = 0; i < comps.size(); ++i) {
                int col = i % 2;
                ModuleComponent mcComp = (ModuleComponent)comps.get(i);
                mcComp.setX(leftX + (float)col * (colW + 8.0f));
                mcComp.setY(baseY[col] - this.scrollY);
                mcComp.setWidth(colW);
                mcComp.setRenderExternally(true);
                mcComp.setGlobalAlpha(this.uiAlpha);
                mcComp.render(ctx, mouseX, mouseY, delta);
                int n = col;
                baseY[n] = baseY[n] + (mcComp.getHeight() + 8.0f);
                maxBottom = Math.max(maxBottom, baseY[col]);
            }
            this.maxScroll = Math.max(0.0f, maxBottom - 8.0f - (leftY + leftH));
        }
        Render2D.stopScissor(ctx);
        this.renderSettings(ctx, mouseX, mouseY, delta);
    }

    private void renderSettings(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.activeSettings == null) {
            return;
        }
        this.settingsAnimation.update(true);
        float anim = this.settingsAnimation.getValue();
        if (anim > 0.01f) {
            float panelW = 100.0f;
            float panelH = this.height - 40.0f;
            float drawPanelX = this.x + this.width + 4.0f + (1.0f - anim) * 20.0f;
            float panelY = this.y + 20.0f + this.contentOffsetY;
            Render2D.drawRoundedRect(ctx.method_51448(), drawPanelX, panelY, panelW, panelH, 4.0f, new Color(0, 0, 0, (int)(255.0f * anim * this.uiAlpha)));
            this.activeSettings.setGlobalAlpha(anim * this.uiAlpha);
            float total = this.activeSettings.renderSettingsExternally(ctx, drawPanelX + 5.0f, panelY + 5.0f, panelW - 10.0f, drawPanelX + 5.0f, panelY + 5.0f, panelW - 10.0f, panelH - 10.0f, mouseX, mouseY, delta, this.settingsScrollY);
            this.settingsMaxScroll = Math.max(0.0f, total - (panelH - 10.0f));
            this.settingsScrollY += (this.settingsScrollYTarget - this.settingsScrollY) * 0.2f;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.closing) {
            return false;
        }
        float startY = this.y + 8.0f + this.contentOffsetY;
        float tabW = 38.0f;
        float tabH = 13.0f;
        float gap = 5.0f;
        float startX = this.x + (this.width - ((float)TABS.length * tabW + (float)(TABS.length - 1) * gap)) / 2.0f;
        for (int i = 0; i < TABS.length; ++i) {
            float dx = startX + (float)i * (tabW + gap);
            if (!(mouseX >= (double)dx) || !(mouseX <= (double)(dx + tabW)) || !(mouseY >= (double)startY) || !(mouseY <= (double)(startY + tabH))) continue;
            this.selectedCategory = TABS[i];
            this.scrollYTarget = 0.0f;
            this.activeSettings = null;
            return true;
        }
        if (this.selectedCategory == Category.Theme && button == 0) {
            float leftX = this.x + 6.0f;
            float leftY = this.y + 25.0f + this.contentOffsetY;
            float themeY = leftY + 2.0f - this.scrollY;
            for (ThemeManager.Theme theme : this.themeManager.getAvailableThemes()) {
                if (mouseX >= (double)leftX && mouseX <= (double)(leftX + (this.width - 12.0f)) && mouseY >= (double)themeY && mouseY <= (double)(themeY + 18.0f)) {
                    this.themeManager.setTheme(theme);
                    this.playToggleSound(true);
                    return true;
                }
                themeY += 18.0f;
            }
        } else {
            for (ModuleComponent mcComp : this.componentsByCategory.getOrDefault((Object)this.selectedCategory, Collections.emptyList())) {
                boolean hovered = mouseX >= (double)mcComp.getX() && mouseX <= (double)(mcComp.getX() + mcComp.getWidth()) && mouseY >= (double)mcComp.getY() && mouseY <= (double)(mcComp.getY() + 24.0f);
                if (!hovered) continue;
                boolean wasToggled = mcComp.getModule().isToggled();
                if (button == 1) {
                    this.activeSettings = mcComp.getComponents().isEmpty() ? null : mcComp;
                    this.settingsScrollYTarget = 0.0f;
                }
                mcComp.mouseClicked(mouseX, mouseY, button);
                if (button == 0 && wasToggled != mcComp.getModule().isToggled()) {
                    this.playToggleSound(wasToggled);
                }
                return true;
            }
        }
        if (this.activeSettings != null && this.settingsAnimation.getValue() > 0.5f) {
            this.activeSettings.mouseClickedExternal(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.selectedCategory != Category.Theme) {
            this.componentsByCategory.getOrDefault((Object)this.selectedCategory, Collections.emptyList()).forEach(c -> c.mouseReleased(mouseX, mouseY, button));
        }
        if (this.activeSettings != null) {
            this.activeSettings.mouseReleasedExternal(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        float step = (float)(-vertical * 12.0);
        if (mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width)) {
            this.scrollYTarget = ClickGui.clamp(this.scrollYTarget + step, 0.0f, this.maxScroll);
        } else if (this.activeSettings != null) {
            this.settingsScrollYTarget = ClickGui.clamp(this.settingsScrollYTarget + step, 0.0f, this.settingsMaxScroll);
        }
        return super.method_25401(mouseX, mouseY, horizontal, vertical);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (List<ModuleComponent> comps : this.componentsByCategory.values()) {
            for (ModuleComponent mcComp : comps) {
                mcComp.keyPressed(keyCode, scanCode, modifiers);
            }
        }
        boolean anyBinding = this.componentsByCategory.values().stream().flatMap(Collection::stream).anyMatch(c -> {
            try {
                return false;
            }
            catch (Exception e) {
                return false;
            }
        });
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public void setDescription(String text) {
        this.description = text == null ? "" : text;
    }

    public void method_25419() {
        if (!this.closing) {
            this.closing = true;
            this.yAnimation.update(false);
        }
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }
}

