/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.clickgui.components.impl;

import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.clickgui.components.Component;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.animations.infinity.InfinityAnimation;
import dev.phantomvisuals.client.util.math.MathUtils;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.settings.api.Bind;
import dev.phantomvisuals.modules.settings.impl.BindSetting;
import java.awt.Color;
import net.minecraft.class_1074;
import net.minecraft.class_332;

public class BindComponent
extends Component {
    private final BindSetting setting;
    private final InfinityAnimation animation = new InfinityAnimation(Easing.LINEAR);
    private final Animation bindingAnimation = new Animation(300L, 1.0, false, Easing.BOTH_SINE);
    private boolean binding;

    public BindComponent(BindSetting setting) {
        super(setting.getName());
        this.setting = setting;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.bindingAnimation.update(this.binding);
        String text = this.binding ? "..." : ((Bind)this.setting.getValue()).toString().replace("_", " ");
        float textWidth = Fonts.REGULAR.getWidth(text, 6.5f);
        float finalWidth = this.animation.animate(textWidth + 4.0f, 200L);
        Color themeText = ThemeManager.getInstance().getCurrentTheme().getTextColor();
        Color accent = ThemeManager.getInstance().getCurrentTheme().getAccentColor();
        Color boxColor = new Color(accent.getRed(), accent.getGreen(), accent.getBlue(), 160);
        Color textColorNormal = new Color(themeText.getRed(), themeText.getGreen(), themeText.getBlue(), 220);
        int alphaBind = (int)(255.0f * this.bindingAnimation.getReversedValue());
        int alphaDots = (int)(255.0f * this.bindingAnimation.getValue());
        Color textColorBind = new Color(themeText.getRed(), themeText.getGreen(), themeText.getBlue(), alphaBind);
        Color textColorDots = new Color(themeText.getRed(), themeText.getGreen(), themeText.getBlue(), alphaDots);
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(7.5f), class_1074.method_4662((String)this.setting.getName(), (Object[])new Object[0]), this.x + 4.0f, this.y + 3.0f, textColorNormal);
        Render2D.drawRoundedRect(context.method_51448(), this.x + this.width - finalWidth - 4.0f, this.y, finalWidth, this.height - 7.0f, 1.5f, boxColor);
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(6.5f), ((Bind)this.setting.getValue()).toString().replace("_", " "), this.x + this.width - textWidth - 6.0f, this.y + 2.3f, textColorBind);
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(6.5f), "...", this.x + this.width - textWidth - 6.0f, this.y + 2.0f, textColorDots);
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        String text = this.binding ? "..." : ((Bind)this.setting.getValue()).toString().replace("_", " ");
        float textWidth = Fonts.REGULAR.getWidth(text, 6.5f);
        if (MathUtils.isHovered(this.x + this.width - 8.0f - textWidth, this.y + 2.0f, textWidth + 4.0f, this.height - 4.0f, (float)mouseX, (float)mouseY) && !this.binding && button == 0) {
            this.binding = true;
            return;
        }
        if (this.binding) {
            Bind.Mode mode = this.setting.getValue() != null ? ((Bind)this.setting.getValue()).getMode() : Bind.Mode.TOGGLE;
            this.setting.setValue(new Bind(button, true, mode));
            this.binding = false;
            return;
        }
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int button) {
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.binding) {
            if (keyCode == 256 || keyCode == 261) {
                this.setting.setValue(new Bind(-1, false));
            } else {
                Bind.Mode mode = this.setting.getValue() != null ? ((Bind)this.setting.getValue()).getMode() : Bind.Mode.TOGGLE;
                this.setting.setValue(new Bind(keyCode, false, mode));
            }
            this.binding = false;
        }
    }

    @Override
    public void keyReleased(int keyCode, int scanCode, int modifiers) {
    }

    @Override
    public void charTyped(char chr, int modifiers) {
    }
}

