/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.clickgui.components.impl;

import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.clickgui.components.Component;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.math.MathUtils;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import java.awt.Color;
import net.minecraft.class_1074;
import net.minecraft.class_332;

public class BooleanComponent
extends Component {
    private final BooleanSetting setting;
    private final Animation toggleAnimation = new Animation(300L, 1.0, true, Easing.phantomvisuals);

    public BooleanComponent(BooleanSetting setting) {
        super(setting.getName());
        this.setting = setting;
        this.visible = setting::isVisible;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.toggleAnimation.update((Boolean)this.setting.getValue());
        float ga = Math.max(0.0f, Math.min(1.0f, this.getGlobalAlpha()));
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(7.5f), class_1074.method_4662((String)this.setting.getName(), (Object[])new Object[0]), this.x + 4.0f, this.y + 3.0f, new Color(ThemeManager.getInstance().getCurrentTheme().getTextColor().getRed(), ThemeManager.getInstance().getCurrentTheme().getTextColor().getGreen(), ThemeManager.getInstance().getCurrentTheme().getTextColor().getBlue(), (int)((float)ThemeManager.getInstance().getCurrentTheme().getTextColor().getAlpha() * ga)));
        Color accent = ThemeManager.getInstance().getCurrentTheme().getAccentColor();
        float animValue = this.toggleAnimation.getValue();
        float switchX = this.x + this.width - 14.0f;
        float switchY = this.y + 3.0f;
        float switchSize = 10.0f;
        int alpha = Math.max(0, Math.min(255, (int)(255.0f * animValue * ga)));
        int backgroundAlpha = (int)(255.0f * ga);
        Render2D.drawRoundedRect(context.method_51448(), switchX - 2.0f, switchY - 2.0f, switchSize + 4.0f, switchSize + 4.0f, 2.0f, new Color(67, 67, 67, backgroundAlpha));
        if (animValue > 0.1f) {
            Render2D.drawFont(context.method_51448(), Fonts.ICONS.getFont(switchSize), "D", switchX + 1.7f, switchY, new Color(accent.getRed(), accent.getGreen(), accent.getBlue(), alpha));
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        float switchX = this.x + this.width - 14.0f;
        float switchY = this.y + 3.5f;
        float switchSize = 10.0f;
        if (MathUtils.isHovered(switchX - 2.0f, switchY - 2.0f, switchSize + 4.0f, switchSize + 4.0f, (float)mouseX, (float)mouseY) && button == 0) {
            this.setting.setValue((Boolean)this.setting.getValue() == false);
        }
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int button) {
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleased(int keyCode, int scanCode, int modifiers) {
    }

    @Override
    public void charTyped(char chr, int modifiers) {
    }
}

