/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.clickgui.components.impl;

import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.clickgui.ClickGui;
import dev.phantomvisuals.client.ui.clickgui.components.Component;
import dev.phantomvisuals.client.ui.clickgui.components.impl.BindComponent;
import dev.phantomvisuals.client.ui.clickgui.components.impl.BooleanComponent;
import dev.phantomvisuals.client.ui.clickgui.components.impl.EnumComponent;
import dev.phantomvisuals.client.ui.clickgui.components.impl.ListComponent;
import dev.phantomvisuals.client.ui.clickgui.components.impl.SliderComponent;
import dev.phantomvisuals.client.ui.clickgui.components.impl.StringComponent;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.math.MathUtils;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.Setting;
import dev.phantomvisuals.modules.settings.api.Bind;
import dev.phantomvisuals.modules.settings.impl.BindSetting;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.EnumSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import dev.phantomvisuals.modules.settings.impl.StringSetting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ModuleComponent
extends Component {
    private final Module module;
    private boolean open;
    private boolean binding;
    private boolean showBindModeMenu;
    private boolean renderExternally;
    private float bindTextX;
    private float bindTextY;
    private float bindTextW;
    private float bindTextH;
    private final List<Component> components = new ArrayList<Component>();
    private final Animation hoverAnim = new Animation(200L, 1.0, false, Easing.BOTH_SINE);
    private final Animation toggleAnim = new Animation(200L, 1.0, false, Easing.BOTH_SINE);
    private final Animation openAnimation = new Animation(300L, 1.0, false, Easing.BOTH_SINE);
    private final Animation bindMenuAnimation = new Animation(200L, 1.0, false, Easing.BOTH_SINE);
    private boolean toggleAnimInitialized;
    private boolean lastToggleState;
    private boolean isToggleAnimating;
    private boolean hoverAnimInitialized;
    private static final float HEADER_HEIGHT = 24.0f;
    private static final float CHILD_HEIGHT = 20.0f;

    public ModuleComponent(Module module) {
        super(module.getName());
        this.module = module;
        this.lastToggleState = module.isToggled();
        for (Setting<?> setting : module.getSettings()) {
            if (setting instanceof BooleanSetting) {
                this.components.add(new BooleanComponent((BooleanSetting)setting));
                continue;
            }
            if (setting instanceof NumberSetting) {
                this.components.add(new SliderComponent((NumberSetting)setting));
                continue;
            }
            if (setting instanceof EnumSetting) {
                this.components.add(new EnumComponent((EnumSetting)setting));
                continue;
            }
            if (setting instanceof StringSetting) {
                this.components.add(new StringComponent((StringSetting)setting));
                continue;
            }
            if (setting instanceof ListSetting) {
                this.components.add(new ListComponent((ListSetting)setting));
                continue;
            }
            if (!(setting instanceof BindSetting)) continue;
            this.components.add(new BindComponent((BindSetting)setting));
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_437 class_4372;
        boolean hovered = MathUtils.isHovered(this.x, this.y, this.width, 24.0f, mouseX, mouseY);
        if (hovered && (class_4372 = ModuleComponent.mc.field_1755) instanceof ClickGui) {
            ClickGui clickGui = (ClickGui)class_4372;
            clickGui.setDescription(this.module.getDescription());
        }
        if (!this.hoverAnimInitialized) {
            this.hoverAnim.setDuration(0L);
            this.hoverAnim.update(hovered);
            this.hoverAnim.setDuration(200L);
            this.hoverAnimInitialized = true;
        } else {
            this.hoverAnim.update(hovered);
        }
        boolean currentState = this.module.isToggled();
        if (!this.toggleAnimInitialized) {
            this.toggleAnim.setDuration(0L);
            this.toggleAnim.update(currentState);
            this.toggleAnim.setDuration(200L);
            this.toggleAnimInitialized = true;
            this.lastToggleState = currentState;
            this.isToggleAnimating = false;
        } else if (currentState != this.lastToggleState) {
            this.toggleAnim.setDuration(200L);
            this.toggleAnim.update(currentState);
            this.lastToggleState = currentState;
            this.isToggleAnimating = true;
        } else if (this.isToggleAnimating && this.toggleAnim.finished(currentState)) {
            this.isToggleAnimating = false;
        }
        this.openAnimation.update(this.open);
        this.bindMenuAnimation.update(this.showBindModeMenu);
        Color base = new Color(0, 0, 0, (int)(120.0f * Math.max(0.0f, Math.min(1.0f, this.globalAlpha))));
        Color themeAccent = ThemeManager.getInstance().getCurrentTheme().getAccentColor();
        Color active = new Color(themeAccent.getRed(), themeAccent.getGreen(), themeAccent.getBlue(), 180);
        Color bg = base;
        float totalHeight = this.getHeight();
        Render2D.drawRoundedRect(context.method_51448(), this.x, this.y, this.width, totalHeight, 5.0f, bg);
        Color textColor = new Color(255, 255, 255, (int)((200.0f + 55.0f * this.hoverAnim.getValue()) * Math.max(0.0f, Math.min(1.0f, this.globalAlpha))));
        float titleFontSize = 8.0f;
        float titleFontH = Fonts.REGULAR.getHeight(titleFontSize);
        float titleY = this.y + (24.0f - titleFontH) / 2.0f;
        String localizedModuleName = class_1074.method_4662((String)this.module.getName(), (Object[])new Object[0]);
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(titleFontSize), localizedModuleName, this.x + 8.0f, titleY, textColor);
        String bindText = "";
        if (this.binding) {
            bindText = "Press key...";
        } else if (this.module.getBind() != null && this.module.getBind().getKey() != -1) {
            bindText = this.module.getBind().toString().replace("_", " ");
        }
        float bindFontSize = 6.0f;
        this.bindTextW = bindText.isEmpty() ? 0.0f : Fonts.REGULAR.getWidth(bindText, bindFontSize);
        this.bindTextH = Fonts.REGULAR.getHeight(bindFontSize);
        this.bindTextX = Float.NaN;
        this.bindTextY = Float.NaN;
        if (!this.toggleAnimInitialized) {
            this.toggleAnim.setDuration(0L);
            this.toggleAnim.update(this.module.isToggled());
            this.toggleAnim.setDuration(200L);
            this.toggleAnimInitialized = true;
        }
        float switchW = 20.0f;
        float switchH = 10.0f;
        float reservedRight = 0.0f;
        float switchX = this.x + this.width - reservedRight - 24.0f;
        float switchY = this.y + (24.0f - switchH) / 2.0f;
        Color accent = ThemeManager.getInstance().getCurrentTheme().getAccentColor();
        float progress = this.isToggleAnimating ? this.toggleAnim.getValue() : (currentState ? 1.0f : 0.0f);
        Render2D.drawRoundedRect(context.method_51448(), switchX, switchY, switchW * progress, switchH, 4.0f, new Color(accent.getRed(), accent.getGreen(), accent.getBlue(), (int)(255.0f * progress * Math.max(0.0f, Math.min(1.0f, this.globalAlpha)))));
        Render2D.drawRoundedRect(context.method_51448(), switchX + switchW * progress, switchY, switchW * (1.0f - progress), switchH, 3.0f, new Color(23, 23, 23, (int)(100.0f * Math.max(0.0f, Math.min(1.0f, this.globalAlpha)))));
        float thumbW = 8.0f;
        float thumbH = 8.0f;
        float padding = 1.5f;
        float thumbX = switchX + padding + (switchW - thumbW - 2.0f * padding) * progress;
        float thumbY = switchY + padding + (switchH - thumbH - 2.0f * padding) / 2.0f;
        Render2D.drawRoundedRect(context.method_51448(), thumbX, thumbY, thumbW, thumbH, 3.0f, Color.WHITE);
        if (this.open && !this.renderExternally) {
            float childY = this.y + 24.0f;
            float visibleH = this.getChildrenFullHeight();
            context.method_44379((int)this.x, (int)(this.y + 24.0f), (int)(this.x + this.width), (int)(this.y + 24.0f + visibleH));
            for (Component component : this.components) {
                if (!component.getVisible().get().booleanValue()) continue;
                component.setX(this.x + 5.0f);
                component.setY(childY);
                component.setWidth(this.width - 10.0f);
                component.setHeight(20.0f);
                component.setGlobalAlpha(this.globalAlpha);
                component.render(context, mouseX, mouseY, delta);
                childY += component.getHeight() + component.getAddHeight().get().floatValue();
            }
            context.method_44380();
        }
        if (!bindText.isEmpty()) {
            float totalHeightAfter = this.getHeight();
            this.bindTextX = this.x + 8.0f;
            this.bindTextY = this.y + totalHeightAfter - this.bindTextH - 1.0f;
            Render2D.drawFont(context.method_51448(), Fonts.REGULAR.getFont(bindFontSize), bindText, this.bindTextX, this.bindTextY, new Color(200, 200, 200, (int)(180.0f * Math.max(0.0f, Math.min(1.0f, this.globalAlpha)))));
        }
        if (this.showBindModeMenu) {
            float leftCandidate;
            float itemW = 80.0f;
            float itemH = 15.0f;
            float desiredX = Float.isNaN(this.bindTextX) ? this.x + this.width - 90.0f : this.bindTextX + this.bindTextW + 6.0f;
            float menuX = Math.min(desiredX, this.x + this.width - itemW - 6.0f);
            if (!Float.isNaN(this.bindTextX) && menuX < this.bindTextX && (leftCandidate = this.bindTextX - itemW - 6.0f) >= this.x + 6.0f) {
                menuX = leftCandidate;
            }
            float menuYBase = Float.isNaN(this.bindTextY) ? this.y + 24.0f + 2.0f : this.bindTextY - (itemH * 2.0f + 7.0f) - 4.0f;
            float a = Math.max(0.0f, Math.min(1.0f, this.bindMenuAnimation.getValue()));
            float slideOffset = (1.0f - a) * 6.0f;
            float menuY = menuYBase + slideOffset;
            Color menuBg = new Color(140, 132, 124, (int)(220.0f * a * Math.max(0.0f, Math.min(1.0f, this.globalAlpha))));
            Render2D.drawRoundedRect(context.method_51448(), menuX, menuY, itemW, itemH * 2.0f + 7.0f, 3.0f, menuBg);
            String opt1 = "Toggle";
            String opt2 = "Hold";
            boolean isToggle = this.module.getBind() != null && this.module.getBind().getMode() == Bind.Mode.TOGGLE;
            boolean isHold = this.module.getBind() != null && this.module.getBind().getMode() == Bind.Mode.HOLD;
            int textAlpha = (int)(255.0f * a * Math.max(0.0f, Math.min(1.0f, this.globalAlpha)));
            Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(7.0f), opt1, menuX + 18.0f, menuY + 5.0f, new Color(255, 255, 255, textAlpha));
            Render2D.drawFont(context.method_51448(), Fonts.ICONS.getFont(10.0f), "D", menuX + 6.0f, menuY + 5.5f, new Color(0, 0, 0, (int)((float)(isToggle ? 255 : 0) * a * Math.max(0.0f, Math.min(1.0f, this.globalAlpha)))));
            Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(7.0f), opt2, menuX + 18.0f, menuY + 5.0f + itemH, new Color(255, 255, 255, textAlpha));
            Render2D.drawFont(context.method_51448(), Fonts.ICONS.getFont(10.0f), "D", menuX + 6.0f, menuY + 5.5f + itemH, new Color(0, 0, 0, (int)((float)(isHold ? 255 : 0) * a * Math.max(0.0f, Math.min(1.0f, this.globalAlpha)))));
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        boolean onBindText;
        boolean onHeader = MathUtils.isHovered(this.x, this.y, this.width, 24.0f, (float)mouseX, (float)mouseY);
        boolean bl = onBindText = !Float.isNaN(this.bindTextX) && MathUtils.isHovered(this.bindTextX, this.bindTextY - 1.0f, this.bindTextW, this.bindTextH + 2.0f, (float)mouseX, (float)mouseY);
        if (button == 0 && onBindText && !this.binding && this.module.getBind() != null && !this.module.getBind().isEmpty()) {
            this.showBindModeMenu = !this.showBindModeMenu;
            return;
        }
        if (onHeader) {
            if (button == 0 && !this.binding) {
                this.module.toggle();
                return;
            }
            if (!(button != 1 || this.components.isEmpty() || this.binding || this.renderExternally)) {
                this.open = !this.open;
                return;
            }
            if (button == 2 && !this.binding) {
                this.binding = true;
                return;
            }
        }
        if (this.showBindModeMenu) {
            float menuY;
            float leftCandidate;
            float itemW = 80.0f;
            float itemH = 15.0f;
            float desiredX = Float.isNaN(this.bindTextX) ? this.x + this.width - 90.0f : this.bindTextX + this.bindTextW + 6.0f;
            float menuX = Math.min(desiredX, this.x + this.width - itemW - 6.0f);
            if (!Float.isNaN(this.bindTextX) && menuX < this.bindTextX && (leftCandidate = this.bindTextX - itemW - 6.0f) >= this.x + 6.0f) {
                menuX = leftCandidate;
            }
            float f = menuY = Float.isNaN(this.bindTextY) ? this.y + 24.0f + 2.0f : this.bindTextY - (itemH * 2.0f + 7.0f) - 4.0f;
            if (MathUtils.isHovered(menuX, menuY, itemW, itemH, (float)mouseX, (float)mouseY)) {
                this.module.getBind().setMode(Bind.Mode.TOGGLE);
                this.showBindModeMenu = false;
                return;
            }
            if (MathUtils.isHovered(menuX, menuY + itemH, itemW, itemH, (float)mouseX, (float)mouseY)) {
                this.module.getBind().setMode(Bind.Mode.HOLD);
                this.showBindModeMenu = false;
                return;
            }
            if (!MathUtils.isHovered(menuX, menuY, itemW, itemH * 2.0f + 7.0f, (float)mouseX, (float)mouseY)) {
                this.showBindModeMenu = false;
                return;
            }
            return;
        }
        if (this.open && !this.renderExternally) {
            for (Component component : this.components) {
                component.mouseClicked(mouseX, mouseY, button);
            }
        }
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int button) {
        if (this.showBindModeMenu) {
            return;
        }
        if (this.open && !this.renderExternally) {
            for (Component component : this.components) {
                component.mouseReleased(mouseX, mouseY, button);
            }
        }
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.binding) {
            if (keyCode == 256 || keyCode == 261) {
                this.module.setBind(new Bind(-1, false));
            } else {
                Bind.Mode mode = this.module.getBind() != null ? this.module.getBind().getMode() : Bind.Mode.TOGGLE;
                this.module.setBind(new Bind(keyCode, false, mode));
                System.out.println("New bind for " + this.module.getName() + ": " + keyCode);
            }
            this.binding = false;
            return;
        }
        if (this.open && !this.renderExternally) {
            for (Component component : this.components) {
                component.keyPressed(keyCode, scanCode, modifiers);
            }
        }
    }

    @Override
    public void keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.open && !this.renderExternally) {
            for (Component component : this.components) {
                component.keyReleased(keyCode, scanCode, modifiers);
            }
        }
    }

    @Override
    public void charTyped(char chr, int modifiers) {
        if (this.open && !this.renderExternally) {
            for (Component component : this.components) {
                component.charTyped(chr, modifiers);
            }
        }
    }

    @Override
    public float getHeight() {
        if (this.renderExternally) {
            return 24.0f;
        }
        return 24.0f + (this.open ? this.getChildrenFullHeight() : 0.0f);
    }

    public float getChildrenFullHeight() {
        float h = 0.0f;
        for (Component c : this.components) {
            if (!c.getVisible().get().booleanValue()) continue;
            h += 20.0f + c.getAddHeight().get().floatValue();
        }
        return h;
    }

    private static Color lerpColor(Color c1, Color c2, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        int r = (int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * t);
        int g = (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * t);
        int b = (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * t);
        int a = (int)((float)c1.getAlpha() + (float)(c2.getAlpha() - c1.getAlpha()) * t);
        return new Color(r, g, b, a);
    }

    public Module getModule() {
        return this.module;
    }

    public void setRenderExternally(boolean value) {
        this.renderExternally = value;
    }

    public boolean isRenderExternally() {
        return this.renderExternally;
    }

    public boolean isBindModeMenuOpen() {
        return this.showBindModeMenu;
    }

    public float renderSettingsExternally(class_332 context, float contentX, float contentY, float contentW, float clipX, float clipY, float clipW, float clipH, int mouseX, int mouseY, float delta, float scrollY) {
        float childY = contentY - scrollY;
        float totalHeight = 0.0f;
        context.method_44379((int)clipX, (int)clipY, (int)(clipX + clipW), (int)(clipY + clipH));
        for (Component component : this.components) {
            if (!component.getVisible().get().booleanValue()) continue;
            component.setX(contentX + 5.0f);
            component.setY(childY);
            component.setWidth(contentW - 10.0f);
            component.setHeight(20.0f);
            component.setGlobalAlpha(this.globalAlpha);
            component.render(context, mouseX, mouseY, delta);
            float h = component.getHeight() + component.getAddHeight().get().floatValue();
            childY += h;
            totalHeight += h;
        }
        context.method_44380();
        return totalHeight;
    }

    public void mouseClickedExternal(double mouseX, double mouseY, int button) {
        for (Component component : this.components) {
            component.mouseClicked(mouseX, mouseY, button);
        }
    }

    public void mouseReleasedExternal(double mouseX, double mouseY, int button) {
        for (Component component : this.components) {
            component.mouseReleased(mouseX, mouseY, button);
        }
    }

    public void keyPressedExternal(int keyCode, int scanCode, int modifiers) {
        for (Component component : this.components) {
            component.keyPressed(keyCode, scanCode, modifiers);
        }
    }

    public void keyReleasedExternal(int keyCode, int scanCode, int modifiers) {
        for (Component component : this.components) {
            component.keyReleased(keyCode, scanCode, modifiers);
        }
    }

    public void charTypedExternal(char chr, int modifiers) {
        for (Component component : this.components) {
            component.charTyped(chr, modifiers);
        }
    }

    @Generated
    public List<Component> getComponents() {
        return this.components;
    }

    @Generated
    public Animation getOpenAnimation() {
        return this.openAnimation;
    }
}

