/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.clickgui.components.impl;

import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.clickgui.components.Component;
import dev.phantomvisuals.client.util.ColorUtils;
import dev.phantomvisuals.client.util.math.MathUtils;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.settings.impl.NumberSetting;
import java.awt.Color;
import net.minecraft.class_1074;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class SliderComponent
extends Component {
    private final NumberSetting setting;
    private boolean drag;
    private float animatedPixel = -1.0f;
    private float hoverAmount = 0.0f;

    public SliderComponent(NumberSetting setting) {
        super(setting.getName());
        this.setting = setting;
        this.addHeight = () -> Float.valueOf(3.0f);
        this.visible = setting::isVisible;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        if (!((Boolean)this.visible.get()).booleanValue() || this.getGlobalAlpha() <= 0.01f) {
            return;
        }
        boolean hovered = MathUtils.isHovered(this.x, this.y, this.width, this.height, mouseX, mouseY) || this.drag;
        this.hoverAmount += ((hovered ? 1.0f : 0.0f) - this.hoverAmount) * 0.2f;
        if (this.drag) {
            float value = class_3532.method_15363((float)MathUtils.round(((float)mouseX - this.x - 5.0f) / (this.width - 12.0f) * (this.setting.getMax() - this.setting.getMin()) + this.setting.getMin(), this.setting.getIncrement()), (float)this.setting.getMin(), (float)this.setting.getMax());
            this.setting.setValue(Float.valueOf(value));
        }
        float ratio = (((Float)this.setting.getValue()).floatValue() - this.setting.getMin()) / (this.setting.getMax() - this.setting.getMin());
        ratio = class_3532.method_15363((float)ratio, (float)0.0f, (float)1.0f);
        float barWidth = this.width - 8.0f;
        float targetPixel = barWidth * ratio;
        if (this.animatedPixel < 0.0f) {
            this.animatedPixel = targetPixel;
        }
        this.animatedPixel += (targetPixel - this.animatedPixel) * 0.18f;
        float scaleValue = 1.0f + 0.02f * this.hoverAmount;
        float fadeValue = Math.max(0.0f, Math.min(1.0f, this.getGlobalAlpha()));
        float centerX = this.x + this.width / 2.0f;
        float centerY = this.y + this.height / 2.0f;
        float scaledX = centerX - this.width * scaleValue / 2.0f;
        float scaledY = centerY - this.height * scaleValue / 2.0f;
        float scaledWidth = this.width * scaleValue;
        float scaledHeight = this.height * scaleValue;
        Color baseBg = new Color(40, 40, 40, (int)(100.0f * fadeValue));
        Color hoverBg = new Color(50, 50, 50, (int)(120.0f * fadeValue));
        Color bg = ColorUtils.fade(baseBg, hoverBg, this.hoverAmount);
        Render2D.drawRoundedRect(context.method_51448(), scaledX, scaledY, scaledWidth, scaledHeight, 4.0f, bg);
        int textA = (int)Math.max(0.0f, Math.min(255.0f, 255.0f * fadeValue));
        float textOffset = this.hoverAmount * 1.0f;
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(7.5f), class_1074.method_4662((String)this.setting.getName(), (Object[])new Object[0]), scaledX + 4.0f + textOffset, scaledY + 3.0f, new Color(255, 255, 255, textA));
        Color trackBg = new Color(23, 23, 23, (int)(100.0f * fadeValue));
        Render2D.drawRoundedRect(context.method_51448(), scaledX + 4.0f, scaledY + 13.0f, scaledWidth - 8.0f, 4.0f, 0.5f, trackBg);
        Color accent = ThemeManager.getInstance().getCurrentTheme().getAccentColor();
        int fillA = (int)Math.max(0.0f, Math.min(255.0f, 255.0f * fadeValue));
        Color fillColor = new Color(accent.getRed(), accent.getGreen(), accent.getBlue(), fillA);
        if (this.hoverAmount > 0.0f) {
            fillColor = ColorUtils.fade(fillColor, new Color(accent.getRed(), accent.getGreen(), accent.getBlue(), (int)Math.min(255.0f, (float)fillA * 1.2f)), this.hoverAmount);
        }
        float fillWidth = (scaledWidth - 8.0f) * (this.animatedPixel / barWidth);
        Render2D.drawRoundedRect(context.method_51448(), scaledX + 4.0f, scaledY + 13.0f, fillWidth, 4.0f, 0.5f, fillColor);
        float knobSize = (6.0f + 2.0f * this.hoverAmount) * scaleValue;
        float knobX = scaledX + 1.0f + this.animatedPixel / barWidth * (scaledWidth - 8.0f) - (knobSize - 6.0f) / 2.0f;
        float knobY = scaledY + 12.0f - (knobSize - 6.0f) / 2.0f;
        int knobA = (int)Math.max(0.0f, Math.min(255.0f, 255.0f * fadeValue));
        Color knobColor = new Color(255, 255, 255, knobA);
        if (this.hoverAmount > 0.0f) {
            knobColor = ColorUtils.fade(knobColor, new Color(255, 255, 255, (int)Math.min(255.0f, (float)knobA * 1.1f)), this.hoverAmount);
        }
        Render2D.drawRoundedRect(context.method_51448(), knobX, knobY, knobSize, knobSize, knobSize / 2.0f, knobColor);
        int outlineA = (int)(120.0f * fadeValue * this.hoverAmount);
        if (outlineA > 0) {
            Color outlineColor = new Color(accent.getRed(), accent.getGreen(), accent.getBlue(), outlineA);
            Render2D.drawRoundedRect(context.method_51448(), knobX - 0.5f, knobY - 0.5f, knobSize + 1.0f, knobSize + 1.0f, knobSize / 2.0f + 0.5f, outlineColor);
        }
        Color baseText = ThemeManager.getInstance().getCurrentTheme().getTextColor();
        Color textWithAlpha = new Color(baseText.getRed(), baseText.getGreen(), baseText.getBlue(), Math.max(0, Math.min(255, (int)((float)baseText.getAlpha() * fadeValue))));
        String valueStr = String.valueOf(this.setting.getValue());
        float valueOffset = this.hoverAmount * 1.0f;
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(6.0f), valueStr, scaledX + scaledWidth - Fonts.BOLD.getWidth(valueStr, 6.5f) - 4.5f + valueOffset, scaledY + 5.0f, textWithAlpha);
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && MathUtils.isHovered(this.x + 4.0f, this.y + 12.0f, this.width - 8.0f, 6.0f, (float)mouseX, (float)mouseY)) {
            this.drag = true;
        }
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.drag = false;
        }
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
    }

    @Override
    public void keyReleased(int keyCode, int scanCode, int modifiers) {
    }

    @Override
    public void charTyped(char chr, int modifiers) {
    }
}

