/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.clickgui.components.impl;

import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.clickgui.components.Component;
import dev.phantomvisuals.client.util.ColorUtils;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.math.MathUtils;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.settings.impl.StringSetting;
import java.awt.Color;
import net.minecraft.class_1074;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public class StringComponent
extends Component {
    private final StringSetting setting;
    private boolean typing;
    private boolean selected;
    private final Animation animation = new Animation(300L, 1.0, false, Easing.BOTH_SINE);
    private float scrollOffset = 0.0f;

    public StringComponent(StringSetting setting) {
        super(setting.getName());
        this.setting = setting;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        this.animation.update(this.typing);
        float textX = this.x + 7.5f;
        float textY = this.y + 2.5f;
        float maxTextWidth = this.width - 16.0f;
        float textWidth = Fonts.REGULAR.getWidth(class_1074.method_4662((String)((String)this.setting.getValue()), (Object[])new Object[0]), 8.0f);
        if (textWidth > maxTextWidth) {
            if (textWidth - this.scrollOffset > maxTextWidth) {
                this.scrollOffset = textWidth - maxTextWidth;
            }
            if (textWidth - this.scrollOffset < 0.0f) {
                this.scrollOffset = textWidth;
            }
        } else {
            this.scrollOffset = 0.0f;
        }
        Render2D.drawRoundedRect(context.method_51448(), this.x + 4.0f, this.y, this.width - 8.0f, this.height, 1.5f, ColorUtils.getGlobalColor());
        Render2D.startScissor(context, this.x + 4.0f, this.y, this.width - 8.0f, this.height);
        if (this.selected) {
            Render2D.drawRoundedRect(context.method_51448(), textX, textY, Fonts.REGULAR.getWidth(class_1074.method_4662((String)((String)this.setting.getValue()), (Object[])new Object[0]), 8.0f), Fonts.REGULAR.getHeight(8.0f), 0.0f, new Color(ThemeManager.getInstance().getCurrentTheme().getAccentColor().getRed(), ThemeManager.getInstance().getCurrentTheme().getAccentColor().getGreen(), ThemeManager.getInstance().getCurrentTheme().getAccentColor().getBlue(), 150));
        }
        Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(8.0f), this.setting.getName(), textX, textY, new Color(255, 255, 255, (int)(255.0f * this.animation.getReversedValue())));
        if (!((String)this.setting.getValue()).isEmpty()) {
            Render2D.drawFont(context.method_51448(), Fonts.BOLD.getFont(8.0f), class_1074.method_4662((String)((String)this.setting.getValue()), (Object[])new Object[0]), textX - this.scrollOffset, textY, new Color(255, 255, 255, (int)(255.0f * this.animation.getValue())));
        }
        Render2D.drawFont(context.method_51448(), Fonts.REGULAR.getFont(8.0f), "|", textX - this.scrollOffset + textWidth, textY - 0.25f, ColorUtils.alpha(ColorUtils.pulse(Color.WHITE, 15L), (int)((float)ColorUtils.pulse(Color.WHITE, 15L).getAlpha() * this.animation.getValue())));
        Render2D.stopScissor(context);
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        this.typing = MathUtils.isHovered(this.x, this.y, this.width, this.height, (float)mouseX, (float)mouseY) && button == 0 ? !this.typing : false;
        this.selected = false;
    }

    @Override
    public void mouseReleased(double mouseX, double mouseY, int button) {
    }

    @Override
    public void keyPressed(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 259: {
                if (this.selected) {
                    this.setting.setValue("");
                    this.selected = false;
                }
                if (!this.typing || this.setting.getValue() == null || ((String)this.setting.getValue()).isEmpty()) break;
                this.setting.setValue(((String)this.setting.getValue()).substring(0, ((String)this.setting.getValue()).length() - 1));
                break;
            }
            case 256: 
            case 257: {
                if (!this.typing) break;
                this.typing = false;
                this.selected = false;
                break;
            }
            case 261: {
                if (!this.typing) break;
                this.setting.setValue("");
                this.selected = false;
                break;
            }
            case 67: {
                if (!class_437.method_25441() || !this.typing || !this.selected || this.setting.getValue() == null || ((String)this.setting.getValue()).isEmpty()) break;
                GLFW.glfwSetClipboardString((long)mc.method_22683().method_4490(), (CharSequence)((CharSequence)this.setting.getValue()));
                this.selected = false;
                break;
            }
            case 86: {
                if (!class_437.method_25441() || !this.typing || GLFW.glfwGetClipboardString((long)mc.method_22683().method_4490()) == null) break;
                this.selected = false;
                this.setting.setValue((String)this.setting.getValue() + GLFW.glfwGetClipboardString((long)mc.method_22683().method_4490()));
                break;
            }
            case 65: {
                if (!class_437.method_25441() || !this.typing || this.setting.getValue() == null || ((String)this.setting.getValue()).isEmpty()) break;
                this.selected = true;
            }
        }
    }

    @Override
    public void keyReleased(int keyCode, int scanCode, int modifiers) {
    }

    @Override
    public void charTyped(char chr, int modifiers) {
        if (!this.typing) {
            return;
        }
        if (this.setting.isOnlyDigit() && !Character.isDigit(chr)) {
            return;
        }
        this.setting.setValue((String)this.setting.getValue() + chr);
        this.selected = false;
    }
}

