/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.colorgui;

import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.settings.impl.ColorSetting;
import java.awt.Color;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ColorPickerScreen
extends class_437 {
    private final ColorSetting setting;
    private float hue;
    private float saturation;
    private float brightness;
    private boolean draggingSquare = false;
    private boolean draggingHue = false;
    private final int squareSize = 150;
    private final int hueWidth = 15;
    private int[] squarePixels;

    public ColorPickerScreen(ColorSetting setting) {
        super(class_2561.method_30163((String)"Color Picker"));
        this.setting = setting;
        Color color = new Color(setting.getValue());
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        this.generateSquareBuffer();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        Render2D.drawStyledRect(context.method_51448(), centerX - 150 - 15 - 20, centerY - 75 - 20, 205.0f, 210.0f, 5.0f, new Color(0, 0, 0, 180), 255);
        Render2D.drawFont(context.method_51448(), Fonts.SEMIBOLD.getFont(12.0f), "Color Picker", centerX - 30, centerY - 75 - 10, Color.WHITE);
        this.drawColorSquare(context, centerX - 75 - 20, centerY - 75);
        this.drawHueBar(context, centerX + 75, centerY - 75, 15, 150);
        Color preview = Color.getHSBColor(this.hue, this.saturation, this.brightness);
        Render2D.drawStyledRect(context.method_51448(), centerX - 30, centerY + 75 + 10, 60.0f, 20.0f, 3.0f, preview, 255);
        Render2D.drawStyledRect(context.method_51448(), centerX - 30, centerY + 75 + 40, 60.0f, 16.0f, 3.0f, new Color(100, 20, 20, 180), 255);
        Render2D.drawFont(context.method_51448(), Fonts.MEDIUM.getFont(9.0f), "Close", centerX - 15, centerY + 75 + 43, Color.WHITE);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void generateSquareBuffer() {
        this.squarePixels = new int[22500];
        for (int i = 0; i < 150; ++i) {
            for (int j = 0; j < 150; ++j) {
                float sat = (float)i / 150.0f;
                float bri = 1.0f - (float)j / 150.0f;
                this.squarePixels[j * 150 + i] = Color.getHSBColor(this.hue, sat, bri).getRGB();
            }
        }
    }

    private void drawColorSquare(class_332 context, int x, int y) {
        int step = 2;
        for (int i = 0; i < 150; i += step) {
            for (int j = 0; j < 150; j += step) {
                int rgb = this.squarePixels[j * 150 + i];
                Render2D.drawRect(context.method_51448(), x + i, y + j, step, step, new Color(rgb));
            }
        }
        int markerX = x + (int)(this.saturation * 150.0f);
        int markerY = y + (int)((1.0f - this.brightness) * 150.0f);
        Render2D.drawStyledRect(context.method_51448(), markerX - 3, markerY - 3, 6.0f, 6.0f, 2.0f, Color.WHITE, 255);
        Color current = Color.getHSBColor(this.hue, this.saturation, this.brightness);
        Render2D.drawStyledRect(context.method_51448(), markerX + 8, markerY - 3, 10.0f, 10.0f, 2.0f, current, 255);
    }

    private void drawHueBar(class_332 context, int x, int y, int w, int h) {
        for (int j = 0; j < h; ++j) {
            float hueVal = (float)j / (float)h;
            Color c = Color.getHSBColor(hueVal, 1.0f, 1.0f);
            Render2D.drawRect(context.method_51448(), x, y + j, w, 1.0f, c);
        }
        int markerY = y + (int)(this.hue * (float)h);
        Render2D.drawStyledRect(context.method_51448(), x - 2, markerY - 2, w + 4, 4.0f, 2.0f, Color.BLACK, 255);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int squareX = centerX - 75 - 20;
        int squareY = centerY - 75;
        int hueX = centerX + 75;
        int hueY = centerY - 75;
        if (this.isHovered(mouseX, mouseY, centerX - 30, centerY + 75 + 40, 60.0, 16.0)) {
            this.method_25419();
            return true;
        }
        if (this.isHovered(mouseX, mouseY, squareX, squareY, 150.0, 150.0)) {
            this.draggingSquare = true;
            this.updateSquare(mouseX, mouseY, squareX, squareY, 150, 150);
            return true;
        }
        if (this.isHovered(mouseX, mouseY, hueX, hueY, 15.0, 150.0)) {
            this.draggingHue = true;
            this.updateHue(mouseY, hueY, 150);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingSquare = false;
        this.draggingHue = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int squareX = centerX - 75 - 20;
        int squareY = centerY - 75;
        int hueY = centerY - 75;
        if (this.draggingSquare) {
            this.updateSquare(mouseX, mouseY, squareX, squareY, 150, 150);
            return true;
        }
        if (this.draggingHue) {
            this.updateHue(mouseY, hueY, 150);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dx, dy);
    }

    private void updateSquare(double mouseX, double mouseY, int x, int y, int w, int h) {
        float sat = (float)(mouseX - (double)x) / (float)w;
        float bri = 1.0f - (float)(mouseY - (double)y) / (float)h;
        this.saturation = Math.max(0.0f, Math.min(1.0f, sat));
        this.brightness = Math.max(0.0f, Math.min(1.0f, bri));
        this.updateColor();
    }

    private void updateHue(double mouseY, int y, int h) {
        float value = (float)(mouseY - (double)y) / (float)h;
        this.hue = Math.max(0.0f, Math.min(1.0f, value));
        this.generateSquareBuffer();
        this.updateColor();
    }

    private void updateColor() {
        int rgb = Color.getHSBColor(this.hue, this.saturation, this.brightness).getRGB();
        this.setting.set(rgb);
    }

    private boolean isHovered(double mouseX, double mouseY, double x, double y, double w, double h) {
        return mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h;
    }

    public void method_25419() {
        this.field_22787.method_1507(null);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25421() {
        return false;
    }
}

