/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud;

import dev.phantomvisuals.client.events.impl.EventMouse;
import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.managers.AutoSaveManager;
import dev.phantomvisuals.client.ui.hud.windows.Window;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.math.MathUtils;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.api.Category;
import dev.phantomvisuals.modules.api.Module;
import dev.phantomvisuals.modules.settings.Setting;
import dev.phantomvisuals.modules.settings.api.Position;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.PositionSetting;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1074;
import net.minecraft.class_408;

public abstract class HudElement
extends Module {
    private final PositionSetting position = new PositionSetting("setting.position", new Position(0.0f, 0.0f));
    private final Animation hoverAnimation = new Animation(300L, 1.0, false, Easing.SMOOTH_STEP);
    private final Animation cornerAnimation = new Animation(200L, 1.0, false, Easing.OUT_QUART);
    protected final Animation toggledAnimation = new Animation(300L, 1.0, false, Easing.BOTH_SINE);
    private float dragX;
    private float dragY;
    private float width;
    private float height;
    private boolean dragging;
    private boolean button;
    private final List<Setting<?>> settings = new ArrayList();
    private Window window;

    public HudElement(String name) {
        super(name, Category.Utility);
        this.settings.add(this.position);
        this.setToggled(true);
    }

    @EventHandler
    public void onRender2D(EventRender2D e) {
        if (HudElement.fullNullCheck()) {
            return;
        }
        this.hoverAnimation.update(MathUtils.isHovered(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.mouseX(), this.mouseY()) && this.window == null || this.button || this.dragging);
        this.cornerAnimation.update(this.hoverAnimation.getValue() > 0.0f);
        if (this.button) {
            HudElement current = phantomvisuals.getInstance().getHudManager().getCurrentDragging();
            if (current != null && current != this) {
                this.dragging = false;
                return;
            }
            if (!(HudElement.mc.field_1755 instanceof class_408)) {
                this.dragging = false;
                this.button = false;
                phantomvisuals.getInstance().getHudManager().setCurrentDragging(null);
                return;
            }
            if (!this.dragging && MathUtils.isHovered(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.mouseX(), this.mouseY())) {
                this.dragX = (float)this.mouseX() - this.getX();
                this.dragY = (float)this.mouseY() - this.getY();
                this.dragging = true;
                phantomvisuals.getInstance().getHudManager().setCurrentDragging(this);
            }
            if (this.dragging) {
                float sw = mc.method_22683().method_4486();
                float sh = mc.method_22683().method_4502();
                float finalX = Math.min(Math.max((float)this.mouseX() - this.dragX, 0.0f), sw - this.width);
                float finalY = Math.min(Math.max((float)this.mouseY() - this.dragY, 0.0f), sh - this.height);
                float threshold = 6.0f;
                float edgePad = 4.0f;
                float centerX = sw / 2.0f - this.width / 2.0f;
                if (Math.abs(finalX + this.width / 2.0f - sw / 2.0f) <= threshold) {
                    finalX = centerX;
                } else {
                    float leftX = edgePad;
                    float rightX = sw - edgePad - this.width;
                    if (Math.abs(finalX - leftX) <= threshold) {
                        finalX = leftX;
                    } else if (Math.abs(finalX - rightX) <= threshold) {
                        finalX = rightX;
                    }
                }
                float centerY = sh / 2.0f - this.height / 2.0f;
                if (Math.abs(finalY + this.height / 2.0f - sh / 2.0f) <= threshold) {
                    finalY = centerY;
                } else {
                    float topY = edgePad;
                    float bottomY = sh - edgePad - this.height;
                    if (Math.abs(finalY - topY) <= threshold) {
                        finalY = topY;
                    } else if (Math.abs(finalY - bottomY) <= threshold) {
                        finalY = bottomY;
                    }
                }
                float newX = finalX / sw;
                float newY = finalY / sh;
                if (Math.abs(((Position)this.position.getValue()).getX() - newX) > 0.001f || Math.abs(((Position)this.position.getValue()).getY() - newY) > 0.001f) {
                    ((Position)this.position.getValue()).setX(newX);
                    ((Position)this.position.getValue()).setY(newY);
                    try {
                        AutoSaveManager asm = phantomvisuals.getInstance().getAutoSaveManager();
                        if (asm != null) {
                            asm.scheduleAutoSave();
                        }
                    }
                    catch (Throwable asm) {}
                }
            }
        } else {
            this.dragging = false;
        }
        if (HudElement.mc.field_1755 instanceof class_408 && this.cornerAnimation.getValue() > 0.0f) {
            float animationValue = this.cornerAnimation.getValue();
            float animatedCornerSize = 16.0f * animationValue;
            int alpha = (int)(255.0f * animationValue);
            float padding = 4.0f;
            float cornerX = this.getX() - padding;
            float cornerY = this.getY() - padding;
            float cornerWidth = this.getWidth() + padding * 2.0f;
            float cornerHeight = this.getHeight() + padding * 2.0f;
            Render2D.drawRoundedCorner(e.getContext().method_51448(), cornerX, cornerY, cornerWidth, cornerHeight, animatedCornerSize, new Color(255, 255, 255, alpha));
        }
        if (HudElement.mc.field_1755 instanceof class_408 && this.dragging) {
            float sw = mc.method_22683().method_4486();
            float sh = mc.method_22683().method_4502();
            float edgePad = 4.0f;
            Color guide = new Color(255, 255, 255, 110);
            Render2D.drawRoundedRect(e.getContext().method_51448(), sw / 2.0f - 0.5f, 0.0f, 1.0f, sh, 0.0f, guide);
            Render2D.drawRoundedRect(e.getContext().method_51448(), 0.0f, sh / 2.0f - 0.5f, sw, 1.0f, 0.0f, guide);
            float leftX = edgePad;
            float rightX = sw - edgePad;
            float elemCenterX = this.getX() + this.getWidth() / 2.0f;
            float sideX = Math.abs(elemCenterX - leftX) < Math.abs(elemCenterX - rightX) ? leftX : rightX;
            Render2D.drawRoundedRect(e.getContext().method_51448(), sideX - 0.5f, 0.0f, 1.0f, sh, 0.0f, new Color(255, 255, 255, 80));
            float topY = edgePad;
            float bottomY = sh - edgePad;
            float elemCenterY = this.getY() + this.getHeight() / 2.0f;
            float sideY = Math.abs(elemCenterY - topY) < Math.abs(elemCenterY - bottomY) ? topY : bottomY;
            Render2D.drawRoundedRect(e.getContext().method_51448(), 0.0f, sideY - 0.5f, sw, 1.0f, 0.0f, new Color(255, 255, 255, 80));
        }
        if (this.window != null) {
            if (!(HudElement.mc.field_1755 instanceof class_408)) {
                this.window.reset();
            }
            if (this.window.closed()) {
                this.window = null;
                return;
            }
            this.window.render(e.getContext(), this.mouseX(), this.mouseY());
        }
        if (HudElement.mc.field_1755 instanceof class_408) {
            String text = class_1074.method_4662((String)"", (Object[])new Object[0]);
            int textWidth = HudElement.mc.field_1772.method_1727(text);
            int x = 10;
            int y = mc.method_22683().method_4502() - 30;
            Render2D.drawFont(e.getContext().method_51448(), Fonts.REGULAR.getFont(9.0f), text, x, y, new Color(255, 255, 255));
        }
    }

    @EventHandler
    public void onRender2DX2(EventRender2D e) {
        if (HudElement.fullNullCheck()) {
            return;
        }
        BooleanSetting setting = phantomvisuals.getInstance().getHudManager().getElements().getName(this.getName());
        if (setting != null && setting instanceof BooleanSetting) {
            this.toggledAnimation.update((Boolean)setting.getValue());
        } else {
            this.toggledAnimation.update(this.isToggled());
        }
    }

    @EventHandler
    public void onMouse(EventMouse e) {
        if (!(HudElement.mc.field_1755 instanceof class_408) || HudElement.fullNullCheck()) {
            return;
        }
        if (e.getAction() == 0) {
            this.button = false;
            this.dragging = false;
            phantomvisuals.getInstance().getHudManager().setCurrentDragging(null);
            try {
                AutoSaveManager asm = phantomvisuals.getInstance().getAutoSaveManager();
                if (asm != null) {
                    asm.scheduleAutoSave();
                }
            }
            catch (Throwable throwable) {}
        } else if (e.getAction() == 1) {
            if (phantomvisuals.getInstance().getHudManager().getCurrentDragging() == null || phantomvisuals.getInstance().getHudManager().getCurrentDragging() == this) {
                this.button = true;
            }
            if (this.window != null) {
                if (MathUtils.isHovered(this.window.getX(), this.window.getY(), this.window.getWidth(), this.window.getFinalHeight(), this.mouseX(), this.mouseY())) {
                    this.window.mouseClicked(this.mouseX(), this.mouseY(), e.getButton());
                    return;
                }
                this.window.reset();
            }
            if (e.getButton() == 1 && MathUtils.isHovered(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.mouseX(), this.mouseY()) && this.settings.size() != 1) {
                if (phantomvisuals.getInstance().getHudManager().getWindow() != null) {
                    phantomvisuals.getInstance().getHudManager().getWindow().reset();
                }
                for (HudElement element : phantomvisuals.getInstance().getHudManager().getHudElements()) {
                    if (element.getWindow() == null) continue;
                    element.getWindow().reset();
                }
                this.window = new Window(this.mouseX() + 3, this.mouseY() + 3, 100.0f, 12.5f, this.settings);
            }
        }
    }

    public float getX() {
        return (float)mc.method_22683().method_4486() * ((Position)this.position.getValue()).getX();
    }

    public float getY() {
        return (float)mc.method_22683().method_4502() * ((Position)this.position.getValue()).getY();
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public int mouseX() {
        return (int)(HudElement.mc.field_1729.method_1603() / mc.method_22683().method_4495());
    }

    public int mouseY() {
        return (int)(HudElement.mc.field_1729.method_1604() / mc.method_22683().method_4495());
    }

    public void setBounds(float x, float y, float width, float height) {
        this.width = width;
        this.height = height;
        ((Position)this.position.getValue()).setX(x / (float)mc.method_22683().method_4486());
        ((Position)this.position.getValue()).setY(y / (float)mc.method_22683().method_4502());
        try {
            AutoSaveManager asm = phantomvisuals.getInstance().getAutoSaveManager();
            if (asm != null) {
                asm.scheduleAutoSave();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean closed() {
        return this.toggledAnimation.getValue() <= 0.0f;
    }

    protected void onDragging(EventRender2D e) {
        if (this.dragging) {
            float padding = 4.0f;
            float cornerX = this.getX() - padding;
            float cornerY = this.getY() - padding;
            float cornerWidth = this.getWidth() + padding * 2.0f;
            float cornerHeight = this.getHeight() + padding * 2.0f;
            Render2D.drawRoundedCorner(e.getContext().method_51448(), cornerX, cornerY, cornerWidth, cornerHeight, 16.0f, new Color(255, 255, 255, (int)(255.0f * this.hoverAnimation.getValue())), 2.0f);
        }
    }

    @Override
    public void onEnable() {
        super.onEnable();
    }

    @Override
    public void onDisable() {
        super.onDisable();
    }

    @Generated
    public PositionSetting getPosition() {
        return this.position;
    }

    @Generated
    public Animation getHoverAnimation() {
        return this.hoverAnimation;
    }

    @Generated
    public Animation getCornerAnimation() {
        return this.cornerAnimation;
    }

    @Generated
    public Animation getToggledAnimation() {
        return this.toggledAnimation;
    }

    @Generated
    public float getDragX() {
        return this.dragX;
    }

    @Generated
    public float getDragY() {
        return this.dragY;
    }

    @Generated
    public boolean isDragging() {
        return this.dragging;
    }

    @Generated
    public boolean isButton() {
        return this.button;
    }

    @Override
    @Generated
    public List<Setting<?>> getSettings() {
        return this.settings;
    }

    @Generated
    public Window getWindow() {
        return this.window;
    }

    @Generated
    public void setDragX(float dragX) {
        this.dragX = dragX;
    }

    @Generated
    public void setDragY(float dragY) {
        this.dragY = dragY;
    }

    @Generated
    public void setWidth(float width) {
        this.width = width;
    }

    @Generated
    public void setHeight(float height) {
        this.height = height;
    }

    @Generated
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Generated
    public void setButton(boolean button) {
        this.button = button;
    }

    @Generated
    public void setWindow(Window window) {
        this.window = window;
    }
}

