/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.impl;

import dev.phantomvisuals.client.events.impl.EventMouse;
import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.animations.infinity.InfinityAnimation;
import dev.phantomvisuals.client.util.perf.Perf;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_408;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class ArmorHUD
extends HudElement
implements ThemeManager.ThemeChangeListener {
    private final InfinityAnimation fadeAnimation = new InfinityAnimation(Easing.BOTH_SINE);
    private final ThemeManager themeManager;
    private Color bgColor;
    private Color textColor;
    private Color lowDurabilityColor;
    private Color headerTextColor;
    private final Map<Integer, InfinityAnimation> slotAlpha = new HashMap<Integer, InfinityAnimation>();
    private final Map<Integer, class_1799> lastSlotItem = new HashMap<Integer, class_1799>();
    private final ListSetting layoutModes = new ListSetting("setting.layout", new BooleanSetting("setting.horizontal", true), new BooleanSetting("setting.vertical", false));

    public ArmorHUD() {
        super("ArmorHUD");
        this.themeManager = ThemeManager.getInstance();
        this.applyTheme(this.themeManager.getCurrentTheme());
        this.themeManager.addThemeChangeListener(this);
        for (int i = 0; i < 4; ++i) {
            this.slotAlpha.put(i, new InfinityAnimation(Easing.OUT_QUAD));
            this.lastSlotItem.put(i, class_1799.field_8037);
        }
        this.layoutModes.setSingleSelect(true);
        this.getSettings().add(this.layoutModes);
    }

    @Override
    public void onDisable() {
        this.themeManager.removeThemeChangeListener(this);
        super.onDisable();
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
        this.applyTheme(theme);
    }

    private void applyTheme(ThemeManager.Theme theme) {
        this.bgColor = new Color(20, 20, 20, 245);
        int brightness = (int)(0.299 * (double)this.bgColor.getRed() + 0.587 * (double)this.bgColor.getGreen() + 0.114 * (double)this.bgColor.getBlue());
        this.textColor = brightness > 200 && this.bgColor.getAlpha() <= 150 ? new Color(0, 0, 0, 255) : Color.WHITE;
        this.headerTextColor = this.textColor;
        this.lowDurabilityColor = new Color(200, 80, 80, 220);
    }

    @Override
    public void onRender2D(EventRender2D e) {
        if (ArmorHUD.fullNullCheck() || this.closed()) {
            return;
        }
        Perf.tryBeginFrame();
        try (Perf.CpuScope __ = Perf.scopeCpu("ArmorHUD.onRender2D");){
            boolean drawVertical;
            boolean previewMode;
            class_746 player = ArmorHUD.mc.field_1724;
            if (player == null) {
                return;
            }
            ArrayList<class_1799> armorItems = new ArrayList<class_1799>();
            class_2371 armorSlots = player.method_31548().field_7548;
            for (int i = armorSlots.size() - 1; i >= 0; --i) {
                class_1799 stack = (class_1799)armorSlots.get(i);
                armorItems.add(stack.method_7960() ? class_1799.field_8037 : stack);
            }
            boolean chatOpen = ArmorHUD.mc.field_1755 instanceof class_408;
            boolean allEmpty = armorItems.stream().allMatch(class_1799::method_7960);
            boolean bl = previewMode = chatOpen && allEmpty;
            if (chatOpen) {
                this.fadeAnimation.animate(1.0f, 160L);
                previewMode = true;
            } else if (allEmpty && !previewMode) {
                this.fadeAnimation.animate(0.0f, 160L);
                if (this.fadeAnimation.getValue() <= 0.0f) {
                    return;
                }
            } else {
                this.fadeAnimation.animate(1.0f, 160L);
            }
            for (int i = 0; i < 4; ++i) {
                boolean present;
                class_1799 presentStack = i < armorItems.size() ? (class_1799)armorItems.get(i) : class_1799.field_8037;
                boolean bl2 = present = previewMode || !presentStack.method_7960();
                if (!presentStack.method_7960()) {
                    this.lastSlotItem.put(i, presentStack);
                }
                this.slotAlpha.get(i).animate(present ? 1.0f : 0.0f, 150L);
            }
            float posX = this.getX();
            float posY = this.getY();
            float iconSize = 18.0f;
            float padding = 3.0f;
            float fontSize = 6.0f;
            int alpha = (int)(200.0f * this.fadeAnimation.getValue());
            float totalWidth = 0.0f;
            float totalHeight = 0.0f;
            e.getContext().method_51448().method_22903();
            float cursorY = posY;
            float cursorX = posX;
            boolean drawHorizontal = this.layoutModes.getName("setting.horizontal") != null && (Boolean)this.layoutModes.getName("setting.horizontal").getValue() != false;
            boolean bl3 = drawVertical = this.layoutModes.getName("setting.vertical") != null && (Boolean)this.layoutModes.getName("setting.vertical").getValue() != false;
            if (!drawHorizontal && !drawVertical) {
                drawHorizontal = true;
            }
            boolean rightAnchored = this.getX() > (float)mc.method_22683().method_4486() / 2.0f;
            float sideGap = 3.0f;
            if (drawHorizontal) {
                float widthH = 0.0f;
                float textHeight = Fonts.MEDIUM.getHeight(fontSize);
                float heightH = iconSize + textHeight + sideGap;
                for (int i = 0; i < 4; ++i) {
                    class_1799 renderStack;
                    boolean presentNow;
                    boolean bl4 = presentNow = previewMode || i < armorItems.size() && !((class_1799)armorItems.get(i)).method_7960();
                    class_1799 class_17992 = previewMode ? new class_1799((class_1935)(i == 0 ? class_1802.field_8805 : (i == 1 ? class_1802.field_8058 : (i == 2 ? class_1802.field_8348 : class_1802.field_8285)))) : (renderStack = i < armorItems.size() ? (class_1799)armorItems.get(i) : class_1799.field_8037);
                    if (renderStack.method_7960()) {
                        renderStack = this.lastSlotItem.getOrDefault(i, class_1799.field_8037);
                    }
                    float xOffset = cursorX + widthH;
                    float a = this.slotAlpha.get(i).getValue();
                    if (a <= 0.01f) {
                        if (!presentNow) {
                            this.lastSlotItem.put(i, class_1799.field_8037);
                        }
                        widthH += iconSize + padding;
                        continue;
                    }
                    int itemAlpha = (int)(255.0f * a);
                    float appearYOffset = (1.0f - a) * 4.0f;
                    if (!renderStack.method_7960()) {
                        Render2D.drawRoundedRect(e.getContext().method_51448(), xOffset - 1.0f, cursorY - 1.0f + appearYOffset, iconSize + 2.0f, iconSize + 2.0f, 4.0f, new Color(30, 30, 30, (int)(240.0f * a)));
                        String durabilityText = renderStack.method_7960() ? "0%" : (int)((float)(renderStack.method_7936() - renderStack.method_7919()) / (float)renderStack.method_7936() * 100.0f) + "%";
                        float textW = Fonts.MEDIUM.getWidth(durabilityText, fontSize);
                        float textX = xOffset + iconSize / 2.0f - textW / 2.0f;
                        float textY = cursorY - textHeight - 1.0f + appearYOffset;
                        Render2D.drawFont(e.getContext().method_51448(), Fonts.MEDIUM.getFont(fontSize), durabilityText, textX, textY, new Color(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue(), itemAlpha));
                        String itemId = class_7923.field_41178.method_10221((Object)renderStack.method_7909()).method_12832();
                        class_2960 texture = class_2960.method_60655((String)"minecraft", (String)("textures/item/" + itemId + ".png"));
                        try {
                            Render2D.drawTexture(e.getContext().method_51448(), xOffset, cursorY + appearYOffset, iconSize, iconSize, 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, texture, new Color(255, 255, 255, itemAlpha));
                        }
                        catch (Exception ex) {
                            Render2D.drawFont(e.getContext().method_51448(), Fonts.MEDIUM.getFont(fontSize), "[No Icon]", xOffset, cursorY + appearYOffset, new Color(255, 50, 50, itemAlpha));
                        }
                    }
                    if (!presentNow && a <= 0.02f) {
                        this.lastSlotItem.put(i, class_1799.field_8037);
                    }
                    widthH += iconSize + padding;
                }
                totalWidth = Math.max(totalWidth, widthH - padding);
                totalHeight += heightH + padding;
                cursorY += heightH + padding;
            }
            if (drawVertical) {
                float widthV = iconSize;
                float heightV = 0.0f;
                for (int i = 0; i < 4; ++i) {
                    class_1799 renderStack;
                    boolean presentNow;
                    boolean bl5 = presentNow = previewMode || i < armorItems.size() && !((class_1799)armorItems.get(i)).method_7960();
                    class_1799 class_17993 = previewMode ? new class_1799((class_1935)(i == 0 ? class_1802.field_8805 : (i == 1 ? class_1802.field_8058 : (i == 2 ? class_1802.field_8348 : class_1802.field_8285)))) : (renderStack = i < armorItems.size() ? (class_1799)armorItems.get(i) : class_1799.field_8037);
                    if (renderStack.method_7960()) {
                        renderStack = this.lastSlotItem.getOrDefault(i, class_1799.field_8037);
                    }
                    float yOffset = cursorY + heightV;
                    float a = this.slotAlpha.get(i).getValue();
                    if (a <= 0.01f) {
                        if (!presentNow) {
                            this.lastSlotItem.put(i, class_1799.field_8037);
                        }
                        heightV += iconSize + padding;
                        continue;
                    }
                    int itemAlpha = (int)(255.0f * a);
                    float appearXOffset = (1.0f - a) * (rightAnchored ? -4.0f : 4.0f);
                    if (!renderStack.method_7960()) {
                        Render2D.drawRoundedRect(e.getContext().method_51448(), cursorX - 1.0f + appearXOffset, yOffset - 1.0f, iconSize + 2.0f, iconSize + 2.0f, 4.0f, new Color(30, 30, 30, (int)(240.0f * a)));
                        String durabilityText = renderStack.method_7960() ? "0%" : (int)((float)(renderStack.method_7936() - renderStack.method_7919()) / (float)renderStack.method_7936() * 100.0f) + "%";
                        float textW = Fonts.MEDIUM.getWidth(durabilityText, fontSize);
                        float textX = rightAnchored ? cursorX - sideGap - textW : cursorX + iconSize + sideGap;
                        float textY = yOffset + iconSize / 2.0f - Fonts.MEDIUM.getHeight(fontSize) / 2.0f;
                        Render2D.drawFont(e.getContext().method_51448(), Fonts.MEDIUM.getFont(fontSize), durabilityText, textX + appearXOffset, textY, new Color(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue(), itemAlpha));
                        String itemId = class_7923.field_41178.method_10221((Object)renderStack.method_7909()).method_12832();
                        class_2960 texture = class_2960.method_60655((String)"minecraft", (String)("textures/item/" + itemId + ".png"));
                        try {
                            Render2D.drawTexture(e.getContext().method_51448(), cursorX + appearXOffset, yOffset, iconSize, iconSize, 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, texture, new Color(255, 255, 255, itemAlpha));
                        }
                        catch (Exception ex) {
                            Render2D.drawFont(e.getContext().method_51448(), Fonts.MEDIUM.getFont(fontSize), "[No Icon]", cursorX + appearXOffset, yOffset, new Color(255, 50, 50, itemAlpha));
                        }
                    }
                    if (!presentNow && a <= 0.02f) {
                        this.lastSlotItem.put(i, class_1799.field_8037);
                    }
                    heightV += iconSize + padding;
                }
                totalWidth = Math.max(totalWidth, widthV);
                totalHeight += heightV - padding;
            }
            e.getContext().method_51448().method_22909();
            if (totalWidth <= 0.0f) {
                totalWidth = iconSize * 4.0f + padding * 3.0f;
            }
            if (totalHeight <= 0.0f) {
                totalHeight = iconSize;
            }
            this.setBounds(posX, posY, totalWidth, totalHeight);
            super.onRender2D(e);
        }
    }

    @Override
    public void onMouse(EventMouse e) {
        if (!(ArmorHUD.mc.field_1755 instanceof class_408) || ArmorHUD.fullNullCheck()) {
            return;
        }
        super.onMouse(e);
    }

    private String formatDurability(class_1799 stack) {
        if (!stack.method_7963()) {
            return "\u221e";
        }
        int maxDamage = stack.method_7936();
        int currentDamage = stack.method_7919();
        return maxDamage - currentDamage + "/" + maxDamage;
    }
}

