/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.impl;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.client.ui.hud.IslandModule;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class Island
extends HudElement {
    private float animationProgress = 0.0f;
    private float animatedWidth = 0.0f;
    private final Color bgColor = new Color(15, 15, 15, 245);

    public Island() {
        super("Island");
    }

    @Override
    public void onRender2D(EventRender2D e) {
        int alpha;
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        IslandModule module = phantomvisuals.getInstance().getModuleManager().getModule(IslandModule.class);
        if (module == null || !module.isToggled()) {
            return;
        }
        class_4587 matrices = e.getContext().method_51448();
        boolean isMentioned = System.currentTimeMillis() - module.getLastMentionTime() < 5000L;
        this.animationProgress = this.lerp(this.animationProgress, isMentioned ? 1.0f : 0.0f, 0.15f);
        String time = LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        String alert = "\u0412\u0430\u0448 \u043d\u0438\u043a \u0443\u043f\u043e\u043c\u044f\u043d\u0443\u0442!";
        float fontSize = 8.0f;
        float paddingX = 8.0f;
        float timeW = Fonts.REGULAR.getWidth(time, fontSize);
        float alertW = Fonts.REGULAR.getWidth(alert, fontSize);
        float targetWidth = timeW + (alertW - timeW) * this.animationProgress + paddingX * 2.0f;
        this.animatedWidth = this.lerp(this.animatedWidth, targetWidth, 0.2f);
        float height = 14.0f;
        float screenWidth = class_310.method_1551().method_22683().method_4486();
        float x = (screenWidth - this.animatedWidth) / 2.0f;
        float y = 17.0f;
        Render2D.drawRoundedRect(matrices, x, y, this.animatedWidth, height, 4.0f, this.bgColor);
        float textY = y + (height - fontSize) / 2.0f;
        if (this.animationProgress < 0.98f) {
            float tx = x + (this.animatedWidth - timeW) / 2.0f;
            alpha = (int)((1.0f - this.animationProgress) * 255.0f);
            Render2D.drawFont(matrices, Fonts.REGULAR.getFont(fontSize), time, tx, textY, new Color(255, 255, 255, Math.max(0, alpha)));
        }
        if (this.animationProgress > 0.02f) {
            float ax = x + (this.animatedWidth - alertW) / 2.0f;
            alpha = (int)(this.animationProgress * 255.0f);
            Render2D.drawFont(matrices, Fonts.REGULAR.getFont(fontSize), alert, ax, textY, new Color(255, 255, 255, Math.max(0, alpha)));
        }
        this.setBounds(x, y, this.animatedWidth, height);
    }

    private float lerp(float start, float end, float delta) {
        return start + (end - start) * delta;
    }
}

