/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.impl;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.client.util.perf.Perf;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_4587;

public class PerfHUD
extends HudElement {
    private static final float WIDTH = 180.0f;
    private static final float ROW_H = 10.0f;
    private static final float PADDING = 4.0f;

    public PerfHUD() {
        super("Perf");
    }

    @Override
    public void onRender2D(EventRender2D e) {
        if (PerfHUD.fullNullCheck() || this.closed()) {
            return;
        }
        class_4587 matrices = e.getContext().method_51448();
        Perf.endFrame();
        List<Perf.Row> rows = Perf.snapshot();
        int max = Math.min(10, rows.size());
        float h = 10.0f * (float)(max + 1) + 8.0f;
        this.setBounds(this.getX(), this.getY(), 180.0f, h);
        Render2D.drawRoundedRect(matrices, this.getX(), this.getY(), 180.0f, h, 4.0f, new Color(20, 20, 20, 180));
        float x = this.getX() + 4.0f;
        float y = this.getY() + 4.0f;
        float size = 7.5f;
        Render2D.drawFont(matrices, Fonts.REGULAR.getFont(size), "Section", x, y, Color.WHITE);
        Render2D.drawFont(matrices, Fonts.REGULAR.getFont(size), "CPU ms % | GPU ms %", x + 82.0f, y, Color.LIGHT_GRAY);
        y += 10.0f;
        for (int i = 0; i < max; ++i) {
            Perf.Row r = rows.get(i);
            String left = r.name;
            String right = String.format("%.2f %2.0f | %.2f %2.0f", r.cpuMs, r.cpuPct, r.gpuMs, r.gpuPct);
            Render2D.drawFont(matrices, Fonts.REGULAR.getFont(size), left, x, y, Color.WHITE);
            float rw = Fonts.REGULAR.getWidth(right, size);
            Render2D.drawFont(matrices, Fonts.REGULAR.getFont(size), right, this.getX() + 180.0f - 4.0f - rw, y, Color.WHITE);
            y += 10.0f;
        }
        super.onRender2D(e);
    }
}

