/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.impl;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.client.ui.hud.PotionsModule;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.animations.infinity.InfinityAnimation;
import dev.phantomvisuals.client.util.perf.Perf;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class Potions
extends HudElement
implements ThemeManager.ThemeChangeListener {
    private final InfinityAnimation heightAnim = new InfinityAnimation(Easing.OUT_QUAD);
    private final InfinityAnimation widthAnim = new InfinityAnimation(Easing.OUT_QUAD);
    private final ThemeManager themeManager;
    private final Color bgColor = new Color(20, 20, 20, 245);

    public Potions() {
        super("Potions");
        this.themeManager = ThemeManager.getInstance();
        this.themeManager.addThemeChangeListener(this);
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
    }

    @Override
    public void onRender2D(EventRender2D e) {
        PotionsModule module = phantomvisuals.getInstance().getModuleManager().getModule(PotionsModule.class);
        if (module == null || !module.isToggled() || Potions.fullNullCheck() || this.closed()) {
            return;
        }
        Perf.tryBeginFrame();
        try (Perf.CpuScope __ = Perf.scopeCpu("Potions.onRender2D");){
            class_746 player = Potions.mc.field_1724;
            if (player == null) {
                return;
            }
            float s = ((Float)module.scale.getValue()).floatValue();
            Collection raw = player.method_6026();
            boolean chatOpen = Potions.mc.field_1755 instanceof class_408;
            ArrayList<class_1293> effects = new ArrayList<class_1293>(raw);
            effects.sort(Comparator.comparing(a -> ((class_1291)a.method_5579().comp_349()).method_5560().getString()));
            ArrayList<String> keys2 = new ArrayList<String>();
            ArrayList<Object> texts = new ArrayList<Object>();
            for (class_1293 eff : effects) {
                class_1291 type = (class_1291)eff.method_5579().comp_349();
                String display = type.method_5560().getString() + (String)(eff.method_5578() > 0 ? " " + this.toRoman(eff.method_5578() + 1) : "");
                class_2960 rid = class_7923.field_41174.method_10221((Object)type);
                keys2.add(rid == null ? "speed" : rid.method_12832());
                texts.add(display);
            }
            if (chatOpen && keys2.isEmpty()) {
                keys2.add("speed");
                texts.add("Speed II");
            }
            boolean shouldShow = !keys2.isEmpty();
            float headerH = 18.8f * s;
            float spacing = 2.0f * s;
            float rowH = 16.0f * s;
            float pad = 5.0f * s;
            float iconSize = 13.0f * s;
            float fontS = 8.5f * s;
            float titleFontS = 9.0f * s;
            float timerBoxWidthBase = 35.0f * s;
            float targetWidth = 100.0f * s;
            for (String string : texts) {
                float w = iconSize + pad * 3.0f + Fonts.MEDIUM.getWidth(string, fontS) + timerBoxWidthBase;
                if (!(w > targetWidth)) continue;
                targetWidth = w;
            }
            float targetHeight = shouldShow ? headerH + spacing + (float)keys2.size() * rowH + 2.0f * s : 0.0f;
            this.heightAnim.animate(targetHeight, 180L);
            this.widthAnim.animate(targetWidth, 220L);
            float f = this.getX();
            float posY = this.getY();
            float cW = this.widthAnim.getValue();
            float cH = this.heightAnim.getValue();
            this.setBounds(f, posY, cW, cH);
            if (cH < 2.0f * s) {
                return;
            }
            class_4587 matrices = e.getContext().method_51448();
            Render2D.drawRoundedRect(matrices, f, posY, cW, cH, 5.0f * s, this.bgColor);
            if (cH > headerH) {
                String title = "Potions";
                float titleX = f + cW / 2.0f - Fonts.MEDIUM.getWidth(title, titleFontS) / 2.0f;
                float titleY = posY + headerH / 2.0f - Fonts.MEDIUM.getHeight(titleFontS) / 2.0f;
                Render2D.drawFont(matrices, Fonts.MEDIUM.getFont(titleFontS), title, titleX, titleY, Color.WHITE);
            }
            float curY = posY + headerH + spacing;
            for (int i = 0; i < keys2.size() && !(curY + rowH > posY + cH + 1.0f * s); ++i) {
                class_1293 eff = i < effects.size() ? (class_1293)effects.get(i) : null;
                class_2960 tex = class_2960.method_60655((String)"minecraft", (String)("textures/mob_effect/" + (String)keys2.get(i) + ".png"));
                Render2D.drawTexture(matrices, f + pad, curY + (rowH - iconSize) / 2.0f, iconSize, iconSize, 2.0f, 0.0f, 0.0f, 1.0f, 1.0f, tex, Color.WHITE);
                float textY = curY + rowH / 2.0f - Fonts.MEDIUM.getHeight(fontS) / 2.0f;
                Render2D.drawFont(matrices, Fonts.MEDIUM.getFont(fontS), (String)texts.get(i), f + pad + iconSize + pad, textY, Color.WHITE);
                String time = eff != null ? this.formatDuration(eff.method_5584()) : "0:30";
                float tw = Fonts.MEDIUM.getWidth(time, fontS);
                float pW = tw + 6.0f * s;
                float pX = f + cW - pW - pad;
                float pY = curY + 2.0f * s;
                float pH = rowH - 4.0f * s;
                Render2D.drawRoundedRect(matrices, pX, pY, pW, pH, 2.0f * s, new Color(0, 0, 0, 120));
                Render2D.drawFont(matrices, Fonts.MEDIUM.getFont(fontS), time, pX + (pW - tw) / 2.0f, textY, Color.WHITE);
                curY += rowH;
            }
            super.onRender2D(e);
        }
    }

    private String toRoman(int n) {
        return switch (n) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            default -> String.valueOf(n);
        };
    }

    private String formatDuration(int ticks) {
        int s = ticks / 20;
        return String.format("%d:%02d", s / 60, s % 60);
    }
}

