/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.impl;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.managers.FriendsManager;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.client.ui.hud.TargetHudModule;
import dev.phantomvisuals.client.util.Network.Server;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.animations.infinity.InfinityAnimation;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.modules.impl.utility.NameProtect;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_742;

public class TargetHud
extends HudElement {
    private final InfinityAnimation fadeAnimation = new InfinityAnimation(Easing.OUT_QUAD);
    private final InfinityAnimation scaleAnimation = new InfinityAnimation(Easing.OUT_QUAD);
    private final InfinityAnimation hpAnimPx = new InfinityAnimation(Easing.OUT_QUAD);
    private class_1309 lastTarget = null;
    private class_1309 renderTarget = null;
    private long lastSeenTime = 0L;
    private static final long HUD_DURATION = 2000L;
    private static final float BASE_WIDTH = 135.0f;
    private static final float BASE_HEIGHT = 38.0f;

    public TargetHud() {
        super("TargetHud");
    }

    @Override
    public void onRender2D(EventRender2D e) {
        boolean preview;
        class_1309 living;
        class_3966 hit;
        class_1297 class_12972;
        TargetHudModule module = phantomvisuals.getInstance().getModuleManager().getModule(TargetHudModule.class);
        if (module == null || !module.isToggled() || TargetHud.mc.field_1687 == null || TargetHud.mc.field_1724 == null) {
            return;
        }
        float s = ((Float)module.scale.getValue()).floatValue();
        float currentWidth = 135.0f * s;
        float currentHeight = 38.0f * s;
        this.setWidth(currentWidth);
        this.setHeight(currentHeight);
        float posX = this.getX();
        float posY = this.getY();
        long now = System.currentTimeMillis();
        if (TargetHud.mc.field_1765 != null && TargetHud.mc.field_1765.method_17783() == class_239.class_240.field_1331 && (class_12972 = (hit = (class_3966)TargetHud.mc.field_1765).method_17782()) instanceof class_1309 && (living = (class_1309)class_12972).method_5805() && !living.method_5767() && !living.method_6059(class_1294.field_5905)) {
            this.lastTarget = living;
            this.renderTarget = living;
            this.lastSeenTime = now;
        }
        if (!(this.lastTarget == null || this.lastTarget.method_5805() && now - this.lastSeenTime <= 2000L)) {
            this.lastTarget = null;
        }
        if ((preview = TargetHud.mc.field_1755 instanceof class_408) && this.lastTarget == null) {
            this.renderTarget = TargetHud.mc.field_1724;
        }
        boolean shouldShow = this.lastTarget != null || preview;
        this.fadeAnimation.animate(shouldShow ? 1.0f : 0.0f, 250L);
        this.scaleAnimation.animate(shouldShow ? 1.0f : 0.85f, 250L);
        if (this.fadeAnimation.getValue() <= 0.005f) {
            if (!shouldShow) {
                this.renderTarget = null;
            }
            return;
        }
        if (this.renderTarget == null) {
            return;
        }
        float fade = this.fadeAnimation.getValue();
        Color bgColor = new Color(20, 20, 20, (int)(245.0f * fade));
        float rawHp = Server.getHealth(this.renderTarget, false);
        float maxHp = Math.max(1.0f, this.renderTarget.method_6063());
        float hpPercent = class_3532.method_15363((float)(rawHp / maxHp), (float)0.0f, (float)1.0f);
        String hpText = "HP: " + String.format("%.1f", Float.valueOf(rawHp)).replace('.', ',');
        class_4587 matrices = e.getContext().method_51448();
        matrices.method_22903();
        float sc = this.scaleAnimation.getValue();
        matrices.method_46416(posX + currentWidth / 2.0f, posY + currentHeight / 2.0f, 0.0f);
        matrices.method_22905(sc, sc, 1.0f);
        matrices.method_46416(-(posX + currentWidth / 2.0f), -(posY + currentHeight / 2.0f), 0.0f);
        Render2D.drawRoundedRect(matrices, posX, posY, currentWidth, currentHeight, 5.0f * s, bgColor);
        float avatarSize = 28.0f * s;
        float margin = 5.0f * s;
        class_1309 class_13092 = this.renderTarget;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            Render2D.drawTexture(matrices, posX + margin, posY + (currentHeight - avatarSize) / 2.0f, avatarSize, avatarSize, 3.0f * s, 0.125f, 0.125f, 0.125f, 0.125f, ((class_742)player).method_52814().comp_1626(), new Color(255, 255, 255, (int)(255.0f * fade)));
        }
        float textX = posX + margin + avatarSize + 6.0f * s;
        float maxTextW = currentWidth - (textX - posX) - margin;
        String name = this.renderTarget.method_5477().getString();
        NameProtect np = NameProtect.getInstance();
        if (np != null && np.isToggled()) {
            String myName = mc.method_1548().method_1676();
            if (name.contains(myName)) {
                name = name.replace(myName, (CharSequence)np.customName.getValue());
            }
            if (((Boolean)np.protectFriends.getValue()).booleanValue()) {
                for (String friend : FriendsManager.getFriends()) {
                    if (!name.contains(friend)) continue;
                    name = name.replace(friend, "Friend");
                }
            }
        }
        Object croppedName = name;
        if (Fonts.BOLD.getWidth(name, 10.0f * s) > maxTextW) {
            while (Fonts.BOLD.getWidth((String)croppedName + "...", 10.0f * s) > maxTextW && ((String)croppedName).length() > 0) {
                croppedName = ((String)croppedName).substring(0, ((String)croppedName).length() - 1);
            }
            croppedName = (String)croppedName + "...";
        }
        Render2D.drawFont(matrices, Fonts.BOLD.getFont(10.0f * s), (String)croppedName, textX, posY + 6.0f * s, new Color(255, 255, 255, (int)(255.0f * fade)));
        Render2D.drawFont(matrices, Fonts.BOLD.getFont(8.5f * s), hpText, textX, posY + 17.0f * s, new Color(200, 200, 200, (int)(255.0f * fade)));
        float barY = posY + 28.0f * s;
        float barHeight = 3.5f * s;
        Render2D.drawRoundedRect(matrices, textX, barY, maxTextW, barHeight, 1.5f * s, new Color(45, 45, 45, (int)(200.0f * fade)));
        float animatedW = this.hpAnimPx.animate(maxTextW * hpPercent, 150L);
        Color accent = ThemeManager.getInstance().getCurrentTheme().getAccentColor();
        Render2D.drawRoundedRect(matrices, textX, barY, animatedW, barHeight, 1.5f * s, new Color(accent.getRed(), accent.getGreen(), accent.getBlue(), (int)(255.0f * fade)));
        matrices.method_22909();
        super.onRender2D(e);
    }
}

