/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.impl;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.ui.hud.HudElement;
import dev.phantomvisuals.client.ui.hud.WatermarkModule;
import dev.phantomvisuals.client.util.perf.Perf;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.phantomvisuals;
import java.awt.Color;
import net.minecraft.class_4587;

public class Watermark
extends HudElement
implements ThemeManager.ThemeChangeListener {
    private final ThemeManager themeManager;
    private final Color bgColor = new Color(20, 20, 20, 245);

    public Watermark() {
        super("Watermark");
        this.themeManager = ThemeManager.getInstance();
        this.themeManager.addThemeChangeListener(this);
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
    }

    @Override
    public void onRender2D(EventRender2D e) {
        WatermarkModule module = phantomvisuals.getInstance().getModuleManager().getModule(WatermarkModule.class);
        if (module == null || !module.isToggled() || Watermark.fullNullCheck() || this.closed()) {
            return;
        }
        Perf.tryBeginFrame();
        try (Perf.CpuScope __ = Perf.scopeCpu("Watermark.onRender2D");){
            class_4587 matrices = e.getContext().method_51448();
            float s = ((Float)module.scale.getValue()).floatValue();
            String title = "PhantomVisuals";
            String link = "t.me/phantomvisual";
            float fontSizeTitle = 9.0f * s;
            float fontSizeLink = 7.0f * s;
            float paddingX = 5.0f * s;
            float paddingY = 6.0f * s;
            float logoSize = 27.0f * s;
            float spacing = 4.0f * s;
            float titleWidth = Fonts.BOLD.getWidth(title, fontSizeTitle);
            float linkWidth = Fonts.REGULAR.getWidth(link, fontSizeLink);
            float totalWidth = paddingX * 2.0f + logoSize + spacing + Math.max(titleWidth, linkWidth) + 4.0f * s;
            float totalHeight = paddingY * 2.0f + fontSizeTitle + fontSizeLink + 2.0f * s;
            this.setBounds(this.getX(), this.getY(), totalWidth, totalHeight);
            Render2D.drawRoundedRect(matrices, this.getX(), this.getY(), totalWidth, totalHeight, 4.0f * s, this.bgColor);
            Color accent = this.themeManager.getCurrentTheme().getAccentColor();
            Render2D.drawFont(matrices, Fonts.ICONS.getFont(logoSize), "R", this.getX() + paddingX, this.getY() + (totalHeight - logoSize) / 2.0f, accent);
            float textX = this.getX() + paddingX + logoSize + 2.0f * s;
            float textY = this.getY() + paddingY;
            Render2D.drawFont(matrices, Fonts.BOLD.getFont(fontSizeTitle), title, textX, textY, Color.WHITE);
            Render2D.drawFont(matrices, Fonts.REGULAR.getFont(fontSizeLink), link, textX, textY + fontSizeTitle + 2.0f * s, new Color(160, 160, 160));
            super.onRender2D(e);
        }
    }
}

