/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.impl;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.managers.ThemeManager;
import dev.phantomvisuals.client.managers.WaypointManager;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import dev.phantomvisuals.client.util.world.WorldUtils;
import java.awt.Color;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_243;

public class WaypointOverlay
implements Wrapper,
ThemeManager.ThemeChangeListener {
    private final ThemeManager themeManager = ThemeManager.getInstance();
    private Color textColor;
    private Color bgColor;
    private Color accent;

    public WaypointOverlay() {
        this.applyTheme(this.themeManager.getCurrentTheme());
        this.themeManager.addThemeChangeListener(this);
    }

    private void applyTheme(ThemeManager.Theme theme) {
        this.textColor = theme.getTextColor();
        this.bgColor = new Color(theme.getBackgroundColor().getRed(), theme.getBackgroundColor().getGreen(), theme.getBackgroundColor().getBlue(), 170);
        this.accent = theme.getAccentColor();
    }

    @Override
    public void onThemeChanged(ThemeManager.Theme theme) {
        this.applyTheme(theme);
    }

    @EventHandler
    public void onRender2D(EventRender2D e) {
        if (WaypointOverlay.mc.field_1724 == null || WaypointOverlay.mc.field_1687 == null) {
            return;
        }
        int winW = mc.method_22683().method_4486();
        int winH = mc.method_22683().method_4502();
        for (WaypointManager.Waypoint w : WaypointManager.list()) {
            class_243 screen = WorldUtils.getPosition(w.pos.method_1031(0.0, 1.8, 0.0));
            if (!(screen.field_1350 > 0.0)) continue;
            String label = w.name;
            int meters = (int)Math.floor(WaypointOverlay.mc.field_1724.method_19538().method_1022(w.pos));
            String meta = meters + "m";
            float nameSize = 8.5f;
            float metaSize = 8.0f;
            float padX = 4.0f;
            float padY = 3.0f;
            float nameW = Fonts.BOLD.getWidth(label, nameSize);
            float metaW = Fonts.BOLD.getWidth(meta, metaSize);
            float width = Math.max(nameW, metaW) + padX * 2.0f;
            float height = Fonts.BOLD.getHeight(nameSize) + Fonts.BOLD.getHeight(metaSize) + padY * 3.0f;
            float x = (float)screen.field_1352 - width / 2.0f;
            float y = (float)screen.field_1351 - height - 8.0f;
            x = Math.max(5.0f, Math.min(x, (float)winW - width - 5.0f));
            y = Math.max(5.0f, Math.min(y, (float)winH - height - 5.0f));
            Render2D.drawRoundedRect(e.getContext().method_51448(), x + 2.0f, y + 2.0f, width, height, 3.0f, new Color(0, 0, 0, 70));
            Render2D.drawRoundedRect(e.getContext().method_51448(), x, y, width, height, 3.0f, this.bgColor);
            Render2D.drawRoundedRect(e.getContext().method_51448(), Math.max(3.0f, Math.min((float)screen.field_1352, (float)winW - 3.0f)) - 2.0f, Math.max(3.0f, Math.min((float)screen.field_1351, (float)winH - 3.0f)) - 2.0f, 4.0f, 4.0f, 2.0f, new Color(this.accent.getRed(), this.accent.getGreen(), this.accent.getBlue(), 220));
            Render2D.drawFont(e.getContext().method_51448(), Fonts.BOLD.getFont(nameSize), label, x + padX, y + padY, new Color(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue(), 255));
            Render2D.drawFont(e.getContext().method_51448(), Fonts.BOLD.getFont(metaSize), meta, x + padX, y + padY + Fonts.BOLD.getHeight(nameSize) + 2.0f, new Color(this.textColor.getRed(), this.textColor.getGreen(), this.textColor.getBlue(), 220));
        }
    }

    public void onDisable() {
        this.themeManager.removeThemeChangeListener(this);
    }
}

