/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.hud.windows;

import dev.phantomvisuals.client.ui.hud.windows.components.WindowComponent;
import dev.phantomvisuals.client.ui.hud.windows.components.impl.BooleanComponent;
import dev.phantomvisuals.client.ui.hud.windows.components.impl.ListComponent;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.modules.settings.Setting;
import dev.phantomvisuals.modules.settings.impl.BooleanSetting;
import dev.phantomvisuals.modules.settings.impl.ListSetting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_332;

public class Window {
    private float x;
    private float y;
    private float width;
    private float height;
    private final List<Setting<?>> settings;
    private final List<WindowComponent> components = new ArrayList<WindowComponent>();
    private final Animation animation = new Animation(300L, 1.0, true, Easing.BOTH_SINE);
    private final Color bgColor = new Color(30, 30, 30, 240);

    public Window(float x, float y, float width, float height, List<Setting<?>> settings) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.settings = settings;
        for (Setting<?> setting : settings) {
            if (setting instanceof BooleanSetting) {
                this.components.add(new BooleanComponent(setting.getName(), (BooleanSetting)setting));
                continue;
            }
            if (!(setting instanceof ListSetting)) continue;
            this.components.add(new ListComponent(setting.getName(), (ListSetting)setting));
        }
    }

    public void render(class_332 context, int mouseX, int mouseY) {
        Render2D.startScissor(context, this.getX() + (this.getWidth() - this.getWidth() * this.animation.getValue()) / 2.0f, this.getY() + (this.getFinalHeight() - this.getFinalHeight() * this.animation.getValue()) / 2.0f, this.getWidth() * this.animation.getValue(), this.getFinalHeight() * this.animation.getValue());
        Render2D.drawRoundedRect(context.method_51448(), this.getX() + (this.getWidth() - this.getWidth() * this.animation.getValue()) / 2.0f, this.getY() + (this.getFinalHeight() - this.getFinalHeight() * this.animation.getValue()) / 2.0f, this.getWidth() * this.animation.getValue(), this.getFinalHeight() * this.animation.getValue(), 3.5f, this.bgColor);
        float finalY = this.y;
        for (WindowComponent component : this.components) {
            component.setX(this.x);
            component.setY(finalY);
            component.setWidth(this.width);
            component.setHeight(this.height);
            component.setAnimation(this.animation);
            component.render(context, mouseX, mouseY, 0.0f);
            finalY += component.getHeight() + 4.5f;
        }
        Render2D.stopScissor(context);
    }

    public void reset() {
        this.animation.update(false);
    }

    public boolean closed() {
        return this.animation.finished(false) && this.animation.getValue() <= 0.01f;
    }

    public void mouseClicked(double mouseX, double mouseY, int button) {
        for (WindowComponent component : this.components) {
            component.mouseClicked(mouseX, mouseY, button);
        }
    }

    public float getFinalHeight() {
        float height = 0.0f;
        for (WindowComponent component : this.components) {
            if (!component.getVisible().get().booleanValue()) continue;
            height += component.getHeight() + component.getAddHeight().get().floatValue() + 4.5f;
        }
        return height;
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public float getWidth() {
        return this.width;
    }

    @Generated
    public float getHeight() {
        return this.height;
    }

    @Generated
    public List<Setting<?>> getSettings() {
        return this.settings;
    }

    @Generated
    public List<WindowComponent> getComponents() {
        return this.components;
    }

    @Generated
    public Animation getAnimation() {
        return this.animation;
    }

    @Generated
    public Color getBgColor() {
        return this.bgColor;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public void setWidth(float width) {
        this.width = width;
    }

    @Generated
    public void setHeight(float height) {
        this.height = height;
    }
}

