/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.mainmenu;

import dev.phantomvisuals.client.managers.AltManager;
import dev.phantomvisuals.client.render.builders.impl.BlurBuilder;
import dev.phantomvisuals.client.render.builders.impl.RectangleBuilder;
import dev.phantomvisuals.client.render.builders.impl.TextBuilder;
import dev.phantomvisuals.client.render.builders.states.QuadColorState;
import dev.phantomvisuals.client.render.builders.states.QuadRadiusState;
import dev.phantomvisuals.client.render.builders.states.SizeState;
import dev.phantomvisuals.client.render.renderers.impl.BuiltBlur;
import dev.phantomvisuals.client.render.renderers.impl.BuiltRectangle;
import dev.phantomvisuals.client.render.renderers.impl.BuiltText;
import dev.phantomvisuals.client.ui.mainmenu.MainMenu;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.joml.Matrix4f;

public class AltManagerScreen
extends class_437 {
    private final class_437 parent;
    private final List<String> alts = new ArrayList<String>();
    private final List<String> filteredAlts = new ArrayList<String>();
    private final List<MainMenu.AnimatedButton> buttons = new ArrayList<MainMenu.AnimatedButton>();
    private String inputBuffer = "";
    private String searchBuffer = "";
    private int selectedIndex = -1;
    private int caretIndex = 0;
    private int selectionStart = -1;
    private int searchCaretIndex = 0;
    private int searchSelectionStart = -1;
    private boolean inputFocused = false;
    private boolean searchFocused = false;
    private final Animation inputFocusAnimation = new Animation(220L, 1.0, false, Easing.OUT_EXPO);
    private final Animation searchFocusAnimation = new Animation(220L, 1.0, false, Easing.OUT_EXPO);
    private final Animation listHoverAnimation = new Animation(200L, 1.0, false, Easing.OUT_EXPO);
    private int hoveredRowIndex = -1;
    private float listScroll = 0.0f;
    private float listScrollTarget = 0.0f;
    private float listMaxScroll = 0.0f;

    public AltManagerScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"phantomvisuals.alt.title", (Object[])new Object[0])));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.alts.clear();
        this.alts.addAll(AltManager.getNicknames());
        this.filterAlts();
        this.buttons.clear();
        if (this.caretIndex > this.inputBuffer.length()) {
            this.caretIndex = this.inputBuffer.length();
        }
        if (this.searchCaretIndex > this.searchBuffer.length()) {
            this.searchCaretIndex = this.searchBuffer.length();
        }
        this.listScroll = 0.0f;
        this.listScrollTarget = 0.0f;
        String active = AltManager.getLastUsedNickname();
        if (active != null) {
            for (int i = 0; i < this.filteredAlts.size(); ++i) {
                if (!this.filteredAlts.get(i).equalsIgnoreCase(active)) continue;
                this.selectedIndex = i;
                break;
            }
        }
        float buttonWidth = 125.0f;
        float buttonHeight = 22.0f;
        float groupMargin = 8.0f;
        float centerY = (float)this.field_22790 / 2.0f + 60.0f;
        float groupWidth = buttonWidth * 2.0f + groupMargin;
        float groupStartX = (float)this.field_22789 / 2.0f - groupWidth / 2.0f;
        this.buttons.add(new MainMenu.AnimatedButton(groupStartX, centerY, buttonWidth, buttonHeight, class_1074.method_4662((String)"phantomvisuals.alt.add", (Object[])new Object[0]), b -> {
            if (!this.inputBuffer.isEmpty() && AltManager.addNickname(this.inputBuffer)) {
                this.inputBuffer = "";
                this.caretIndex = 0;
                this.selectionStart = -1;
                this.method_25426();
            }
        }));
        this.buttons.add(new MainMenu.AnimatedButton(groupStartX + buttonWidth + groupMargin, centerY, buttonWidth, buttonHeight, class_1074.method_4662((String)"phantomvisuals.alt.delete", (Object[])new Object[0]), b -> {
            String target;
            if (this.selectedIndex >= 0 && this.selectedIndex < this.filteredAlts.size() && AltManager.removeNickname(target = this.filteredAlts.get(this.selectedIndex))) {
                this.selectedIndex = -1;
                this.method_25426();
            }
        }));
        float backX = (float)this.field_22789 / 2.0f - buttonWidth / 2.0f;
        this.buttons.add(new MainMenu.AnimatedButton(backX, centerY + buttonHeight + groupMargin * 2.0f, buttonWidth, buttonHeight, class_1074.method_4662((String)"phantomvisuals.alt.back", (Object[])new Object[0]), b -> this.field_22787.method_1507(this.parent)));
    }

    public boolean method_25400(char chr, int modifiers) {
        if (Character.isISOControl(chr)) {
            return false;
        }
        this.insertText(String.valueOf(chr));
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean ctrl = AltManagerScreen.method_25441();
        boolean shift = AltManagerScreen.method_25442();
        if (ctrl && keyCode == 86) {
            String clip;
            String string = clip = this.field_22787 != null && this.field_22787.field_1774 != null ? this.field_22787.field_1774.method_1460() : null;
            if (clip != null && !clip.isEmpty()) {
                this.insertText(clip);
            }
            return true;
        }
        if (ctrl && keyCode == 67) {
            String sel = this.getSelectedText();
            if (sel != null && this.field_22787 != null && this.field_22787.field_1774 != null) {
                this.field_22787.field_1774.method_1455(sel);
            }
            return true;
        }
        if (ctrl && keyCode == 88) {
            String sel = this.getSelectedText();
            if (sel != null && this.field_22787 != null && this.field_22787.field_1774 != null) {
                this.field_22787.field_1774.method_1455(sel);
                this.deleteSelection();
            }
            return true;
        }
        if (ctrl && keyCode == 65) {
            this.selectionStart = 0;
            this.caretIndex = this.inputBuffer.length();
            return true;
        }
        if (keyCode == 259) {
            if (!this.deleteSelection() && this.caretIndex > 0 && !this.inputBuffer.isEmpty()) {
                this.inputBuffer = this.inputBuffer.substring(0, this.caretIndex - 1) + this.inputBuffer.substring(this.caretIndex);
                --this.caretIndex;
            }
            return true;
        }
        if (keyCode == 261) {
            if (!this.deleteSelection() && this.caretIndex < this.inputBuffer.length()) {
                this.inputBuffer = this.inputBuffer.substring(0, this.caretIndex) + this.inputBuffer.substring(this.caretIndex + 1);
            }
            return true;
        }
        if (keyCode == 263) {
            this.moveCaret(-1, shift);
            return true;
        }
        if (keyCode == 262) {
            this.moveCaret(1, shift);
            return true;
        }
        if (keyCode == 257) {
            if (!this.inputBuffer.isEmpty()) {
                if (AltManager.addNickname(this.inputBuffer)) {
                    this.inputBuffer = "";
                    this.caretIndex = 0;
                    this.selectionStart = -1;
                    this.method_25426();
                }
            } else if (this.selectedIndex >= 0 && this.selectedIndex < this.filteredAlts.size()) {
                AltManager.applyNickname(this.filteredAlts.get(this.selectedIndex));
                this.method_25426();
            }
            return true;
        }
        if (keyCode == 261 && this.selectedIndex >= 0 && this.selectedIndex < this.filteredAlts.size()) {
            String target = this.filteredAlts.get(this.selectedIndex);
            if (AltManager.removeNickname(target)) {
                this.selectedIndex = -1;
                this.method_25426();
            }
            return true;
        }
        if (keyCode == 265) {
            if (this.selectedIndex > 0) {
                --this.selectedIndex;
            } else if (this.filteredAlts.size() > 0) {
                this.selectedIndex = this.filteredAlts.size() - 1;
            }
            return true;
        }
        if (keyCode == 264) {
            this.selectedIndex = this.selectedIndex < this.filteredAlts.size() - 1 ? ++this.selectedIndex : 0;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int rowHeight;
        int index;
        float listWidth = 220.0f;
        float listHeight = 120.0f;
        float listX = (float)this.field_22789 / 2.0f - listWidth / 2.0f;
        float listY = (float)this.field_22790 / 2.0f - listHeight / 2.0f - 22.0f;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listWidth) && mouseY >= (double)listY && mouseY <= (double)(listY + listHeight) && (index = (int)((mouseY - (double)listY + (double)this.listScroll) / (double)(rowHeight = 16))) >= 0 && index < this.filteredAlts.size()) {
            if (this.selectedIndex == index) {
                AltManager.applyNickname(this.filteredAlts.get(index));
                this.method_25426();
            } else {
                this.selectedIndex = index;
            }
        }
        float inputWidth = 220.0f;
        float inputHeight = 18.0f;
        float inputX = (float)this.field_22789 / 2.0f - inputWidth / 2.0f;
        float inputY = (float)this.field_22790 / 2.0f + 20.0f;
        if (mouseX >= (double)inputX && mouseX <= (double)(inputX + inputWidth) && mouseY >= (double)inputY && mouseY <= (double)(inputY + inputHeight)) {
            int newIndex = this.getCaretIndexByMouse((float)mouseX, inputX);
            if (button == 0) {
                if (AltManagerScreen.method_25442()) {
                    if (this.selectionStart == -1) {
                        this.selectionStart = this.caretIndex;
                    }
                    this.caretIndex = newIndex;
                } else {
                    this.caretIndex = newIndex;
                    this.selectionStart = -1;
                }
                this.inputFocused = true;
                this.inputFocusAnimation.update(true);
            }
            return true;
        }
        this.inputFocused = false;
        this.inputFocusAnimation.update(false);
        for (MainMenu.AnimatedButton btn : this.buttons) {
            if (!btn.isMouseOver((int)mouseX, (int)mouseY)) continue;
            btn.onPress();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        float listWidth = 220.0f;
        float listHeight = 120.0f;
        float listX = (float)this.field_22789 / 2.0f - listWidth / 2.0f;
        float listY = (float)this.field_22790 / 2.0f - listHeight / 2.0f - 22.0f;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + listWidth) && mouseY >= (double)listY && mouseY <= (double)(listY + listHeight)) {
            float step = (float)(-vertical * 12.0);
            this.listScrollTarget = AltManagerScreen.clamp(this.listScrollTarget + step, 0.0f, this.listMaxScroll);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontal, vertical);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
        ((BuiltRectangle)new RectangleBuilder().size(new SizeState(this.field_22789, this.field_22790)).radius(new QuadRadiusState(0.0f)).color(new QuadColorState(new Color(10, 10, 15, 255), new Color(10, 10, 15, 255), new Color(40, 40, 50, 255), new Color(40, 40, 50, 255))).build()).render(matrix, 0.0f, 0.0f, 0.0f);
        ((BuiltBlur)new BlurBuilder().size(new SizeState(this.field_22789, this.field_22790)).radius(new QuadRadiusState(0.0f)).color(new QuadColorState(new Color(15, 15, 20, 10))).blurRadius(0.0f).smoothness(30.0f).build()).render(matrix, 0.0f, 0.0f, 0.0f);
        String title = class_1074.method_4662((String)"phantomvisuals.alt.title", (Object[])new Object[0]);
        float titleX = (float)this.field_22789 / 2.0f - Fonts.BOLD.getWidth(title, 9.0f) / 2.0f;
        float titleY = (float)this.field_22790 / 2.0f - 120.0f;
        ((BuiltText)new TextBuilder().font(Fonts.BOLD.font()).text(title).size(9.0f).color(new Color(220, 220, 240)).smoothness(0.5f).build()).render(matrix, titleX, titleY, 0.0f);
        String status = String.format("%d/%d alts", AltManager.getAltCount(), AltManager.getMaxAlts());
        float statusX = (float)this.field_22789 / 2.0f - Fonts.REGULAR.getWidth(status, 6.0f) / 2.0f;
        float statusY = titleY + 27.0f;
        ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(status).size(6.0f).color(new Color(180, 180, 200)).smoothness(0.5f).build()).render(matrix, statusX, statusY, 0.0f);
        float inputWidth = 220.0f;
        float inputHeight = 18.0f;
        float inputX = (float)this.field_22789 / 2.0f - inputWidth / 2.0f;
        float inputY = (float)this.field_22790 / 2.0f + 20.0f + 0.6f;
        ((BuiltRectangle)new RectangleBuilder().size(new SizeState(inputWidth, inputHeight)).radius(new QuadRadiusState(8.0f)).color(new QuadColorState(new Color(24, 24, 30, 255))).build()).render(matrix, inputX, inputY, 0.0f);
        if (this.inputBuffer.isEmpty() && !this.inputFocused) {
            String placeholder = class_1074.method_4662((String)"phantomvisuals.alt.placeholder", (Object[])new Object[0]);
            ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(placeholder).size(7.0f).color(new Color(120, 120, 140)).smoothness(0.5f).build()).render(matrix, inputX + 6.0f, inputY + 5.0f, 0.0f);
        } else if (!this.inputBuffer.isEmpty()) {
            ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(this.inputBuffer).size(7.0f).color(new Color(230, 230, 240)).smoothness(0.5f).build()).render(matrix, inputX + 6.0f, inputY + 5.0f, 0.0f);
        }
        if (this.selectionStart != -1 && this.selectionStart != this.caretIndex && !this.inputBuffer.isEmpty()) {
            int a = Math.min(this.selectionStart, this.caretIndex);
            int b = Math.max(this.selectionStart, this.caretIndex);
            float ax = inputX + 6.0f + Fonts.REGULAR.getWidth(this.inputBuffer.substring(0, a), 7.0f);
            float bx = inputX + 6.0f + Fonts.REGULAR.getWidth(this.inputBuffer.substring(0, b), 7.0f);
            ((BuiltRectangle)new RectangleBuilder().size(new SizeState(Math.max(1.0f, bx - ax), Fonts.REGULAR.getHeight(7.0f))).radius(new QuadRadiusState(2.0f)).color(new QuadColorState(new Color(80, 120, 200, 120))).build()).render(matrix, ax, inputY + 5.0f, 0.0f);
        }
        if (!this.inputBuffer.isEmpty() || this.selectionStart == -1) {
            float caretX = inputX + 6.0f + Fonts.REGULAR.getWidth(this.inputBuffer.substring(0, Math.min(this.caretIndex, this.inputBuffer.length())), 7.0f);
            ((BuiltRectangle)new RectangleBuilder().size(new SizeState(1.0f, Fonts.REGULAR.getHeight(7.0f))).radius(new QuadRadiusState(0.0f)).color(new QuadColorState(new Color(230, 230, 240, (int)(200.0f * (0.5f + 0.5f * (float)Math.sin((double)System.currentTimeMillis() / 200.0)))))).build()).render(matrix, caretX, inputY + 5.0f, 0.0f);
        }
        float listWidth = 220.0f;
        float listHeight = 120.0f;
        float listX = (float)this.field_22789 / 2.0f - listWidth / 2.0f;
        float listY = (float)this.field_22790 / 2.0f - listHeight / 2.0f - 22.0f;
        ((BuiltRectangle)new RectangleBuilder().size(new SizeState(listWidth, listHeight)).radius(new QuadRadiusState(8.0f)).color(new QuadColorState(new Color(30, 30, 38, 200))).build()).render(matrix, listX, listY, 0.0f);
        int rowHeight = 16;
        float scrollSmooth = 0.18f;
        this.listScroll += (this.listScrollTarget - this.listScroll) * scrollSmooth;
        this.listScroll = AltManagerScreen.clamp(this.listScroll, 0.0f, this.listMaxScroll);
        this.hoveredRowIndex = -1;
        if ((float)mouseX >= listX && (float)mouseX <= listX + listWidth && (float)mouseY >= listY && (float)mouseY <= listY + listHeight) {
            this.hoveredRowIndex = (int)(((float)mouseY - listY + this.listScroll) / (float)rowHeight);
        }
        this.listHoverAnimation.update(this.hoveredRowIndex >= 0 && this.hoveredRowIndex < this.filteredAlts.size());
        float hoverT = this.listHoverAnimation.getValue();
        float contentHeight = this.filteredAlts.size() * rowHeight;
        this.listMaxScroll = Math.max(0.0f, contentHeight - listHeight);
        float visibleBottom = listY + listHeight;
        int sx1 = Math.round(listX) + 1;
        int sy1 = Math.round(listY) + 1;
        int sx2 = Math.round(listX + listWidth) - 1;
        int sy2 = Math.round(listY + listHeight) - 1;
        drawContext.method_44379(sx1, sy1, sx2, sy2);
        for (int i = 0; i < this.filteredAlts.size(); ++i) {
            boolean sel;
            float rowY = listY + (float)(i * rowHeight) - this.listScroll;
            if (rowY + (float)rowHeight < listY) continue;
            if (rowY > visibleBottom) break;
            boolean bl = sel = i == this.selectedIndex;
            if (sel) {
                ((BuiltRectangle)new RectangleBuilder().size(new SizeState(listWidth - 8.0f, rowHeight)).radius(new QuadRadiusState(6.0f)).color(new QuadColorState(new Color(60, 60, 80, 120))).build()).render(matrix, listX + 4.0f, rowY, 0.0f);
            }
            if (i == this.hoveredRowIndex && !sel) {
                int ha = (int)(80.0f + 70.0f * hoverT);
                ((BuiltRectangle)new RectangleBuilder().size(new SizeState(listWidth - 8.0f, rowHeight)).radius(new QuadRadiusState(6.0f)).color(new QuadColorState(new Color(50, 60, 90, ha))).build()).render(matrix, listX + 4.0f, rowY, 0.0f);
            }
            boolean isActive = AltManager.getLastUsedNickname() != null && this.filteredAlts.get(i).equalsIgnoreCase(AltManager.getLastUsedNickname());
            ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(this.filteredAlts.get(i)).size(7.0f).color(isActive ? new Color(90, 140, 255) : new Color(230, 230, 240)).smoothness(0.5f).build()).render(matrix, listX + 6.0f, rowY + 4.0f, 0.0f);
        }
        drawContext.method_44380();
        ((BuiltRectangle)new RectangleBuilder().size(new SizeState(inputWidth, inputHeight)).radius(new QuadRadiusState(8.0f)).color(new QuadColorState(new Color(24, 24, 30, 255))).build()).render(matrix, inputX, inputY, 0.0f);
        if (this.inputBuffer.isEmpty() && !this.inputFocused) {
            String placeholderTop = class_1074.method_4662((String)"phantomvisuals.alt.placeholder", (Object[])new Object[0]);
            ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(placeholderTop).size(7.0f).color(new Color(120, 120, 140)).smoothness(0.5f).build()).render(matrix, inputX + 6.0f, inputY + 5.0f, 0.0f);
        } else if (!this.inputBuffer.isEmpty()) {
            ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(this.inputBuffer).size(7.0f).color(new Color(230, 230, 240)).smoothness(0.5f).build()).render(matrix, inputX + 6.0f, inputY + 5.0f, 0.0f);
        }
        if (this.selectionStart != -1 && this.selectionStart != this.caretIndex && !this.inputBuffer.isEmpty()) {
            int aTop = Math.min(this.selectionStart, this.caretIndex);
            int bTop = Math.max(this.selectionStart, this.caretIndex);
            float axTop = inputX + 6.0f + Fonts.REGULAR.getWidth(this.inputBuffer.substring(0, aTop), 7.0f);
            float bxTop = inputX + 6.0f + Fonts.REGULAR.getWidth(this.inputBuffer.substring(0, bTop), 7.0f);
            ((BuiltRectangle)new RectangleBuilder().size(new SizeState(Math.max(1.0f, bxTop - axTop), Fonts.REGULAR.getHeight(7.0f))).radius(new QuadRadiusState(2.0f)).color(new QuadColorState(new Color(80, 120, 200, 120))).build()).render(matrix, axTop, inputY + 5.0f, 0.0f);
        }
        if (!this.inputBuffer.isEmpty() || this.selectionStart == -1) {
            float caretXTop = inputX + 6.0f + Fonts.REGULAR.getWidth(this.inputBuffer.substring(0, Math.min(this.caretIndex, this.inputBuffer.length())), 7.0f);
            ((BuiltRectangle)new RectangleBuilder().size(new SizeState(1.0f, Fonts.REGULAR.getHeight(7.0f))).radius(new QuadRadiusState(0.0f)).color(new QuadColorState(new Color(230, 230, 240, (int)(200.0f * (0.5f + 0.5f * (float)Math.sin((double)System.currentTimeMillis() / 200.0)))))).build()).render(matrix, caretXTop, inputY + 5.0f, 0.0f);
        }
        for (MainMenu.AnimatedButton btn : this.buttons) {
            btn.render(drawContext, mouseX, mouseY, delta, 1.0f);
        }
    }

    public boolean method_25422() {
        return true;
    }

    private void moveCaret(int delta, boolean keepSelection) {
        int newIndex = Math.max(0, Math.min(this.inputBuffer.length(), this.caretIndex + delta));
        if (keepSelection) {
            if (this.selectionStart == -1) {
                this.selectionStart = this.caretIndex;
            }
            this.caretIndex = newIndex;
        } else {
            this.caretIndex = newIndex;
            this.selectionStart = -1;
        }
    }

    private void insertText(String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.') && c != '-') continue;
            sb.append(c);
        }
        String filtered = sb.toString();
        if (filtered.isEmpty()) {
            return;
        }
        if (!this.deleteSelection()) {
            String left = this.inputBuffer.substring(0, this.caretIndex);
            String right = this.inputBuffer.substring(this.caretIndex);
            this.inputBuffer = left + filtered + right;
            this.caretIndex += filtered.length();
        }
    }

    private boolean deleteSelection() {
        if (this.selectionStart != -1 && this.selectionStart != this.caretIndex) {
            int a = Math.min(this.selectionStart, this.caretIndex);
            int b = Math.max(this.selectionStart, this.caretIndex);
            this.inputBuffer = this.inputBuffer.substring(0, a) + this.inputBuffer.substring(b);
            this.caretIndex = a;
            this.selectionStart = -1;
            return true;
        }
        return false;
    }

    private String getSelectedText() {
        if (this.selectionStart != -1 && this.selectionStart != this.caretIndex) {
            int a = Math.min(this.selectionStart, this.caretIndex);
            int b = Math.max(this.selectionStart, this.caretIndex);
            return this.inputBuffer.substring(a, b);
        }
        return null;
    }

    private int getCaretIndexByMouse(float mouseX, float inputX) {
        int idx = 0;
        float target = mouseX - (inputX + 6.0f);
        if (target <= 0.0f) {
            return 0;
        }
        float lastWidth = 0.0f;
        int i = 1;
        while (i <= this.inputBuffer.length()) {
            float w = Fonts.REGULAR.getWidth(this.inputBuffer.substring(0, i), 7.0f);
            if (w >= target) {
                return target - lastWidth < w - target ? i - 1 : i;
            }
            lastWidth = w;
            idx = i++;
        }
        return idx;
    }

    private static float clamp(float v, float min, float max) {
        return Math.max(min, Math.min(max, v));
    }

    private void filterAlts() {
        this.filteredAlts.clear();
        if (this.searchBuffer.isEmpty()) {
            this.filteredAlts.addAll(this.alts);
        } else {
            String searchLower = this.searchBuffer.toLowerCase();
            for (String alt : this.alts) {
                if (!alt.toLowerCase().contains(searchLower)) continue;
                this.filteredAlts.add(alt);
            }
        }
    }
}

