/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.ui.mainmenu;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.phantomvisuals.client.render.builders.impl.BlurBuilder;
import dev.phantomvisuals.client.render.builders.impl.RectangleBuilder;
import dev.phantomvisuals.client.render.builders.impl.TextBuilder;
import dev.phantomvisuals.client.render.builders.states.QuadColorState;
import dev.phantomvisuals.client.render.builders.states.QuadRadiusState;
import dev.phantomvisuals.client.render.builders.states.SizeState;
import dev.phantomvisuals.client.render.renderers.impl.BuiltBlur;
import dev.phantomvisuals.client.render.renderers.impl.BuiltRectangle;
import dev.phantomvisuals.client.render.renderers.impl.BuiltText;
import dev.phantomvisuals.client.ui.mainmenu.AltManagerScreen;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_500;
import net.minecraft.class_526;
import org.joml.Matrix4f;

public class MainMenu
extends class_437 {
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60654((String)"hud/backf.png");
    private final List<AnimatedButton> buttons = new ArrayList<AnimatedButton>();
    private Animation alphaAnimation = new Animation(800L, 1.0, true, Easing.OUT_EXPO);
    private float time = 0.0f;

    public MainMenu() {
        super((class_2561)class_2561.method_43470((String)"MainMenu"));
    }

    protected void method_25426() {
        this.buttons.clear();
        float btnWidth = 160.0f;
        float btnHeight = 20.0f;
        float margin = 5.0f;
        float startX = (float)this.field_22789 / 2.0f - btnWidth / 2.0f;
        float startY = (float)this.field_22790 / 2.0f - 10.0f;
        this.buttons.add(new AnimatedButton(startX, startY, btnWidth, btnHeight, class_1074.method_4662((String)"phantomvisuals.mainmenu.singleplayer", (Object[])new Object[0]), btn -> this.field_22787.method_1507((class_437)new class_526((class_437)this))));
        this.buttons.add(new AnimatedButton(startX, startY + (btnHeight + margin), btnWidth, btnHeight, class_1074.method_4662((String)"phantomvisuals.mainmenu.multiplayer", (Object[])new Object[0]), btn -> this.field_22787.method_1507((class_437)new class_500((class_437)this))));
        this.buttons.add(new AnimatedButton(startX, startY + (btnHeight + margin) * 2.0f, btnWidth, btnHeight, class_1074.method_4662((String)"phantomvisuals.mainmenu.altmanager", (Object[])new Object[0]), btn -> this.field_22787.method_1507((class_437)new AltManagerScreen(this))));
        this.buttons.add(new AnimatedButton(startX, startY + (btnHeight + margin) * 3.0f, btnWidth, btnHeight, class_1074.method_4662((String)"phantomvisuals.mainmenu.options", (Object[])new Object[0]), btn -> this.field_22787.method_1507((class_437)new class_429((class_437)this, this.field_22787.field_1690))));
        this.buttons.add(new AnimatedButton(startX, startY + (btnHeight + margin) * 4.0f, btnWidth, btnHeight, class_1074.method_4662((String)"phantomvisuals.mainmenu.quit", (Object[])new Object[0]), btn -> this.field_22787.method_1592()));
    }

    public void drawCustomTexture(class_4587 stack, float x, float y, float width, float height, float radius, class_2960 texture, Color color) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.time += delta * 0.05f;
        float alpha = this.alphaAnimation.getValue();
        Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
        RenderSystem.enableBlend();
        this.drawCustomTexture(drawContext.method_51448(), 0.0f, 0.0f, this.field_22789, this.field_22790, 0.0f, BACKGROUND_TEXTURE, new Color(255, 255, 255, (int)(alpha * 255.0f)));
        ((BuiltRectangle)new RectangleBuilder().size(new SizeState(this.field_22789, this.field_22790)).color(new QuadColorState(new Color(0, 0, 0, 130))).build()).render(matrix, 0.0f, 0.0f, 0.0f);
        ((BuiltBlur)new BlurBuilder().size(new SizeState(this.field_22789, this.field_22790)).blurRadius(12.0f * alpha).build()).render(matrix, 0.0f, 0.0f, 0.0f);
        String prefix = "Good to see you, ";
        String username = this.field_22787.method_1548().method_1676();
        String welcomeText = "Welcome, The Best Visuals Phantom Visuals <3";
        float textScale = 12.0f;
        float prefixWidth = Fonts.BOLD.getWidth(prefix, textScale);
        float totalMainWidth = prefixWidth + Fonts.BOLD.getWidth(username, textScale);
        float mainX = (float)this.field_22789 / 2.0f - totalMainWidth / 2.0f;
        float mainY = (float)this.field_22790 / 2.0f - 65.0f;
        ((BuiltText)new TextBuilder().font(Fonts.BOLD.font()).text(prefix).size(textScale).color(new Color(255, 255, 255, (int)(alpha * 255.0f))).build()).render(matrix, mainX, mainY, 0.0f);
        float currentX = mainX + prefixWidth;
        for (int i = 0; i < username.length(); ++i) {
            String charStr = String.valueOf(username.charAt(i));
            int c = (int)((Math.sin(this.time * 0.5f + (float)i * 0.4f) * 0.5 + 0.5) * 255.0);
            ((BuiltText)new TextBuilder().font(Fonts.BOLD.font()).text(charStr).size(textScale).color(new Color(c, c, c, (int)(alpha * 255.0f))).build()).render(matrix, currentX, mainY, 0.0f);
            currentX += Fonts.BOLD.getWidth(charStr, textScale);
        }
        float subWidth = Fonts.REGULAR.getWidth(welcomeText, 7.0f);
        ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(welcomeText).size(7.0f).color(new Color(180, 150, 255, (int)(alpha * 180.0f))).build()).render(matrix, (float)this.field_22789 / 2.0f - subWidth / 2.0f, mainY + 16.0f, 0.0f);
        for (AnimatedButton btn : this.buttons) {
            btn.render(drawContext, mouseX, mouseY, delta, alpha, this.time);
        }
        this.renderFooter(matrix, alpha);
    }

    private void renderFooter(Matrix4f matrix, float alpha) {
        ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text("PhantomVisuals v2.4").size(6.0f).color(new Color(100, 100, 100, (int)(alpha * 150.0f))).build()).render(matrix, 5.0f, this.field_22790 - 12, 0.0f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (AnimatedButton btn : this.buttons) {
            if (!btn.isMouseOver((int)mouseX, (int)mouseY)) continue;
            btn.onPress();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public static class AnimatedButton {
        private final float x;
        private final float y;
        private final float width;
        private final float height;
        private final String message;
        private final PressAction action;
        private final Animation hoverAnim = new Animation(200L, 1.0, false, Easing.OUT_EXPO);

        public AnimatedButton(float x, float y, float width, float height, String message, PressAction action) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.message = message;
            this.action = action;
        }

        public void render(class_332 drawContext, int mouseX, int mouseY, float delta, float alpha) {
            this.render(drawContext, mouseX, mouseY, delta, alpha, 0.0f);
        }

        public void render(class_332 drawContext, int mouseX, int mouseY, float delta, float alpha, float timeGlobal) {
            boolean isHovered = this.isMouseOver(mouseX, mouseY);
            this.hoverAnim.update(isHovered);
            float hVal = this.hoverAnim.getValue();
            Matrix4f matrix = drawContext.method_51448().method_23760().method_23761();
            float scalePadding = hVal * 3.0f;
            Color baseColor = new Color(20, 20, 25, (int)(alpha * 200.0f));
            Color grad1 = Color.getHSBColor(timeGlobal * 0.1f % 1.0f, 0.5f, 0.8f);
            Color grad2 = Color.getHSBColor((timeGlobal * 0.1f + 0.2f) % 1.0f, 0.5f, 0.8f);
            Color cTL = this.interpolate(baseColor, grad1, hVal * 0.4f);
            Color cTR = this.interpolate(baseColor, grad2, hVal * 0.4f);
            ((BuiltRectangle)new RectangleBuilder().size(new SizeState(this.width + scalePadding, this.height)).radius(new QuadRadiusState(5.0f)).color(new QuadColorState(cTL, cTR, cTL, cTR)).build()).render(matrix, this.x - scalePadding / 2.0f, this.y, 0.0f);
            float textWidth = Fonts.REGULAR.getWidth(this.message, 7.5f);
            ((BuiltText)new TextBuilder().font(Fonts.REGULAR.font()).text(this.message).size(7.5f).color(new Color(240, 240, 240, (int)(alpha * 255.0f))).build()).render(matrix, this.x + this.width / 2.0f - textWidth / 2.0f, this.y + this.height / 2.0f - 3.25f, 0.0f);
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return (float)mouseX >= this.x && (float)mouseX <= this.x + this.width && (float)mouseY >= this.y && (float)mouseY <= this.y + this.height;
        }

        public void onPress() {
            this.action.onPress(this);
        }

        private Color interpolate(Color c1, Color c2, float f) {
            return new Color((int)((float)c1.getRed() + (float)(c2.getRed() - c1.getRed()) * f), (int)((float)c1.getGreen() + (float)(c2.getGreen() - c1.getGreen()) * f), (int)((float)c1.getBlue() + (float)(c2.getBlue() - c1.getBlue()) * f), (int)((float)c1.getAlpha() + (float)(c2.getAlpha() - c1.getAlpha()) * f));
        }
    }

    public static interface PressAction {
        public void onPress(AnimatedButton var1);
    }
}

