/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.Particles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_243;

public class Particles {
    private final List<Particle> particles = new ArrayList<Particle>();
    private final Random random = new Random();

    public void clear() {
        this.particles.clear();
    }

    public boolean isEmpty() {
        return this.particles.isEmpty();
    }

    public void add(Particle particle) {
        this.particles.add(particle);
    }

    public Iterator<Particle> iterator() {
        return this.particles.iterator();
    }

    public void startScattering() {
        for (Particle p : this.particles) {
            p.startScattering();
        }
    }

    public static class Particle {
        private class_243 pos;
        private class_243 targetPos;
        private double angle;
        private double angleOffset;
        private double offsetY;
        private final float width;
        private final float height;
        private int age = 0;
        private final int maxAge;
        private boolean scattering = false;
        private double vx;
        private double vy;
        private double vz;
        private final List<class_243> trailPositions = new ArrayList<class_243>();
        private static final int MAX_TRAIL_LENGTH = 3;

        public Particle(class_243 pos, class_243 targetPos, float width, float height, boolean converging, int maxAge) {
            this.pos = pos;
            this.targetPos = targetPos;
            this.width = width;
            this.height = height;
            this.scattering = !converging;
            this.angle = 0.0;
            this.angleOffset = 0.0;
            this.offsetY = 0.0;
            this.maxAge = maxAge;
        }

        public Particle(class_243 origin, double angle, double angleOffset, double offsetY, float width, float height, int maxAge) {
            this.pos = origin;
            this.angle = angle;
            this.angleOffset = angleOffset;
            this.offsetY = offsetY;
            this.width = width;
            this.height = height;
            this.maxAge = maxAge;
        }

        public void startScattering() {
            this.scattering = true;
            Random random = new Random();
            this.vx = (random.nextDouble() - 0.5) * 0.19;
            this.vy = (random.nextDouble() - 0.5) * 0.19;
            this.vz = (random.nextDouble() - 0.5) * 0.19;
        }

        public void update(class_243 origin, double time, double omega, float animVal, boolean isSoulMode, double ghostRadius) {
            if (!this.scattering && this.trailPositions.size() < 3) {
                this.trailPositions.add(this.pos);
            } else if (this.trailPositions.size() >= 3) {
                this.trailPositions.remove(0);
                this.trailPositions.add(this.pos);
            }
            if (this.scattering) {
                this.pos = this.pos.method_1031(this.vx, this.vy, this.vz);
                this.vy += -0.002;
                this.vx *= 0.98;
                this.vy *= 0.98;
                this.vz *= 0.98;
                ++this.age;
            } else if (isSoulMode) {
                class_243 direction = this.targetPos.method_1020(this.pos).method_1029().method_1021(0.2);
                this.pos = this.pos.method_1019(direction);
                if (this.pos.method_1022(this.targetPos) < 0.05) {
                    this.age = this.maxAge;
                }
            } else {
                double currentRadius = ghostRadius * (2.0 - (double)animVal);
                double offsetX = Math.cos(this.angle + this.angleOffset) * currentRadius;
                double offsetZ = Math.sin(this.angle + this.angleOffset) * currentRadius;
                double currentOffsetY = Math.sin(time * omega * 0.5 + this.angleOffset) * 0.5 * (double)this.height + 0.5 * (double)this.height;
                this.pos = origin.method_1031(offsetX, (double)(-this.height) * 0.5 + currentOffsetY, offsetZ);
                this.angle += omega / 60.0;
            }
        }

        public float getLifeProgress() {
            return this.scattering ? 1.0f - (float)this.age / (float)this.maxAge : 1.0f;
        }

        public class_243 getPos() {
            return this.pos;
        }

        public double getAngle() {
            return this.angle;
        }

        public int getAge() {
            return this.age;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public boolean isScattering() {
            return this.scattering;
        }

        public List<class_243> getTrailPositions() {
            return this.trailPositions;
        }
    }
}

