/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.animations;

import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.math.TimerUtils;
import lombok.Generated;

public class Animation {
    private final TimerUtils timer = new TimerUtils();
    private long duration;
    private final Easing easing;
    private boolean forward;
    private double value;

    public Animation(long duration, double value, boolean forward, Easing easing) {
        this.duration = duration;
        this.value = value;
        this.forward = forward;
        this.easing = easing;
    }

    public void update(boolean forward) {
        if (this.forward != forward) {
            this.forward = forward;
            this.timer.setStartTime((long)((double)System.currentTimeMillis() - (this.value - Math.min(this.value, (double)this.timer.getElapsed()))));
        }
    }

    public boolean finished(boolean forward) {
        return this.timer.passed(this.duration) && forward == this.forward;
    }

    public boolean finished() {
        return this.timer.passed(this.duration) && this.forward;
    }

    public float getValue() {
        if (this.forward) {
            if (this.timer.passed(this.duration)) {
                return (float)this.value;
            }
            return (float)(this.easing.apply((double)this.timer.getElapsed() / (double)this.duration) * this.value);
        }
        if (this.timer.passed(this.duration)) {
            return 0.0f;
        }
        return (float)((1.0 - this.easing.apply((double)this.timer.getElapsed() / (double)this.duration)) * this.value);
    }

    public float getLinear() {
        if (this.forward) {
            if (this.timer.passed(this.duration)) {
                return (float)this.value;
            }
            return (float)((double)this.timer.getElapsed() / (double)this.duration * this.value);
        }
        if (this.timer.passed(this.duration)) {
            return 0.0f;
        }
        return (float)((1.0 - (double)this.timer.getElapsed() / (double)this.duration) * this.value);
    }

    public float getReversedValue() {
        return 1.0f - this.getValue();
    }

    public void reset() {
        this.timer.reset();
    }

    public void update() {
        if (this.finished()) {
            this.update(false);
        } else if (this.finished(false)) {
            this.update(true);
        }
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setValue(double value) {
        this.value = value;
    }
}

