/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.animations;

import java.util.function.Function;
import lombok.Generated;

public enum Easing {
    LINEAR(x -> x),
    BOTH_SINE(x -> -(Math.cos(Math.PI * x) - 1.0) / 2.0),
    BOTH_CIRC(x -> x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * x + 2.0, 2.0)) + 1.0) / 2.0),
    BOTH_CUBIC(x -> x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0),
    EASE_IN_OUT_QUART(x -> x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0),
    EASE_OUT_BACK(x -> 1.0 + 2.70158 * Math.pow(x - 1.0, 3.0) + 1.70158 * Math.pow(x - 1.0, 2.0)),
    EASE_OUT_CIRC(x -> Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0))),
    EASE_OUT_CUBIC(x -> 1.0 - Math.pow(1.0 - x, 3.0)),
    SMOOTH_STEP(x -> -2.0 * Math.pow(x, 3.0) + 3.0 * Math.pow(x, 2.0)),
    phantomvisuals(x -> 3.0 * Math.pow(1.0 - x, 2.0) * x * -0.2 + 3.0 * (1.0 - x) * Math.pow(x, 2.0) * 1.5 + Math.pow(x, 3.0)),
    OUT_QUAD(x -> x * (2.0 - x)),
    OUT_QUART(x -> 1.0 - Math.pow(1.0 - x, 4.0)),
    OUT_EXPO(x -> x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x)),
    OUT_ELASTIC(x -> {
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        double c4 = 2.0943951023931953;
        return Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * c4) + 1.0;
    }),
    OUT_BOUNCE(x -> {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 1.0 / d1) {
            return n1 * x * x;
        }
        if (x < 2.0 / d1) {
            x = x - 1.5 / d1;
            return n1 * x * x + 0.75;
        }
        if (x < 2.5 / d1) {
            x = x - 2.25 / d1;
            return n1 * x * x + 0.9375;
        }
        x = x - 2.625 / d1;
        return n1 * x * x + 0.984375;
    }),
    IN_OUT_BACK(x -> {
        double c1 = 1.70158;
        double c2 = c1 * 1.525;
        return x < 0.5 ? Math.pow(2.0 * x, 2.0) * ((c2 + 1.0) * 2.0 * x - c2) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * ((c2 + 1.0) * (x * 2.0 - 2.0) + c2) + 2.0) / 2.0;
    }),
    IN_OUT_ELASTIC(x -> {
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        double c5 = 1.3962634015954636;
        return x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * Math.sin((20.0 * x - 11.125) * c5)) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * Math.sin((20.0 * x - 11.125) * c5) / 2.0 + 1.0;
    }),
    FAST_OUT(x -> Math.pow(x, 0.5)),
    FAST_IN(x -> Math.pow(x, 2.0)),
    FAST_IN_OUT(x -> x < 0.5 ? 2.0 * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0),
    SPRING(x -> 1.0 - Math.cos(x * 4.5 * Math.PI) * Math.exp(-x.doubleValue() * 6.0)),
    BOUNCE_OUT(x -> {
        if (x < 0.36363636363636365) {
            return 121.0 * x * x / 16.0;
        }
        if (x < 0.7272727272727273) {
            return 9.075 * x * x - 9.9 * x + 3.4;
        }
        if (x < 0.9) {
            return 12.066481994459833 * x * x - 19.63545706371191 * x + 8.898060941828255;
        }
        return 10.8 * x * x - 20.52 * x + 10.72;
    });

    private final Function<Double, Double> function;

    public double apply(double arg) {
        return this.function.apply(arg);
    }

    public float apply(float arg) {
        return this.function.apply(Double.valueOf(arg)).floatValue();
    }

    @Generated
    private Easing(Function<Double, Double> function) {
        this.function = function;
    }
}

