/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.animations.infinity;

import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import lombok.Generated;

public class InfinityAnimation {
    private float output;
    private float endpoint;
    private Easing easing;
    private Animation animation = new Animation(0L, 0.0, false, Easing.LINEAR);

    public InfinityAnimation(Easing easing) {
        this.easing = easing;
    }

    public float animate(float value, long duration) {
        duration = Math.max(1L, duration);
        this.output = this.endpoint - this.animation.getValue();
        this.endpoint = value;
        if (this.output != this.endpoint - value) {
            this.animation = new Animation(duration, this.endpoint - this.output, false, this.easing);
        }
        return this.output;
    }

    public boolean finished() {
        return this.output == this.endpoint || this.animation.finished() || this.animation.finished(false);
    }

    public float getValue() {
        this.output = this.endpoint - this.animation.getValue();
        return this.output;
    }

    @Generated
    public void setEasing(Easing easing) {
        this.easing = easing;
    }

    @Generated
    public Animation getAnimation() {
        return this.animation;
    }
}

