/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public final class Async {
    private static final ExecutorService CPU_POOL;
    private static final AtomicInteger THREAD_ID;

    private Async() {
    }

    public static <T> Future<T> submit(Callable<T> task) {
        Objects.requireNonNull(task, "task");
        return CPU_POOL.submit(task);
    }

    public static Future<?> run(Runnable task) {
        Objects.requireNonNull(task, "task");
        return CPU_POOL.submit(task);
    }

    public static <T> List<T> awaitAll(List<Future<T>> futures, long timeout, TimeUnit unit) {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        ArrayList<T> results = new ArrayList<T>(futures.size());
        for (Future<T> f : futures) {
            long left = deadline - System.nanoTime();
            if (left <= 0L) break;
            try {
                results.add(f.get(left, TimeUnit.NANOSECONDS));
            }
            catch (TimeoutException te) {
                break;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException executionException) {
            }
        }
        return results;
    }

    public static int cpuCount() {
        return Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    static {
        THREAD_ID = new AtomicInteger(1);
        int cores = Math.max(2, Runtime.getRuntime().availableProcessors());
        int threads = Math.max(1, cores - 1);
        CPU_POOL = new ThreadPoolExecutor(threads, threads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), r -> {
            Thread t = new Thread(r, "SV-CPU-" + THREAD_ID.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }, new ThreadPoolExecutor.DiscardOldestPolicy());
    }
}

