/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.math;

import dev.phantomvisuals.client.util.Wrapper;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_9848;
import org.joml.Vector4f;

public class MathUtil
implements Wrapper {
    public static double round(double num, double increment) {
        double v = (double)Math.round(num / increment) * increment;
        BigDecimal bd = new BigDecimal(v);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double interpolate(double oldValue, double newValue, double interpolationValue) {
        return oldValue + (newValue - oldValue) * interpolationValue;
    }

    public static boolean isHovered(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height;
    }

    public static int applyOpacity(int color, float opacity) {
        return class_9848.method_61324((int)((int)((float)class_9848.method_61320((int)color) * opacity / 255.0f)), (int)class_9848.method_61327((int)color), (int)class_9848.method_61329((int)color), (int)class_9848.method_61331((int)color));
    }

    public static float fast(float end, float start, float multiple) {
        return (1.0f - MathUtil.clamp(MathUtil.deltaTime() * multiple, 0.0f, 1.0f)) * end + MathUtil.clamp(MathUtil.deltaTime() * multiple, 0.0f, 1.0f) * start;
    }

    public static float deltaTime() {
        return mc.method_61966().method_60637(true) / 20.0f;
    }

    public static float clamp(float val, float min, float max) {
        if (val <= min) {
            val = min;
        }
        if (val >= max) {
            val = max;
        }
        return val;
    }

    public static void scale(class_4587 stack, float x, float y, float scale, Runnable data) {
        stack.method_22903();
        stack.method_46416(x, y, 0.0f);
        stack.method_22905(scale, scale, 1.0f);
        stack.method_46416(-x, -y, 0.0f);
        data.run();
        stack.method_22909();
    }

    public static double computeGcd() {
        double f = (Double)MathUtil.mc.field_1690.method_42495().method_41753() * 0.6 + 0.2;
        return f * f * f * 8.0 * 0.15;
    }

    public static double getRandom(double min, double max) {
        if (min == max) {
            return min;
        }
        if (min > max) {
            double d = min;
            min = max;
            max = d;
        }
        return ThreadLocalRandom.current().nextDouble(min, max);
    }

    public static Color injectAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), class_3532.method_15340((int)alpha, (int)0, (int)255));
    }

    public static int interpolateColor(int startRGB, int endRGB, float progress) {
        int startR = startRGB >> 16 & 0xFF;
        int startG = startRGB >> 8 & 0xFF;
        int startB = startRGB & 0xFF;
        int endR = endRGB >> 16 & 0xFF;
        int endG = endRGB >> 8 & 0xFF;
        int endB = endRGB & 0xFF;
        int r = (int)((float)startR + (float)(endR - startR) * progress);
        int g = (int)((float)startG + (float)(endG - startG) * progress);
        int b = (int)((float)startB + (float)(endB - startB) * progress);
        return r << 16 | g << 8 | b;
    }

    public static Vector4f calculateRotationFromCamera(class_1309 target) {
        class_243 vec = target.method_19538().method_1020(MathUtil.mc.field_1724.method_33571());
        float rawYaw = (float)class_3532.method_15338((double)(Math.toDegrees(Math.atan2(vec.field_1350, vec.field_1352)) - 90.0));
        float rawPitch = (float)(-Math.toDegrees(Math.atan2(vec.field_1351, Math.sqrt(Math.pow(vec.field_1352, 2.0) + Math.pow(vec.field_1350, 2.0)))));
        float yawDelta = class_3532.method_15393((float)(rawYaw - MathUtil.mc.field_1724.method_36454()));
        float pitchDelta = rawPitch - MathUtil.mc.field_1724.method_36455();
        return new Vector4f(rawYaw, rawPitch, yawDelta, pitchDelta);
    }

    public static double calculateFOVFromCamera(class_1309 target) {
        Vector4f rotation = MathUtil.calculateRotationFromCamera(target);
        float yawDelta = rotation.z;
        float pitchDelta = rotation.w;
        return Math.sqrt(yawDelta * yawDelta + pitchDelta * pitchDelta);
    }

    public static double getTickDelta() {
        return mc.method_61966().method_60637(true);
    }

    public static int setAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static void scaleStart(class_4587 poseStack, float x, float y, float scale) {
        poseStack.method_22903();
        poseStack.method_46416(x, y, 0.0f);
        poseStack.method_22905(scale, scale, 1.0f);
        poseStack.method_46416(-x, -y, 0.0f);
    }

    public static void scaleEnd(class_4587 poseStack) {
        poseStack.method_22909();
    }

    public static double distanceToSqr(double pX, double pY, double pZ) {
        double d0 = MathUtil.mc.field_1724.method_23317() - pX;
        double d1 = MathUtil.mc.field_1724.method_23318() - pY;
        double d2 = MathUtil.mc.field_1724.method_23321() - pZ;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public static int reAlphaInt(int color, int alpha) {
        alpha = class_3532.method_15340((int)alpha, (int)0, (int)255);
        int rgb = color & 0xFFFFFF;
        return alpha << 24 | rgb;
    }

    public static void executeOnMainThread(Runnable runnable) {
        mc.execute(runnable);
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

