/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.math;

import dev.phantomvisuals.client.util.Wrapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public final class MathUtils
implements Wrapper {
    public static boolean isHovered(float x, float y, float width, float height, float mouseX, float mouseY) {
        return mouseX > x && mouseX < x + width && mouseY > y && mouseY < y + height;
    }

    public static float randomFloat(float min, float max) {
        return (float)(Math.random() * (double)(max - min) + (double)min);
    }

    public static int randomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public static float round(float number) {
        return (float)Math.round(number * 10.0f) / 10.0f;
    }

    public static float round(float num, float increment) {
        float value = (float)Math.round(num / increment) * increment;
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(2, RoundingMode.HALF_UP);
        return bd.floatValue();
    }

    public static class_243 transform(Matrix4f matrix, float x, float y, float z) {
        Vector3f vector3f = matrix.transformPosition(x, y, z, new Vector3f());
        return new class_243((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z());
    }

    public static String getCurrentTime() {
        ZonedDateTime date = ZonedDateTime.ofInstant(Instant.ofEpochMilli(System.currentTimeMillis()), ZoneId.of("Europe/Moscow"));
        return date.format(DateTimeFormatter.ofPattern("HH:mm"));
    }

    public static boolean inFov(class_243 pos, int fov, float yaw) {
        double deltaX = pos.method_10216() - MathUtils.mc.field_1724.method_23317();
        double deltaZ = pos.method_10215() - MathUtils.mc.field_1724.method_23321();
        float angle = (float)Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0f;
        float yawDelta = class_3532.method_15393((float)(angle - yaw));
        return Math.abs(yawDelta) <= (float)fov;
    }

    public static float getStep(float current, float target, float step) {
        if (Math.abs(target - current) <= step) {
            return target;
        }
        return current + Math.signum(target - current) * step;
    }

    @Generated
    private MathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

