/*
 * Decompiled with CFR 0.152.
 */
package dev.phantomvisuals.client.util.notify;

import dev.phantomvisuals.client.events.impl.EventRender2D;
import dev.phantomvisuals.client.util.Wrapper;
import dev.phantomvisuals.client.util.animations.Animation;
import dev.phantomvisuals.client.util.animations.Easing;
import dev.phantomvisuals.client.util.math.TimerUtils;
import dev.phantomvisuals.client.util.notify.NotifyIcon;
import dev.phantomvisuals.client.util.renderer.Render2D;
import dev.phantomvisuals.client.util.renderer.fonts.Fonts;
import java.awt.Color;
import lombok.Generated;

public class Notify
implements Wrapper {
    private final NotifyIcon icon;
    private final String notify;
    private final long delay;
    private float y;
    private final Animation animation = new Animation(300L, 1.0, true, Easing.BOTH_SINE);
    private final TimerUtils timer = new TimerUtils();

    public Notify(NotifyIcon icon, String notify, long delay) {
        this.icon = icon;
        this.notify = notify;
        this.delay = delay;
        this.y = (float)mc.method_22683().method_4502() / 2.0f + 10.0f;
        this.timer.reset();
    }

    public void render(EventRender2D e, float picunY) {
        this.y = this.animate(this.y, picunY);
        float width = Fonts.MEDIUM.getWidth(this.notify, 9.0f);
        float width2 = Fonts.ICONS.getWidth(this.icon.icon(), 8.0f);
        float width3 = width + width2 + 7.0f;
        float x = (float)mc.method_22683().method_4486() / 2.0f - width3 / 2.0f;
        if (this.timer.passed(this.delay)) {
            this.animation.update(false);
        }
        float animA = this.animation.getValue();
        int bgA = (int)(175.0f * animA);
        int blurA = (int)(40.0f * animA);
        Render2D.drawShaderBlurRect(e.getContext().method_51448(), x - 3.5f, this.y - 3.5f, width3 + 7.0f, 17.0f, 2.0f, 8.0f, new Color(255, 255, 255, blurA));
        Render2D.drawRoundedRect(e.getContext().method_51448(), x - 2.5f, this.y - 2.5f, width3 + 5.0f, 15.0f, 1.5f, new Color(0, 0, 0, bgA));
        Render2D.drawFont(e.getContext().method_51448(), Fonts.MEDIUM.getFont(9.0f), this.notify, x + width2 + 4.0f, this.y - 0.5f, new Color(255, 255, 255, (int)(255.0f * this.animation.getValue())));
        Render2D.drawFont(e.getContext().method_51448(), Fonts.ICONS.getFont(8.0f), this.icon.icon(), x + 1.0f, this.y + 1.0f, new Color(255, 255, 255, (int)(255.0f * this.animation.getValue())));
    }

    public float animate(float value, float target) {
        return value + (target - value) / 8.0f;
    }

    public boolean expired() {
        return this.timer.passed(this.delay) && this.animation.getValue() < 0.01f;
    }

    @Generated
    public NotifyIcon getIcon() {
        return this.icon;
    }

    @Generated
    public String getNotify() {
        return this.notify;
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public Animation getAnimation() {
        return this.animation;
    }

    @Generated
    public TimerUtils getTimer() {
        return this.timer;
    }
}

